/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter
implements javax.servlet.Filter {
    public static final String NO_FILTER = "NO_FILTER";
    private static final Logger LOG = LoggerFactory.getLogger(Filter.class);
    protected FilterConfig filterConfig;
    protected String exceptionsToLogDifferently;
    protected boolean suppressStackTraces;

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            if (this.filterNotDisabled(httpRequest)) {
                this.doFilter(httpRequest, httpResponse, chain);
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Throwable throwable) {
            this.logThrowable(throwable, httpRequest);
        }
    }

    protected boolean filterNotDisabled(HttpServletRequest httpRequest) {
        return httpRequest.getAttribute(NO_FILTER) == null;
    }

    private void logThrowable(Throwable throwable, HttpServletRequest httpRequest) throws ServletException, IOException {
        StringBuffer messageBuffer = new StringBuffer("Throwable thrown during doFilter on request with URI: ").append(httpRequest.getRequestURI()).append(" and Query: ").append(httpRequest.getQueryString());
        String message = messageBuffer.toString();
        boolean matchFound = this.matches(throwable);
        if (matchFound) {
            try {
                if (this.suppressStackTraces) {
                    LOG.error(throwable.getMessage());
                } else {
                    LOG.error(throwable.getMessage(), throwable);
                }
            }
            catch (Exception e) {
                LOG.error("Could not invoke Log method", (Throwable)e);
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new ServletException(message, throwable);
        }
        if (this.suppressStackTraces) {
            LOG.warn(messageBuffer.append(throwable.getMessage()).append("\nTop StackTraceElement: ").append(throwable.getStackTrace()[0].toString()).toString());
        } else {
            LOG.warn(messageBuffer.append(throwable.getMessage()).toString(), throwable);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new ServletException(throwable);
    }

    private boolean matches(Throwable throwable) {
        Throwable cause;
        Throwable rootCause;
        if (this.exceptionsToLogDifferently == null) {
            return false;
        }
        if (this.exceptionsToLogDifferently.indexOf(throwable.getClass().getName()) != -1) {
            return true;
        }
        if (throwable instanceof ServletException && this.exceptionsToLogDifferently.indexOf((rootCause = ((ServletException)throwable).getRootCause()).getClass().getName()) != -1) {
            return true;
        }
        return throwable.getCause() != null && this.exceptionsToLogDifferently.indexOf((cause = throwable.getCause()).getClass().getName()) != -1;
    }

    public final void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.filterConfig = filterConfig;
            this.processInitParams(filterConfig);
            this.doInit(filterConfig);
        }
        catch (Exception e) {
            LOG.error("Could not initialise servlet filter.", (Throwable)e);
            throw new ServletException("Could not initialise servlet filter.", (Throwable)e);
        }
    }

    protected void processInitParams(FilterConfig config) throws ServletException {
        String exceptions = config.getInitParameter("exceptionsToLogDifferently");
        String level = config.getInitParameter("exceptionsToLogDifferentlyLevel");
        String suppressStackTracesString = config.getInitParameter("suppressStackTraces");
        this.suppressStackTraces = Boolean.valueOf(suppressStackTracesString);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Suppression of stack traces enabled for " + this.getClass().getName());
        }
        if (exceptions != null) {
            this.validateMandatoryParameters(exceptions, level);
            this.exceptionsToLogDifferently = exceptions;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Different logging levels configured for " + this.getClass().getName());
            }
        }
    }

    private void validateMandatoryParameters(String exceptions, String level) throws ServletException {
        if (exceptions != null && level == null || level != null && exceptions == null) {
            throw new ServletException("Invalid init-params. Both exceptionsToLogDifferently and exceptionsToLogDifferentlyLevelvalue should be specified if one is specified.");
        }
    }

    public final void destroy() {
        this.filterConfig = null;
        this.doDestroy();
    }

    protected boolean acceptsEncoding(HttpServletRequest request, String name) {
        boolean accepts = this.headerContains(request, "Accept-Encoding", name);
        return accepts;
    }

    private boolean headerContains(HttpServletRequest request, String header, String value) {
        this.logRequestHeaders(request);
        Enumeration accepted = request.getHeaders(header);
        while (accepted.hasMoreElements()) {
            String headerValue = (String)accepted.nextElement();
            if (headerValue.indexOf(value) == -1) continue;
            return true;
        }
        return false;
    }

    protected void logRequestHeaders(HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration enumeration = request.getHeaderNames();
            StringBuffer logLine = new StringBuffer();
            logLine.append("Request Headers");
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String headerValue = request.getHeader(name);
                headers.put(name, headerValue);
                logLine.append(": ").append(name).append(" -> ").append(headerValue);
            }
            LOG.debug(logLine.toString());
        }
    }

    protected abstract void doDestroy();

    protected abstract void doFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws Throwable;

    protected abstract void doInit(FilterConfig var1) throws Exception;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest request) {
        return this.acceptsEncoding(request, "gzip");
    }
}

