/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.LinkedList;
import org.owasp.esapi.ESAPI;

public class RequestRateThrottleFilter
implements Filter {
    private int hits = 5;
    private int period = 10;
    private static final String HITS = "hits";
    private static final String PERIOD = "period";

    public void init(FilterConfig filterConfig) {
        this.hits = filterConfig.getInitParameter(HITS) == null ? 5 : Integer.parseInt(filterConfig.getInitParameter(HITS));
        this.period = filterConfig.getInitParameter(PERIOD) == null ? 10 : Integer.parseInt(filterConfig.getInitParameter(PERIOD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(true);
        String string = session.getId().intern();
        synchronized (string) {
            LinkedList<Long> times = (LinkedList<Long>)ESAPI.httpUtilities().getSessionAttribute("times");
            if (times == null) {
                times = new LinkedList<Long>();
                session.setAttribute("times", times);
            }
            Long newest = System.currentTimeMillis();
            times.add(newest);
            if (times.size() > this.hits) {
                Long oldest = (Long)times.remove(0);
                long elapsed = newest - oldest;
                if (elapsed < (long)(this.period * 1000)) {
                    response.getWriter().println("Request rate too high");
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

