/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.filters;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.SecurityConfiguration;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.ValidationErrorList;
import org.owasp.esapi.errors.IntrusionException;
import org.owasp.esapi.errors.ValidationException;

public class SecurityWrapperResponse
extends HttpServletResponseWrapper
implements HttpServletResponse {
    private final Logger logger = ESAPI.getLogger("SecurityWrapperResponse");
    private String mode = "log";

    public SecurityWrapperResponse(HttpServletResponse response) {
        super(response);
    }

    public SecurityWrapperResponse(HttpServletResponse response, String mode) {
        super(response);
        this.mode = mode;
    }

    private HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    public void addCookie(Cookie cookie) {
        String name = cookie.getName();
        String value = cookie.getValue();
        int maxAge = cookie.getMaxAge();
        String domain = cookie.getDomain();
        String path = cookie.getPath();
        boolean secure = cookie.getSecure();
        SecurityConfiguration sc = ESAPI.securityConfiguration();
        ValidationErrorList errors = new ValidationErrorList();
        String cookieName = ESAPI.validator().getValidInput("cookie name", name, "HTTPCookieName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false, errors);
        String cookieValue = ESAPI.validator().getValidInput("cookie value", value, "HTTPCookieValue", sc.getIntProp("HttpUtilities.MaxHeaderValueSize"), false, errors);
        if (errors.size() == 0) {
            String header = this.createCookieHeader(name, value, maxAge, domain, path, secure);
            this.addHeader("Set-Cookie", header);
            return;
        }
        if (this.mode.equals("skip")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (skip mode). Skipping cookie and continuing.");
            return;
        }
        if (this.mode.equals("log")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (log mode). Adding unsafe cookie anyway and continuing.");
            this.getHttpServletResponse().addCookie(cookie);
            return;
        }
        if (this.mode.equals("sanitize")) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add unsafe data to cookie (sanitize mode). Sanitizing cookie and continuing.");
            String header = this.createCookieHeader(cookieName, cookieValue, maxAge, domain, path, secure);
            this.addHeader("Set-Cookie", header);
            return;
        }
        throw new IntrusionException("Security error", "Attempt to add unsafe data to cookie (throw mode)");
    }

    private String createCookieHeader(String name, String value, int maxAge, String domain, String path, boolean secure) {
        String header = name + "=" + value;
        if (maxAge >= 0) {
            header = header + "; Max-Age=" + maxAge;
        }
        if (domain != null) {
            header = header + "; Domain=" + domain;
        }
        if (path != null) {
            header = header + "; Path=" + path;
        }
        if (secure || ESAPI.securityConfiguration().getBooleanProp("HttpUtilities.ForceSecureCookies").booleanValue()) {
            header = header + "; Secure";
        }
        if (ESAPI.securityConfiguration().getBooleanProp("HttpUtilities.ForceHttpOnlyCookies").booleanValue()) {
            header = header + "; HttpOnly";
        }
        return header;
    }

    public void addDateHeader(String name, long date) {
        try {
            SecurityConfiguration sc = ESAPI.securityConfiguration();
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
            this.getHttpServletResponse().addDateHeader(safeName, date);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid date header name denied", e);
        }
    }

    public void addHeader(String name, String value) {
        SecurityConfiguration sc = ESAPI.securityConfiguration();
        String strippedName = StringUtilities.stripControls(name);
        String strippedValue = StringUtilities.stripControls(value);
        String safeName = null;
        String safeValue = null;
        try {
            safeName = ESAPI.validator().getValidInput("addHeader", strippedName, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add invalid header NAME denied: HTTPHeaderName:" + name, e);
        }
        try {
            safeValue = ESAPI.validator().getValidInput("addHeader", strippedValue, "HTTPHeaderValue", sc.getIntProp("HttpUtilities.MaxHeaderValueSize"), false);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to add invalid header VALUE denied: HTTPHeaderName:" + name, e);
        }
        boolean validName = StringUtilities.notNullOrEmpty(safeName, true);
        boolean validValue = StringUtilities.notNullOrEmpty(safeValue, true);
        if (validName && validValue) {
            this.getHttpServletResponse().addHeader(safeName, safeValue);
        }
    }

    public void addReferer(String uri) {
        String strippedValue = StringUtilities.stripControls(uri);
        boolean isValidURI = ESAPI.validator().isValidURI("refererHeader", strippedValue, false);
        String safeValue = "";
        if (isValidURI) {
            safeValue = strippedValue;
        }
        this.getHttpServletResponse().addHeader("referer", safeValue);
    }

    public void addIntHeader(String name, int value) {
        try {
            SecurityConfiguration sc = ESAPI.securityConfiguration();
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
            this.getHttpServletResponse().addIntHeader(safeName, value);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid int header name denied", e);
        }
    }

    public boolean containsHeader(String name) {
        return this.getHttpServletResponse().containsHeader(name);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public void flushBuffer() throws IOException {
        this.getHttpServletResponse().flushBuffer();
    }

    public int getBufferSize() {
        return this.getHttpServletResponse().getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.getHttpServletResponse().getCharacterEncoding();
    }

    public String getContentType() {
        return this.getHttpServletResponse().getContentType();
    }

    public Locale getLocale() {
        return this.getHttpServletResponse().getLocale();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.getHttpServletResponse().getOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        return this.getHttpServletResponse().getWriter();
    }

    public boolean isCommitted() {
        return this.getHttpServletResponse().isCommitted();
    }

    public void reset() {
        this.getHttpServletResponse().reset();
    }

    public void resetBuffer() {
        this.getHttpServletResponse().resetBuffer();
    }

    public void sendError(int sc) throws IOException {
        SecurityConfiguration config = ESAPI.securityConfiguration();
        if (config.getBooleanProp("HttpUtilities.OverwriteStatusCodes").booleanValue()) {
            this.getHttpServletResponse().sendError(200, this.getHTTPMessage(sc));
        } else {
            this.getHttpServletResponse().sendError(sc, this.getHTTPMessage(sc));
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        SecurityConfiguration config = ESAPI.securityConfiguration();
        if (config.getBooleanProp("HttpUtilities.OverwriteStatusCodes").booleanValue()) {
            this.getHttpServletResponse().sendError(200, ESAPI.encoder().encodeForHTML(msg));
        } else {
            this.getHttpServletResponse().sendError(sc, ESAPI.encoder().encodeForHTML(msg));
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (!ESAPI.validator().isValidRedirectLocation("Redirect", location, false)) {
            this.logger.fatal(Logger.SECURITY_FAILURE, "Bad redirect location: " + location);
            throw new IOException("Redirect failed");
        }
        this.getHttpServletResponse().sendRedirect(location);
    }

    public void setBufferSize(int size) {
        this.getHttpServletResponse().setBufferSize(size);
    }

    public void setCharacterEncoding(String charset) {
        SecurityConfiguration sc = ESAPI.securityConfiguration();
        this.getHttpServletResponse().setCharacterEncoding(sc.getStringProp("HttpUtilities.CharacterEncoding"));
    }

    public void setContentLength(int len) {
        this.getHttpServletResponse().setContentLength(len);
    }

    public void setContentType(String type) {
        this.getHttpServletResponse().setContentType(type);
    }

    public void setDateHeader(String name, long date) {
        try {
            SecurityConfiguration sc = ESAPI.securityConfiguration();
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
            this.getHttpServletResponse().setDateHeader(safeName, date);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid date header name denied", e);
        }
    }

    public void setHeader(String name, String value) {
        SecurityConfiguration sc = ESAPI.securityConfiguration();
        String strippedName = StringUtilities.stripControls(name);
        String strippedValue = StringUtilities.stripControls(value);
        String safeName = null;
        String safeValue = null;
        try {
            safeName = ESAPI.validator().getValidInput("setHeader", strippedName, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid header NAME denied: HTTPHeaderName:" + name, e);
        }
        try {
            safeValue = ESAPI.validator().getValidInput("setHeader", strippedValue, "HTTPHeaderValue", sc.getIntProp("HttpUtilities.MaxHeaderValueSize"), false);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid header VALUE denied: HTTPHeaderName:" + name, e);
        }
        boolean validName = StringUtilities.notNullOrEmpty(safeName, true);
        boolean validValue = StringUtilities.notNullOrEmpty(safeValue, true);
        if (validName && validValue) {
            this.getHttpServletResponse().setHeader(safeName, safeValue);
        }
    }

    public void setIntHeader(String name, int value) {
        try {
            SecurityConfiguration sc = ESAPI.securityConfiguration();
            String safeName = ESAPI.validator().getValidInput("safeSetDateHeader", name, "HTTPHeaderName", sc.getIntProp("HttpUtilities.MaxHeaderNameSize"), false);
            this.getHttpServletResponse().setIntHeader(safeName, value);
        }
        catch (ValidationException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set invalid int header name denied", e);
        }
    }

    public void setLocale(Locale loc) {
        this.getHttpServletResponse().setLocale(loc);
    }

    public void setStatus(int sc) {
        SecurityConfiguration config = ESAPI.securityConfiguration();
        if (config.getBooleanProp("HttpUtilities.OverwriteStatusCodes").booleanValue()) {
            this.getHttpServletResponse().setStatus(200);
        } else {
            this.getHttpServletResponse().setStatus(sc);
        }
    }

    @Deprecated
    public void setStatus(int sc, String sm) {
        try {
            SecurityConfiguration config = ESAPI.securityConfiguration();
            if (config.getBooleanProp("HttpUtilities.OverwriteStatusCodes").booleanValue()) {
                this.sendError(200, sm);
            } else {
                this.sendError(sc, sm);
            }
        }
        catch (IOException e) {
            this.logger.warning(Logger.SECURITY_FAILURE, "Attempt to set response status failed", e);
        }
    }

    private String getHTTPMessage(int sc) {
        return "HTTP error code: " + sc;
    }
}

