/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.appender;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.User;

public class ClientInfoSupplier {
    private static final String DEFAULT_LAST_HOST = "#UNKNOWN_HOST#";
    private static final String ESAPI_SESSION_ATTR = "ESAPI_SESSION";
    private static final int ESAPI_SESSION_RAND_MIN = 0;
    private static final int ESAPI_SESSION_RAND_MAX = 1000000;
    private static final String USER_INFO_FORMAT = "%s@%s";
    private boolean logClientInfo = true;

    public String get() {
        String clientInfo = "";
        if (this.logClientInfo) {
            User user;
            HttpSession session;
            HttpServletRequest request = ESAPI.currentRequest();
            String sid = "";
            if (request != null && (session = request.getSession(false)) != null && (sid = (String)session.getAttribute(ESAPI_SESSION_ATTR)) == null) {
                sid = "" + ESAPI.randomizer().getRandomInteger(0, 1000000);
                session.setAttribute(ESAPI_SESSION_ATTR, (Object)sid);
            }
            clientInfo = (user = ESAPI.authenticator().getCurrentUser()) == null ? String.format(USER_INFO_FORMAT, sid, DEFAULT_LAST_HOST) : String.format(USER_INFO_FORMAT, sid, user.getLastHostAddress());
        }
        return clientInfo;
    }

    public void setLogClientInfo(boolean log) {
        this.logClientInfo = log;
    }
}

