/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.waf.rules;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.regex.Pattern;
import org.owasp.esapi.waf.actions.Action;
import org.owasp.esapi.waf.actions.DefaultAction;
import org.owasp.esapi.waf.actions.DoNothingAction;
import org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import org.owasp.esapi.waf.rules.Rule;

public class AuthenticatedRule
extends Rule {
    private String sessionAttribute;
    private Pattern path;
    private List<Object> exceptions;

    public AuthenticatedRule(String id, String sessionAttribute, Pattern path, List<Object> exceptions) {
        this.sessionAttribute = sessionAttribute;
        this.path = path;
        this.exceptions = exceptions;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        HttpSession session = request.getSession();
        String uri = request.getRequestURI();
        if (this.path != null && !this.path.matcher(uri).matches()) {
            return new DoNothingAction();
        }
        if (session != null && session.getAttribute(this.sessionAttribute) != null) {
            return new DoNothingAction();
        }
        for (Object o : this.exceptions) {
            Pattern p;
            if (!(o instanceof Pattern ? (p = (Pattern)o).matcher(uri).matches() : o instanceof String && uri.equals((String)o))) continue;
            return new DoNothingAction();
        }
        this.log(request, "User requested unauthenticated access to URI '" + request.getRequestURI() + "' [querystring=" + request.getQueryString() + "]");
        return new DefaultAction();
    }
}

