/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.simple;

import jakarta.ws.rs.core.Application;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;
import org.glassfish.jersey.simple.SimpleContainer;
import org.glassfish.jersey.simple.SimpleContainerFactory;
import org.glassfish.jersey.simple.SimpleServer;

final class SimpleHttpServer
implements WebServer {
    private final SimpleContainer container;
    private final SimpleServer simpleServer;

    SimpleHttpServer(Application application, JerseySeBootstrapConfiguration configuration) {
        this(new SimpleContainer(application), configuration);
    }

    SimpleHttpServer(Class<? extends Application> applicationClass, JerseySeBootstrapConfiguration configuration) {
        this(new SimpleContainer(applicationClass), configuration);
    }

    SimpleHttpServer(SimpleContainer container, JerseySeBootstrapConfiguration configuration) {
        this.container = container;
        this.simpleServer = SimpleContainerFactory.create(configuration.uri(true), configuration.sslContext(), configuration.sslClientAuthentication(), this.container, configuration.autoStart());
    }

    public final SimpleContainer container() {
        return this.container;
    }

    public final int port() {
        return this.simpleServer.getPort();
    }

    public final CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.simpleServer.start();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.simpleServer.close();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    public final <T> T unwrap(Class<T> nativeClass) {
        return nativeClass.cast(this.simpleServer);
    }
}

