/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.DecryptedState;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.EnableEncryption;
import java.util.HashMap;
import java.util.Map;

public class EncryptionImpl
implements EnableEncryption {
    private EncryptionState decryptionHandle = null;
    private EncryptionState encryptionHandle = null;
    private SecurityHandler securityHandler = null;

    public void setDecryptionSecurityManager(SecurityManager secMgr, Map encryptParms, byte[] id) throws PDFSecurityAuthorizationException {
        if (this.decryptionHandle != null) {
            throw new PDFSecurityAuthorizationException("Cannot unlock again already unlocked document");
        }
        this.decryptionHandle = new EncryptionState(secMgr, encryptParms, id);
    }

    public void setEncryptionSecurityManager(SecurityManager secMgr, Map encryptParms, byte[] id) {
        this.encryptionHandle = new EncryptionState(secMgr, encryptParms, id);
    }

    public void resetEncryptionSecurityManager() {
        this.encryptionHandle = null;
    }

    public void resetDecryptionSecurityManager() {
        this.decryptionHandle = null;
        this.resetEncryptionSecurityManager();
    }

    public SecurityManager getEncryptionSecurityManager() {
        return this.encryptionHandle != null ? this.encryptionHandle.getSecurityManager() : null;
    }

    public SecurityManager getDecryptionSecurityManager() {
        return this.decryptionHandle == null ? null : this.decryptionHandle.getSecurityManager();
    }

    public Map getDecryptionParameters() throws PDFSecurityAuthorizationException {
        if (this.decryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        return this.decryptionHandle.getEncryptionParams();
    }

    public Map getEncryptionParameters() throws PDFSecurityAuthorizationException {
        if (this.encryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for encryption is not set");
        }
        return this.encryptionHandle.getEncryptionParams();
    }

    public boolean authenticateSecurity(SecurityHandler handler) throws PDFSecurityAuthorizationException, PDFSecurityConfigurationException {
        if (this.decryptionHandle == null) {
            throw new PDFSecurityConfigurationException("Security Manager for decryption is not set");
        }
        return this.authenticateSecurity(handler, null);
    }

    public boolean authenticateSecurity(Map params, byte[] docID, SecurityHandler handler, DecryptedState decryptedState) throws PDFSecurityAuthorizationException, PDFSecurityConfigurationException {
        try {
            this.securityHandler = handler;
            if (decryptedState == null) {
                return handler.authenticate(params, docID);
            }
            return handler.authenticate(params, docID, decryptedState);
        }
        catch (PDFSecurityAuthorizationException e) {
            this.resetDecryptionSecurityManager();
            throw e;
        }
        catch (PDFSecurityConfigurationException e1) {
            this.resetDecryptionSecurityManager();
            throw e1;
        }
    }

    public boolean authenticateSecurity(SecurityHandler handler, DecryptedState decryptedState) throws PDFSecurityAuthorizationException, PDFSecurityConfigurationException {
        if (this.decryptionHandle == null) {
            throw new PDFSecurityConfigurationException("Security Manager for decryption is not set");
        }
        return this.authenticateSecurity(this.getDecryptionParameters(), this.decryptionHandle.getDocID(), handler, decryptedState);
    }

    public byte[] encryptString(byte[] content, byte[] addKey) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if (this.encryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        EncryptionHandler encryption = this.getStringEncryption(this.encryptionHandle);
        return encryption.encrypt(content, addKey);
    }

    public byte[] decryptString(byte[] content, byte[] addKey) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if (this.decryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        EncryptionHandler encryption = this.getStringEncryption(this.decryptionHandle);
        return encryption.decrypt(content, addKey);
    }

    public void encryptStream(String name, InputByteStream src, OutputByteStream dest, byte[] addKey) throws PDFSecurityConfigurationException, PDFIOException, PDFSecurityAuthorizationException {
        if (this.encryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        EncryptionHandler encryption = this.getStreamEncryption(name, this.encryptionHandle);
        encryption.encrypt(src, dest, addKey);
    }

    public void decryptStream(String name, InputByteStream src, OutputByteStream dest, byte[] addKey) throws PDFSecurityConfigurationException, PDFIOException, PDFSecurityAuthorizationException {
        if (this.decryptionHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        EncryptionHandler encryption = this.getStreamEncryption(name, this.decryptionHandle);
        encryption.decrypt(src, dest, addKey);
    }

    private EncryptionHandler getStringEncryption(EncryptionState encryptHandle) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        Map encryptParams = encryptHandle.getEncryptionParams();
        String filterName = (String)encryptParams.get("StrF");
        if (filterName == null && encryptParams.containsKey("CF")) {
            filterName = "Identity";
        }
        if (filterName == null) {
            filterName = (String)encryptParams.get("Filter");
        }
        return this.getStreamEncryption(filterName, encryptHandle);
    }

    private EncryptionHandler getStreamEncryption(String cryptName, EncryptionState encryptHandle) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if (encryptHandle == null) {
            throw new PDFSecurityAuthorizationException("Security Manager for decryption is not set");
        }
        String filterName = cryptName;
        Map encryptParams = encryptHandle.getEncryptionParams();
        String handlerName = (String)encryptParams.get("Filter");
        if (cryptName == null) {
            filterName = (String)encryptParams.get("StmF");
            if (filterName == null && encryptParams.containsKey("CF")) {
                filterName = "Identity";
            }
            if (filterName == null) {
                filterName = handlerName;
            }
        }
        if (!encryptHandle.getEncryptionHandlers().containsKey(filterName)) {
            encryptHandle.getEncryptionHandlers().put(filterName, encryptHandle.getSecurityManager().getSecurityHandler(handlerName, encryptParams).getEncryptionHandler(filterName, encryptParams, encryptHandle.getDocID()));
        }
        return (EncryptionHandler)encryptHandle.getEncryptionHandlers().get(filterName);
    }

    public EncryptionHandler getStreamDecryptionHandler(String name) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        return this.getStreamEncryption(name, this.decryptionHandle);
    }

    public EncryptionHandler getStreamEncryptionHandler(String name) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        return this.getStreamEncryption(name, this.encryptionHandle);
    }

    public EncryptionHandler getStringDecryptionHandler() throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        return this.getStringEncryption(this.decryptionHandle);
    }

    public EncryptionHandler getStringEncryptionHandler() throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        return this.getStringEncryption(this.encryptionHandle);
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    private static class EncryptionState {
        private SecurityManager mSecurityMgr = null;
        private Map mEncryptParams = null;
        private byte[] mDocID = null;
        private HashMap mEncryptHandlers = new HashMap();

        EncryptionState(SecurityManager secMgr, Map encryptParams, byte[] docID) {
            this.mSecurityMgr = secMgr;
            this.mEncryptParams = encryptParams;
            this.mDocID = docID;
        }

        SecurityManager getSecurityManager() {
            return this.mSecurityMgr;
        }

        Map getEncryptionParams() {
            return this.mEncryptParams;
        }

        byte[] getDocID() {
            return this.mDocID;
        }

        Map getEncryptionHandlers() {
            return this.mEncryptHandlers;
        }
    }
}

