/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import java.util.HashMap;
import java.util.Map;

public class GeneralSecurityManager
implements SecurityManager {
    private HashMap secHandlers = null;
    private Map requestedEncryption = null;

    public SecurityHandler getSecurityHandler(String filterName, Map encryptParams) throws PDFSecurityConfigurationException {
        if (this.secHandlers == null) {
            throw new PDFSecurityConfigurationException("Security Handler: " + filterName + " is not registered");
        }
        if (filterName == null && encryptParams != null) {
            filterName = (String)encryptParams.get("Filter");
        }
        if (filterName == null) {
            throw new PDFSecurityConfigurationException("Security Handler is null");
        }
        SecurityHandler handler = (SecurityHandler)this.secHandlers.get(filterName);
        if (handler != null) {
            return handler;
        }
        throw new PDFSecurityConfigurationException("Security Handler: " + filterName + " is not registered");
    }

    public void addSecurityHandler(String name, SecurityHandler handler) {
        if (this.secHandlers == null) {
            this.secHandlers = new HashMap();
        }
        this.secHandlers.put(name, handler);
        if (this.requestedEncryption == null) {
            this.requestedEncryption = handler.getEncryptParameters();
        }
    }

    public Map getEncryptParameters() {
        return this.requestedEncryption;
    }
}

