/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.JCECipherEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class JCERC4EncryptionHandler
extends JCECipherEncryptionHandler
implements EncryptionHandler {
    public JCERC4EncryptionHandler(byte[] encryptionKey, MessageDigest md5Digest, boolean internal, Provider rc4Provider) throws PDFSecurityConfigurationException {
        super("RC4", encryptionKey, md5Digest, rc4Provider);
        this.mInternal = internal;
    }

    protected byte[] initCipher(Cipher cipher, byte[] content, int len, byte[] key, int mode) throws PDFSecurityConfigurationException {
        SecretKeySpec mEncryptKey = new SecretKeySpec(key, "RC4");
        try {
            cipher.init(mode, mEncryptKey);
        }
        catch (InvalidKeyException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", (Throwable)e);
        }
        byte[] newContent = new byte[len];
        System.arraycopy(content, 0, newContent, 0, newContent.length);
        return newContent;
    }

    public byte[] getBaseEncryptionKey() {
        return this.mEncryptKey;
    }
}

