/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.EncryptionKeyImpl;
import com.adobe.internal.pdftoolkit.core.encryption.IdentityEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.encryption.PBSHStandard;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import java.util.Map;

public class PBSHStandardCipher
extends PBSHStandard
implements SecurityHandler {
    public PBSHStandardCipher(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        super(owner, user, encrypt, encryptionPermissions, providers);
        this.setInternalRC4Encryption();
    }

    public PBSHStandardCipher(byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        super(password, providers);
        this.setInternalRC4Encryption();
    }

    public static PBSHStandard newInstance(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions) throws PDFSecurityConfigurationException {
        return new PBSHStandardCipher(owner, user, encrypt, encryptionPermissions, null);
    }

    public static PBSHStandard newInstance(byte[] password) throws PDFSecurityConfigurationException {
        return new PBSHStandardCipher(password, null);
    }

    public static PBSHStandard newInstance(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new PBSHStandardCipher(owner, user, encrypt, encryptionPermissions, providers);
    }

    public static PBSHStandard newInstance(byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new PBSHStandardCipher(password, providers);
    }

    public EncryptionHandler getEncryptionHandler(String cryptName, Map encryptParams, byte[] docID) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if ("Identity".equals(cryptName)) {
            return new IdentityEncryptionHandler();
        }
        String algorithm = EncryptionKeyImpl.getEncryptionAlgorithm(encryptParams, cryptName);
        return this.getEncryptionHandler(cryptName, algorithm, encryptParams, docID);
    }

    protected EncryptionHandler getEncryptionHandler(String handlerName, String algorithm, Map encryptParams, byte[] docID) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        if (this.mainEncryption == null || docID != this.curDocID) {
            if (!this.decryptedUsingState) {
                this.checkPassword(handlerName, encryptParams, docID);
            }
            this.mainEncryption = EncryptionKeyImpl.getEncryptionHandler(this.encryptKey, algorithm, this.md5Digest, encryptParams, this.secProviders);
        }
        return this.mainEncryption;
    }
}

