/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class BinaryAttachment {
    private String filename;
    private byte[] data;
    private InputStream dataStream;
    private String contentType = null;

    @Deprecated
    protected BinaryAttachment(String string, InputStream inputStream) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("Binary attachment filename cannot be blank.");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Binary attachment data cannot be null.");
        }
        this.filename = string;
        this.dataStream = inputStream;
    }

    @Deprecated
    protected BinaryAttachment(String string, InputStream inputStream, String string2) {
        this(string, inputStream);
        if (StringUtils.isBlank(string2)) {
            throw new IllegalArgumentException("ContentType cannot be null.");
        }
        this.contentType = string2;
    }

    @Deprecated
    public static BinaryAttachment with(String string, InputStream inputStream) {
        return new BinaryAttachment(string, inputStream);
    }

    @Deprecated
    public static BinaryAttachment with(String string, InputStream inputStream, String string2) {
        return new BinaryAttachment(string, inputStream, string2);
    }

    protected BinaryAttachment(String string, byte[] byArray) {
        if (StringUtils.isBlank(string)) {
            throw new IllegalArgumentException("Binary attachment filename cannot be blank.");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Binary attachment data cannot be null.");
        }
        this.filename = string;
        this.data = byArray;
    }

    protected BinaryAttachment(String string, byte[] byArray, String string2) {
        this(string, byArray);
        if (StringUtils.isBlank(string2)) {
            throw new IllegalArgumentException("ContentType cannot be null.");
        }
        this.contentType = string2;
    }

    public static BinaryAttachment with(String string, byte[] byArray) {
        return new BinaryAttachment(string, byArray);
    }

    public static BinaryAttachment with(String string, byte[] byArray, String string2) {
        return new BinaryAttachment(string, byArray, string2);
    }

    public int hashCode() {
        return ReflectionUtils.hashCode(this);
    }

    public boolean equals(Object object) {
        return ReflectionUtils.equals(this, object);
    }

    public String toString() {
        return String.format("[filename=%s]", this.getFilename());
    }

    public InputStream getData() {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.dataStream != null) {
            return this.dataStream;
        }
        throw new IllegalStateException("Either the byte[] or the stream mustn't be null at this point.");
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }
}

