/*
 * Decompiled with CFR 0.152.
 */
package com.restfb;

import com.restfb.DefaultWebRequestor;
import com.restfb.WebRequestor;
import com.restfb.util.SoftHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Map;

public class ETagWebRequestor
extends DefaultWebRequestor {
    private final Map<String, ETagResponse> etagCache = Collections.synchronizedMap(new SoftHashMap());
    private final ThreadLocal<ETagResponse> currentETagRespThreadLocal = new ThreadLocal();
    private volatile boolean useCache = true;

    protected void customizeConnection(HttpURLConnection httpURLConnection) {
        ETagResponse eTagResponse;
        if (this.isUseCache() && httpURLConnection.getRequestMethod().equals(DefaultWebRequestor.HttpMethod.GET.name()) && (eTagResponse = this.etagCache.get(httpURLConnection.getURL().toString())) != null) {
            this.currentETagRespThreadLocal.set(eTagResponse);
            httpURLConnection.addRequestProperty("If-None-Match", eTagResponse.getEtag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebRequestor.Response fetchResponse(InputStream inputStream, HttpURLConnection httpURLConnection) throws IOException {
        try {
            if (httpURLConnection.getRequestMethod().equals(DefaultWebRequestor.HttpMethod.GET.name())) {
                if (httpURLConnection.getResponseCode() == 304 && this.currentETagRespThreadLocal.get() != null) {
                    ETagResponse eTagResponse = this.currentETagRespThreadLocal.get();
                    WebRequestor.Response response = new WebRequestor.Response(httpURLConnection.getResponseCode(), eTagResponse.getBody());
                    return response;
                }
                WebRequestor.Response response = super.fetchResponse(inputStream, httpURLConnection);
                if (httpURLConnection.getHeaderField("ETag") != null) {
                    this.etagCache.put(httpURLConnection.getURL().toString(), new ETagResponse(httpURLConnection.getHeaderField("ETag"), response.getBody()));
                }
                WebRequestor.Response response2 = response;
                return response2;
            }
            WebRequestor.Response response = super.fetchResponse(inputStream, httpURLConnection);
            return response;
        }
        finally {
            this.currentETagRespThreadLocal.remove();
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    private class ETagResponse {
        private final String etag;
        private final String body;

        public ETagResponse(String string, String string2) {
            this.etag = string;
            this.body = string2;
        }

        public String getEtag() {
            return this.etag;
        }

        public String getBody() {
            return this.body;
        }
    }
}

