/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.experimental.api.impl;

import com.restfb.FacebookClient;
import com.restfb.Parameter;
import com.restfb.experimental.api.Comments;
import com.restfb.types.Comment;
import com.restfb.types.GraphResponse;

public class CommentsImpl
implements Comments {
    private final FacebookClient facebookClient;

    CommentsImpl(FacebookClient facebookClient) {
        this.facebookClient = facebookClient;
    }

    public boolean hide(String string) {
        Comment comment = this.facebookClient.fetchObject(string, Comment.class, Parameter.with("fields", "can_hide"));
        if (comment.isCanHide()) {
            GraphResponse graphResponse = this.facebookClient.publish(string, GraphResponse.class, Parameter.with("is_hidden", "true"));
            return graphResponse.isSuccess();
        }
        return false;
    }

    public boolean unhide(String string) {
        Comment comment = this.facebookClient.fetchObject(string, Comment.class, Parameter.with("fields", "can_hide"));
        if (comment.isCanHide()) {
            GraphResponse graphResponse = this.facebookClient.publish(string, GraphResponse.class, Parameter.with("is_hidden", "false"));
            return graphResponse.isSuccess();
        }
        return false;
    }

    public Comment get(String string) {
        return this.facebookClient.fetchObject(string, Comment.class, new Parameter[0]);
    }

    public boolean delete(String string) {
        return this.facebookClient.deleteObject(string, new Parameter[0]);
    }

    public boolean update(String string, String string2) {
        GraphResponse graphResponse = this.facebookClient.publish(string, GraphResponse.class, Parameter.with("message", string2));
        return graphResponse.isSuccess();
    }

    public boolean like(String string) {
        GraphResponse graphResponse = this.facebookClient.publish(string + "/likes", GraphResponse.class, new Parameter[0]);
        return graphResponse.isSuccess();
    }

    public boolean unLike(String string) {
        return this.facebookClient.deleteObject(string + "/likes", new Parameter[0]);
    }
}

