/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.types.Comment;
import com.restfb.types.NamedFacebookType;
import com.restfb.types.Place;
import com.restfb.util.DateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusMessage
extends NamedFacebookType {
    @Facebook
    private NamedFacebookType from;
    @Facebook
    private String message;
    @Facebook
    private Place place;
    @Facebook
    private String type;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    @Facebook
    private List<NamedFacebookType> likes = new ArrayList<NamedFacebookType>();
    @Facebook(value="likes")
    private EmptyLikes emptyLikes;
    @Facebook
    private List<Comment> comments = new ArrayList<Comment>();
    @Facebook(value="comments")
    private EmptyComments emptyComments;
    private static final long serialVersionUID = 2L;

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    public List<NamedFacebookType> getLikes() {
        return Collections.unmodifiableList(this.likes);
    }

    public boolean addLike(NamedFacebookType namedFacebookType) {
        return this.likes.add(namedFacebookType);
    }

    public boolean removeLike(NamedFacebookType namedFacebookType) {
        return this.likes.remove(namedFacebookType);
    }

    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public boolean addComment(Comment comment) {
        return this.comments.add(comment);
    }

    public boolean removeComment(Comment comment) {
        return this.comments.remove(comment);
    }

    public NamedFacebookType getFrom() {
        return this.from;
    }

    public void setFrom(NamedFacebookType namedFacebookType) {
        this.from = namedFacebookType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String string) {
        this.type = string;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    private static class EmptyComments
    implements Serializable {
        @Facebook
        private Long count;
        private static final long serialVersionUID = 1L;

        private EmptyComments() {
        }
    }

    private static class EmptyLikes
    implements Serializable {
        @Facebook
        private Long count;
        private static final long serialVersionUID = 1L;

        private EmptyLikes() {
        }
    }
}

