/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.types;

import com.restfb.Facebook;
import com.restfb.JsonMapper;
import com.restfb.json.JsonObject;
import com.restfb.types.NamedFacebookType;
import com.restfb.util.DateUtils;
import com.restfb.util.ReflectionUtils;
import com.restfb.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends NamedFacebookType {
    @Facebook(value="first_name")
    private String firstName;
    @Facebook(value="middle_name")
    private String middleName;
    @Facebook(value="last_name")
    private String lastName;
    @Facebook
    private String link;
    @Facebook
    private String bio;
    @Facebook
    private String quotes;
    @Facebook
    private String about;
    @Facebook(value="relationship_status")
    private String relationshipStatus;
    @Facebook
    private String religion;
    @Facebook(value="age_range")
    private AgeRange ageRange;
    @Facebook
    private String website;
    @Facebook
    private String birthday;
    @Facebook
    private String email;
    @Facebook
    private Double timezone;
    @Facebook
    private Boolean verified;
    @Facebook
    private String gender;
    @Facebook
    private String political;
    @Facebook
    private String locale;
    @Facebook
    private String username;
    @Facebook(value="picture")
    private JsonObject rawPicture;
    private Picture picture;
    @Facebook
    private NamedFacebookType hometown;
    @Facebook(value="hometown")
    private String hometownAsString;
    @Facebook
    private NamedFacebookType location;
    @Facebook(value="significant_other")
    private NamedFacebookType significantOther;
    @Facebook(value="updated_time")
    private String rawUpdatedTime;
    private Date updatedTime;
    @Facebook(value="third_party_id")
    private String thirdPartyId;
    @Facebook
    private Currency currency;
    @Facebook(value="token_for_business")
    private String tokenForBusiness;
    @Facebook(value="interested_in")
    private List<String> interestedIn = new ArrayList<String>();
    @Facebook(value="meeting_for")
    private List<String> meetingFor = new ArrayList<String>();
    @Facebook
    private List<Work> work = new ArrayList<Work>();
    @Facebook
    private List<Education> education = new ArrayList<Education>();
    @Facebook
    private List<Sport> sports = new ArrayList<Sport>();
    @Facebook(value="favorite_teams")
    private List<NamedFacebookType> favoriteTeams = new ArrayList<NamedFacebookType>();
    @Facebook(value="favorite_athletes")
    private List<NamedFacebookType> favoriteAthletes = new ArrayList<NamedFacebookType>();
    @Facebook
    private List<NamedFacebookType> languages = new ArrayList<NamedFacebookType>();
    private static final long serialVersionUID = 1L;

    public Date getBirthdayAsDate() {
        if (StringUtils.isBlank(this.getBirthday()) || this.getBirthday().split("/").length < 2) {
            return null;
        }
        return DateUtils.toDateFromShortFormat(this.birthday);
    }

    @JsonMapper.JsonMappingCompleted
    void convertTime() {
        this.updatedTime = DateUtils.toDateFromLongFormat(this.rawUpdatedTime);
    }

    @JsonMapper.JsonMappingCompleted
    protected void jsonMappingCompleted(JsonMapper jsonMapper) {
        this.picture = null;
        if (this.rawPicture == null) {
            return;
        }
        String string = this.rawPicture.getJsonObject("data").toString();
        this.picture = jsonMapper.toJavaObject(string, Picture.class);
    }

    public String getHometownName() {
        if (this.getHometown() != null) {
            return this.getHometown().getName();
        }
        return this.hometownAsString;
    }

    public List<String> getInterestedIn() {
        return Collections.unmodifiableList(this.interestedIn);
    }

    public boolean addInterestedIn(String string) {
        return this.interestedIn.add(string);
    }

    public boolean removeInterestedIn(String string) {
        return this.interestedIn.remove(string);
    }

    public List<String> getMeetingFor() {
        return Collections.unmodifiableList(this.meetingFor);
    }

    public boolean addMeetingFor(String string) {
        return this.meetingFor.add(string);
    }

    public boolean removeMeetingFor(String string) {
        return this.meetingFor.remove(string);
    }

    public List<Work> getWork() {
        return Collections.unmodifiableList(this.work);
    }

    public boolean addWork(Work work) {
        return this.work.add(work);
    }

    public boolean removeWork(Work work) {
        return this.work.remove(work);
    }

    public List<Education> getEducation() {
        return Collections.unmodifiableList(this.education);
    }

    public boolean addEducation(Education education) {
        return this.education.add(education);
    }

    public boolean removeEducation(Education education) {
        return this.education.remove(education);
    }

    public List<Sport> getSports() {
        return Collections.unmodifiableList(this.sports);
    }

    public boolean addSport(Sport sport) {
        return this.sports.add(sport);
    }

    public boolean removeSport(Sport sport) {
        return this.sports.remove(sport);
    }

    public List<NamedFacebookType> getFavoriteTeams() {
        return Collections.unmodifiableList(this.favoriteTeams);
    }

    public boolean addFavoriteTeam(NamedFacebookType namedFacebookType) {
        return this.favoriteTeams.add(namedFacebookType);
    }

    public boolean removeFavoriteTeam(NamedFacebookType namedFacebookType) {
        return this.favoriteTeams.remove(namedFacebookType);
    }

    public List<NamedFacebookType> getFavoriteAthletes() {
        return Collections.unmodifiableList(this.favoriteAthletes);
    }

    public boolean addFavoriteAthlete(NamedFacebookType namedFacebookType) {
        return this.favoriteAthletes.add(namedFacebookType);
    }

    public boolean removeFavoriteAthlete(NamedFacebookType namedFacebookType) {
        return this.favoriteAthletes.remove(namedFacebookType);
    }

    public List<NamedFacebookType> getLanguages() {
        return Collections.unmodifiableList(this.languages);
    }

    public boolean addLanguage(NamedFacebookType namedFacebookType) {
        return this.languages.add(namedFacebookType);
    }

    public boolean removeLanguage(NamedFacebookType namedFacebookType) {
        return this.languages.remove(namedFacebookType);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String string) {
        this.firstName = string;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String string) {
        this.middleName = string;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String string) {
        this.lastName = string;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public String getBio() {
        return this.bio;
    }

    public void setBio(String string) {
        this.bio = string;
    }

    public String getQuotes() {
        return this.quotes;
    }

    public void setQuotes(String string) {
        this.quotes = string;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String string) {
        this.about = string;
    }

    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public void setRelationshipStatus(String string) {
        this.relationshipStatus = string;
    }

    public String getReligion() {
        return this.religion;
    }

    public void setReligion(String string) {
        this.religion = string;
    }

    public AgeRange getAgeRange() {
        return this.ageRange;
    }

    public void setAgeRange(AgeRange ageRange) {
        this.ageRange = ageRange;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String string) {
        this.website = string;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public void setBirthday(String string) {
        this.birthday = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public Double getTimezone() {
        return this.timezone;
    }

    public void setTimezone(Double d) {
        this.timezone = d;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean bl) {
        this.verified = bl;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String string) {
        this.gender = string;
    }

    public String getPolitical() {
        return this.political;
    }

    public void setPolitical(String string) {
        this.political = string;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String string) {
        this.locale = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public Picture getPicture() {
        return this.picture;
    }

    public void setPicture(Picture picture) {
        this.picture = picture;
    }

    public NamedFacebookType getHometown() {
        return this.hometown;
    }

    public void setHometown(NamedFacebookType namedFacebookType) {
        this.hometown = namedFacebookType;
    }

    public NamedFacebookType getLocation() {
        return this.location;
    }

    public void setLocation(NamedFacebookType namedFacebookType) {
        this.location = namedFacebookType;
    }

    public NamedFacebookType getSignificantOther() {
        return this.significantOther;
    }

    public void setSignificantOther(NamedFacebookType namedFacebookType) {
        this.significantOther = namedFacebookType;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date date) {
        this.updatedTime = date;
    }

    public String getThirdPartyId() {
        return this.thirdPartyId;
    }

    public void setThirdPartyId(String string) {
        this.thirdPartyId = string;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getTokenForBusiness() {
        return this.tokenForBusiness;
    }

    public void setTokenForBusiness(String string) {
        this.tokenForBusiness = string;
    }

    public static class AgeRange
    implements Serializable {
        @Facebook
        private Integer min;
        @Facebook
        private Integer max;

        public Integer getMin() {
            return this.min;
        }

        public void setMin(Integer n) {
            this.min = n;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer n) {
            this.max = n;
        }
    }

    public static class Currency
    implements Serializable {
        @Facebook(value="user_currency")
        private String userCurrency;
        @Facebook(value="currency_exchange")
        private BigDecimal currencyExchange;
        @Facebook(value="currency_exchange_inverse")
        private BigDecimal currencyExchangeInverse;
        @Facebook(value="currency_offset")
        private BigDecimal currencyOffset;
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getUserCurrency() {
            return this.userCurrency;
        }

        public void setUserCurrency(String string) {
            this.userCurrency = string;
        }

        public BigDecimal getCurrencyExchange() {
            return this.currencyExchange;
        }

        public void setCurrencyExchange(BigDecimal bigDecimal) {
            this.currencyExchange = bigDecimal;
        }

        public BigDecimal getCurrencyExchangeInverse() {
            return this.currencyExchangeInverse;
        }

        public void setCurrencyExchangeInverse(BigDecimal bigDecimal) {
            this.currencyExchangeInverse = bigDecimal;
        }

        public BigDecimal getCurrencyOffset() {
            return this.currencyOffset;
        }

        public void setCurrencyOffset(BigDecimal bigDecimal) {
            this.currencyOffset = bigDecimal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sport
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType namedFacebookType) {
            return this.with.add(namedFacebookType);
        }

        public boolean removeWith(NamedFacebookType namedFacebookType) {
            return this.with.remove(namedFacebookType);
        }
    }

    public static class Picture
    implements Serializable {
        @Facebook
        private String url;
        @Facebook(value="is_silhouette")
        private Boolean isSilhouette;
        @Facebook
        private Integer height;
        @Facebook
        private Integer width;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String string) {
            this.url = string;
        }

        public Boolean getIsSilhouette() {
            return this.isSilhouette;
        }

        public void setIsSilhouette(Boolean bl) {
            this.isSilhouette = bl;
        }

        public Integer getHeight() {
            return this.height;
        }

        public void setHeight(Integer n) {
            this.height = n;
        }

        public Integer getWidth() {
            return this.width;
        }

        public void setWidth(Integer n) {
            this.width = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EducationClass
    extends NamedFacebookType {
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private String description;
        private static final long serialVersionUID = 1L;

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType namedFacebookType) {
            return this.with.add(namedFacebookType);
        }

        public boolean removeWith(NamedFacebookType namedFacebookType) {
            return this.with.remove(namedFacebookType);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Education
    implements Serializable {
        @Facebook
        private NamedFacebookType school;
        @Facebook
        private NamedFacebookType year;
        @Facebook(value="year")
        private String yearAsString;
        @Facebook
        private NamedFacebookType degree;
        @Facebook
        private String type;
        @Facebook
        private List<NamedFacebookType> concentration = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        @Facebook
        private List<EducationClass> classes = new ArrayList<EducationClass>();
        private static final long serialVersionUID = 2L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public List<NamedFacebookType> getConcentration() {
            return Collections.unmodifiableList(this.concentration);
        }

        public boolean addConcentration(NamedFacebookType namedFacebookType) {
            return this.concentration.add(namedFacebookType);
        }

        public boolean removeConcentration(NamedFacebookType namedFacebookType) {
            return this.concentration.remove(namedFacebookType);
        }

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType namedFacebookType) {
            return this.with.add(namedFacebookType);
        }

        public boolean removeWith(NamedFacebookType namedFacebookType) {
            return this.with.remove(namedFacebookType);
        }

        public List<EducationClass> getClasses() {
            return Collections.unmodifiableList(this.classes);
        }

        public boolean addClasses(EducationClass educationClass) {
            return this.classes.add(educationClass);
        }

        public boolean removeClasses(EducationClass educationClass) {
            return this.classes.remove(educationClass);
        }

        public NamedFacebookType getSchool() {
            return this.school;
        }

        public void setSchool(NamedFacebookType namedFacebookType) {
            this.school = namedFacebookType;
        }

        public NamedFacebookType getYear() {
            return this.year;
        }

        public void setYear(NamedFacebookType namedFacebookType) {
            this.year = namedFacebookType;
        }

        public String getYearAsString() {
            return this.yearAsString;
        }

        public void setYearAsString(String string) {
            this.yearAsString = string;
        }

        public NamedFacebookType getDegree() {
            return this.degree;
        }

        public void setDegree(NamedFacebookType namedFacebookType) {
            this.degree = namedFacebookType;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Work
    implements Serializable {
        @Facebook
        private NamedFacebookType employer;
        @Facebook
        private NamedFacebookType location;
        @Facebook
        private NamedFacebookType position;
        @Facebook
        private String description;
        @Facebook(value="start_date")
        private String rawStartDate;
        private Date startDate;
        @Facebook(value="end_date")
        private String rawEndDate;
        private Date endDate;
        @Facebook
        private List<NamedFacebookType> with = new ArrayList<NamedFacebookType>();
        private static final long serialVersionUID = 1L;

        public int hashCode() {
            return ReflectionUtils.hashCode(this);
        }

        public boolean equals(Object object) {
            return ReflectionUtils.equals(this, object);
        }

        public String toString() {
            return ReflectionUtils.toString(this);
        }

        public List<NamedFacebookType> getWith() {
            return Collections.unmodifiableList(this.with);
        }

        public boolean addWith(NamedFacebookType namedFacebookType) {
            return this.with.add(namedFacebookType);
        }

        public boolean removeWith(NamedFacebookType namedFacebookType) {
            return this.with.remove(namedFacebookType);
        }

        @JsonMapper.JsonMappingCompleted
        void convertTime() {
            this.startDate = DateUtils.toDateFromLongFormat(this.rawStartDate);
            this.endDate = DateUtils.toDateFromLongFormat(this.rawEndDate);
        }

        public NamedFacebookType getEmployer() {
            return this.employer;
        }

        public void setEmployer(NamedFacebookType namedFacebookType) {
            this.employer = namedFacebookType;
        }

        public NamedFacebookType getLocation() {
            return this.location;
        }

        public void setLocation(NamedFacebookType namedFacebookType) {
            this.location = namedFacebookType;
        }

        public NamedFacebookType getPosition() {
            return this.position;
        }

        public void setPosition(NamedFacebookType namedFacebookType) {
            this.position = namedFacebookType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date date) {
            this.startDate = date;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date date) {
            this.endDate = date;
        }
    }
}

