/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import com.restfb.util.DateFormatStrategy;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class CachedDateFormatStrategy
implements DateFormatStrategy {
    public DateFormat formatFor(String string) {
        return SimpleDateFormatHolder.formatFor(string);
    }

    public void clearThreadLocal() {
        SimpleDateFormatHolder.clearThreadLocal();
    }

    static final class SimpleDateFormatHolder {
        private static final ThreadLocal<SoftReference> THREADLOCAL_FORMATTER_MAP = new ThreadLocal<SoftReference>(){

            @Override
            protected SoftReference<Map> initialValue() {
                return new SoftReference<Map>(new HashMap());
            }
        };

        SimpleDateFormatHolder() {
        }

        public static SimpleDateFormat formatFor(String string) {
            SimpleDateFormat simpleDateFormat;
            SoftReference softReference = THREADLOCAL_FORMATTER_MAP.get();
            HashMap<String, SimpleDateFormat> hashMap = (HashMap<String, SimpleDateFormat>)softReference.get();
            if (hashMap == null) {
                hashMap = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATTER_MAP.set(new SoftReference(hashMap));
            }
            if ((simpleDateFormat = (SimpleDateFormat)hashMap.get(string)) == null) {
                simpleDateFormat = new SimpleDateFormat(string);
                hashMap.put(string, simpleDateFormat);
            }
            return simpleDateFormat;
        }

        public static void clearThreadLocal() {
            THREADLOCAL_FORMATTER_MAP.remove();
        }
    }
}

