/*
 * Decompiled with CFR 0.152.
 */
package com.restfb.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlUtils {
    public static final String ENCODING_CHARSET = "UTF-8";

    private UrlUtils() {
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform doesn't support UTF-8", unsupportedEncodingException);
        }
    }

    public static String urlDecode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLDecoder.decode(string, ENCODING_CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Platform doesn't support UTF-8", unsupportedEncodingException);
        }
    }

    public static Map<String, List<String>> extractParametersFromQueryString(String string) {
        if (string == null) {
            return Collections.emptyMap();
        }
        return UrlUtils.extractParametersFromUrl(String.format("restfb://url%s", string.startsWith("?") ? string : "?" + string));
    }

    public static Map<String, List<String>> extractParametersFromUrl(String string) {
        if (string == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String[] stringArray = string.split("\\?");
        if (stringArray.length > 1) {
            String string2 = stringArray[1];
            for (String string3 : string2.split("&")) {
                ArrayList<String> arrayList;
                String[] stringArray2 = string3.split("=");
                String string4 = UrlUtils.urlDecode(stringArray2[0]);
                String string5 = "";
                if (stringArray2.length > 1) {
                    string5 = UrlUtils.urlDecode(stringArray2[1]);
                }
                if ((arrayList = (ArrayList<String>)hashMap.get(string4)) == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string4, arrayList);
                }
                arrayList.add(string5);
            }
        }
        return hashMap;
    }

    public static String replaceOrAddQueryParameter(String string, String string2, String string3) {
        String[] stringArray = string.split("\\?");
        String string4 = string2 + "=" + string3;
        if (stringArray.length == 2) {
            Map<String, List<String>> map = UrlUtils.extractParametersFromQueryString(stringArray[1]);
            if (map.containsKey(string2)) {
                String string5 = map.get(string2).get(0);
                return string.replace(string2 + "=" + string5, string4);
            }
            return string + "&" + string4;
        }
        return string + "?" + string4;
    }
}

