/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j;

import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerSource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;

public class URISwaggerSource
implements SwaggerSource {
    private final URI uri;

    public URISwaggerSource(URI uri) {
        this.uri = uri;
    }

    public static URI buildUri(URI uri, String path, SwaggerFormat format) {
        assert (uri != null && path != null && format != null);
        String base = uri.toString();
        if (base.contains("?")) {
            base = base.substring(0, base.indexOf(63));
        }
        if ((path = path.replaceAll("\\{format\\}", format.getExtension())).startsWith("/")) {
            base = base.substring(0, base.lastIndexOf(47));
        }
        return URI.create(base + path);
    }

    public static SwaggerFormat extractFormat(URI uri) {
        String path = uri.getPath() == null ? uri.toString() : uri.getPath().toLowerCase();
        SwaggerFormat format = SwaggerFormat.json;
        if (path.endsWith(".xml")) {
            format = SwaggerFormat.xml;
        } else if (path.endsWith(".json")) {
            format = SwaggerFormat.json;
        } else if (path.contains(".xml/")) {
            format = SwaggerFormat.xml;
        }
        return format;
    }

    public Reader readResourceListing() throws IOException {
        return new InputStreamReader(this.uri.toURL().openStream());
    }

    public Reader readApiDeclaration(String basePath, String path) throws IOException {
        try {
            path = path.replaceAll("\\{format\\}", this.getFormat().getExtension());
            if (path.toLowerCase().startsWith("http://") || path.toLowerCase().startsWith("https://") || path.toLowerCase().startsWith("file:")) {
                basePath = "";
            } else if (basePath == null) {
                basePath = this.uri.toString();
            } else if (!basePath.toLowerCase().startsWith("file:") && !basePath.contains("://")) {
                String uriString = this.uri.toString();
                if (basePath.equals(".")) {
                    basePath = "";
                }
                int ix = basePath.startsWith("/") ? uriString.indexOf("/", uriString.indexOf(":") + (uriString.startsWith("file:") ? 1 : 4)) : uriString.lastIndexOf("/");
                basePath = uriString.substring(0, ix) + basePath;
            }
            URI uri = new URI(basePath + path);
            return new InputStreamReader(uri.toURL().openStream());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public SwaggerFormat getFormat() {
        return URISwaggerSource.extractFormat(this.uri);
    }
}

