/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Model;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.impl.ApiImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDeclarationImpl
implements ApiDeclaration {
    private String apiVersion = "1.0";
    private String basePath;
    private SwaggerVersion swaggerVersion = SwaggerVersion.DEFAULT_VERSION;
    private String resourcePath;
    private final List<Api> apiList = new ArrayList<Api>();
    private final Set<String> produces = new HashSet<String>();
    private final Set<String> consumes = new HashSet<String>();
    private final Map<String, Model> models = new HashMap<String, Model>();

    ApiDeclarationImpl(String basePath, String resourcePath) {
        this.basePath = basePath;
        this.resourcePath = resourcePath;
    }

    @Override
    public SwaggerVersion getSwaggerVersion() {
        return this.swaggerVersion;
    }

    @Override
    public void setSwaggerVersion(SwaggerVersion swaggerVersion) {
        assert (swaggerVersion != null) : "swaggerVersion can not be null";
        this.swaggerVersion = swaggerVersion;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        assert (apiVersion != null) : "apiVersion can not be null";
        this.apiVersion = apiVersion;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        assert (basePath != null) : "basePath can not be null";
        this.basePath = basePath;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public List<Api> getApis() {
        return Collections.unmodifiableList(this.apiList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApi(Api api) {
        assert (api != null) : "api can not be null";
        List<Api> list = this.apiList;
        synchronized (list) {
            this.apiList.remove(api);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Api addApi(String path) {
        assert (path != null) : "Can not add api with null path";
        assert (this.getApi(path) == null) : "Api already exists at path [" + path + "]";
        List<Api> list = this.apiList;
        synchronized (list) {
            ApiImpl api = new ApiImpl(this, path);
            this.apiList.add(api);
            return api;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Api getApi(String path) {
        assert (path != null) : "api path can not be null";
        List<Api> list = this.apiList;
        synchronized (list) {
            for (Api api : this.apiList) {
                if (!api.getPath().equals(path)) continue;
                return api;
            }
            return null;
        }
    }

    @Override
    public Collection<String> getProduces() {
        return Collections.unmodifiableCollection(this.produces);
    }

    @Override
    public void removeProduces(String produces) {
        this.produces.remove(produces);
    }

    @Override
    public void addProduces(String produces) {
        assert (produces != null) : "produces can not be null";
        this.produces.add(produces);
    }

    @Override
    public Collection<String> getConsumes() {
        return Collections.unmodifiableCollection(this.consumes);
    }

    @Override
    public void removeConsumes(String consumes) {
        this.produces.remove(consumes);
    }

    @Override
    public void addConsumes(String consumes) {
        assert (consumes != null) : "consumes can not be null";
        this.consumes.add(consumes);
    }

    @Override
    public Collection<Model> getModels() {
        return this.models.values();
    }

    @Override
    public Model getModel(String id) {
        return this.models.get(id);
    }

    @Override
    public void addModel(Model model) {
        this.models.put(model.getId(), model);
    }
}

