/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Operation;
import com.smartbear.swagger4j.impl.OperationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiImpl
implements Api {
    private String path;
    private String description;
    private final List<Operation> operations = new ArrayList<Operation>();
    private ApiDeclaration apiDeclaration;

    ApiImpl(ApiDeclaration apiDeclaration, String path) {
        this.apiDeclaration = apiDeclaration;
        this.setPath(path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        assert (path != null && path.trim().length() > 0) : "path can not be null or empty";
        this.path = path;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operation getOperation(String nickName) {
        assert (nickName != null) : "nickName can not be null";
        List<Operation> list = this.operations;
        synchronized (list) {
            for (Operation operation : this.operations) {
                if (!operation.getNickName().equals(nickName)) continue;
                return operation;
            }
        }
        return null;
    }

    @Override
    public List<Operation> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOperation(Operation operation) {
        assert (operation != null && operation.getNickName() != null) : "operation can not be null and must have a nickname";
        List<Operation> list = this.operations;
        synchronized (list) {
            this.operations.remove(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Operation addOperation(String nickName, Operation.Method method) {
        assert (nickName != null && method != null) : "operation can not be null and must have a nickname";
        assert (this.getOperation(nickName) == null) : "operation with nickName [" + nickName + "] already exists";
        List<Operation> list = this.operations;
        synchronized (list) {
            OperationImpl result = new OperationImpl(this, nickName, method);
            this.operations.add(result);
            return result;
        }
    }

    @Override
    public ApiDeclaration getApiDeclaration() {
        return this.apiDeclaration;
    }
}

