/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Authorizations;
import com.smartbear.swagger4j.Info;
import com.smartbear.swagger4j.Model;
import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.impl.AuthorizationsImpl;
import com.smartbear.swagger4j.impl.InfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceListingImpl
implements ResourceListing {
    private String apiVersion;
    private SwaggerVersion swaggerVersion = SwaggerVersion.DEFAULT_VERSION;
    private String basePath;
    private AuthorizationsImpl authorizations;
    private final List<ResourceListing.ResourceListingApi> apiList = new ArrayList<ResourceListing.ResourceListingApi>();
    private InfoImpl info;

    ResourceListingImpl(SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public SwaggerVersion getSwaggerVersion() {
        return this.swaggerVersion;
    }

    @Override
    public void setSwaggerVersion(SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public List<ResourceListing.ResourceListingApi> getApis() {
        return Collections.unmodifiableList(this.apiList);
    }

    @Override
    public void removeApi(ResourceListing.ResourceListingApi api) {
        if (this.apiList.contains(api)) {
            this.apiList.remove(api);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceListing.ResourceListingApi addApi(ApiDeclaration apiDeclaration, String path) {
        assert (apiDeclaration != null) : "apiDeclaration can not be null";
        assert (this.getApi(apiDeclaration.getResourcePath()) == null) : "Can not add API to Resource Listing; path already exists";
        List<ResourceListing.ResourceListingApi> list = this.apiList;
        synchronized (list) {
            ResourceListingApiImpl api = new ResourceListingApiImpl(apiDeclaration, path);
            this.apiList.add(api);
            return api;
        }
    }

    @Override
    public Info getInfo() {
        if (this.info == null) {
            this.info = new InfoImpl();
        }
        return this.info;
    }

    @Override
    public Authorizations getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = new AuthorizationsImpl();
        }
        return this.authorizations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceListing.ResourceListingApi getApi(String path) {
        List<ResourceListing.ResourceListingApi> list = this.apiList;
        synchronized (list) {
            for (ResourceListing.ResourceListingApi api : this.apiList) {
                if (!api.getPath().equals(path)) continue;
                return api;
            }
            return null;
        }
    }

    @Override
    public Collection<Model> getApisModels() {
        ArrayList<Model> models = new ArrayList<Model>();
        for (ResourceListing.ResourceListingApi api : this.getApis()) {
            models.addAll(api.getDeclaration().getModels());
        }
        return models;
    }

    public static class ResourceListingApiImpl
    implements ResourceListing.ResourceListingApi {
        private String description;
        private final ApiDeclaration apiDeclaration;
        private String path;

        ResourceListingApiImpl(ApiDeclaration apiDeclaration, String path) {
            this.apiDeclaration = apiDeclaration;
            this.path = path;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public ApiDeclaration getDeclaration() {
            return this.apiDeclaration;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            assert (path != null) : "path can not be null";
            this.path = path;
        }
    }
}

