/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.SwaggerFormat;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SwaggerGenerator {
    public abstract SwaggerGenerator addString(String var1, String var2);

    public abstract void finish() throws IOException;

    public abstract SwaggerGenerator addObject(String var1);

    public abstract SwaggerGenerator addArrayObject(String var1);

    public abstract SwaggerGenerator addBoolean(String var1, boolean var2);

    public abstract SwaggerGenerator addInt(String var1, int var2);

    public abstract SwaggerGenerator addArray(String var1, String[] var2);

    public static SwaggerGenerator newXmlGenerator(Writer writer) throws IOException {
        return new SwaggerXmlGenerator(writer);
    }

    public static SwaggerGenerator newJsonGenerator(Writer writer) {
        return new SwaggerJsonGenerator(writer);
    }

    public static SwaggerGenerator newGenerator(Writer writer, SwaggerFormat format) throws IOException {
        switch (format) {
            case xml: {
                return SwaggerGenerator.newXmlGenerator(writer);
            }
            case json: {
                return SwaggerGenerator.newJsonGenerator(writer);
            }
        }
        throw new RuntimeException("Unknown format: " + (Object)((Object)format));
    }

    public static class SwaggerXmlGenerator
    extends SwaggerGenerator {
        private final Element elm;
        private Writer writer;

        private SwaggerXmlGenerator(Writer writer) throws IOException {
            this.writer = writer;
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                this.elm = (Element)document.appendChild(document.createElement("ApiDocumentation"));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        private SwaggerXmlGenerator(Element elm) {
            this.elm = elm;
        }

        public SwaggerGenerator addString(String name, String value) {
            if (value != null) {
                Document document = this.elm.getOwnerDocument();
                Node node = this.elm.appendChild(document.createElement(name));
                node.appendChild(document.createTextNode(value));
            }
            return this;
        }

        public void finish() throws IOException {
            if (this.writer == null) {
                throw new RuntimeException("finish can only be called on root writer");
            }
            try {
                Document document = this.elm.getOwnerDocument();
                DOMSource domSource = new DOMSource(document);
                StreamResult result = new StreamResult(this.writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
            }
            catch (TransformerException ex) {
                throw new IOException(ex);
            }
        }

        public SwaggerGenerator addObject(String name) {
            return this.addArrayObject(name);
        }

        public SwaggerGenerator addArrayObject(String name) {
            Document document = this.elm.getOwnerDocument();
            Node node = this.elm.appendChild(document.createElement(name));
            return new SwaggerXmlGenerator((Element)node);
        }

        public SwaggerXmlGenerator addBoolean(String name, boolean value) {
            this.addString(name, Boolean.toString(value));
            return this;
        }

        public SwaggerGenerator addInt(String name, int value) {
            this.addString(name, Integer.toString(value));
            return this;
        }

        public SwaggerGenerator addArray(String name, String[] values) {
            for (String v : values) {
                this.addString(name, v);
            }
            return this;
        }
    }

    public static class SwaggerJsonGenerator
    extends SwaggerGenerator {
        private final JsonObjectBuilder builder;
        private Writer writer;
        private Map<String, SwaggerJsonGenerator> objects;
        private Map<String, List<SwaggerJsonGenerator>> arrayObjects;

        public SwaggerJsonGenerator(Writer writer) {
            this.writer = writer;
            this.builder = Json.createObjectBuilder();
        }

        public SwaggerJsonGenerator(JsonObjectBuilder objectBuilder) {
            this.builder = objectBuilder;
        }

        public SwaggerGenerator addString(String name, String value) {
            assert (name != null);
            if (value != null) {
                this.builder.add(name, value);
            }
            return this;
        }

        JsonObjectBuilder getObjectBuilder() {
            return this.builder;
        }

        public void finish() throws IOException {
            if (this.arrayObjects != null) {
                for (String name : this.arrayObjects.keySet()) {
                    JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                    for (SwaggerJsonGenerator w : this.arrayObjects.get(name)) {
                        w.finish();
                        arrayBuilder.add(w.getObjectBuilder());
                    }
                    this.builder.add(name, arrayBuilder);
                }
            }
            if (this.objects != null) {
                for (String name : this.objects.keySet()) {
                    SwaggerJsonGenerator w = this.objects.get(name);
                    w.finish();
                    this.builder.add(name, w.getObjectBuilder());
                }
            }
            if (this.writer != null) {
                JsonObject jsonObject = this.builder.build();
                JsonWriterFactory factory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", "true"));
                JsonWriter jsonWriter = factory.createWriter(this.writer);
                jsonWriter.writeObject(jsonObject);
                jsonWriter.close();
            }
        }

        public SwaggerGenerator addObject(String name) {
            if (this.objects == null) {
                this.objects = new HashMap<String, SwaggerJsonGenerator>();
            }
            SwaggerJsonGenerator result = new SwaggerJsonGenerator(Json.createObjectBuilder());
            this.objects.put(name, result);
            return result;
        }

        public SwaggerGenerator addArrayObject(String name) {
            assert (name != null);
            if (this.arrayObjects == null) {
                this.arrayObjects = new HashMap<String, List<SwaggerJsonGenerator>>();
            }
            if (!this.arrayObjects.containsKey(name)) {
                this.arrayObjects.put(name, new ArrayList());
            }
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            SwaggerJsonGenerator swaggerJsonGenerator = new SwaggerJsonGenerator(objectBuilder);
            this.arrayObjects.get(name).add(swaggerJsonGenerator);
            return swaggerJsonGenerator;
        }

        public SwaggerGenerator addBoolean(String name, boolean value) {
            this.builder.add(name, value);
            return this;
        }

        public SwaggerGenerator addInt(String name, int value) {
            this.builder.add(name, value);
            return this;
        }

        public SwaggerGenerator addArray(String name, String[] values) {
            assert (name != null && values != null);
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String v : values) {
                arrayBuilder.add(v);
            }
            this.builder.add(name, arrayBuilder);
            return this;
        }
    }
}

