/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.impl.Swagger4jExceptionHandler;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwaggerParser {
    public abstract String getString(String var1);

    public abstract List<SwaggerParser> getChildren(String var1);

    public abstract boolean getBoolean(String var1);

    public abstract String getString();

    public abstract SwaggerFormat getFormat();

    public abstract int getInteger(String var1);

    public abstract Number getNumber(String var1);

    public abstract List<String> getArray(String var1);

    public abstract SwaggerParser getChild(String var1);

    public abstract String[] getChildNames();

    public static SwaggerParser newXmlParser(Reader reader) throws IOException {
        return new SwaggerXmlParser(reader);
    }

    public static SwaggerParser newJsonParser(Reader reader) {
        return new SwaggerJsonParser(reader);
    }

    public static SwaggerParser newParser(Reader reader, SwaggerFormat format) throws IOException {
        switch (format) {
            case json: {
                return SwaggerParser.newJsonParser(reader);
            }
            case xml: {
                return SwaggerParser.newXmlParser(reader);
            }
        }
        throw new RuntimeException("Unknown format: " + (Object)((Object)format));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwaggerJsonParser
    extends SwaggerParser {
        private final JsonObject jsonObject;

        private SwaggerJsonParser(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        private SwaggerJsonParser(Reader reader) {
            JsonReader jsonReader = Json.createReader((Reader)reader);
            this.jsonObject = jsonReader.readObject();
        }

        @Override
        public String getString(String name) {
            try {
                return this.jsonObject.getString(name, null);
            }
            catch (RuntimeException e) {
                Swagger4jExceptionHandler.get().onException(e);
                return null;
            }
        }

        @Override
        public List<SwaggerParser> getChildren(String name) {
            ArrayList<SwaggerParser> result = new ArrayList<SwaggerParser>();
            if (!this.jsonObject.containsKey((Object)name) || this.jsonObject.isNull(name)) {
                return result;
            }
            JsonArray jsonArray = this.jsonObject.getJsonArray(name);
            for (int c = 0; jsonArray != null && c < jsonArray.size(); ++c) {
                result.add(new SwaggerJsonParser(jsonArray.getJsonObject(c)));
            }
            return result;
        }

        @Override
        public boolean getBoolean(String name) {
            assert (name != null) : "name can not be null";
            JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
            return value == null ? false : Boolean.valueOf(value.toString());
        }

        @Override
        public String getString() {
            return this.jsonObject.toString();
        }

        @Override
        public SwaggerFormat getFormat() {
            return SwaggerFormat.json;
        }

        @Override
        public int getInteger(String name) {
            JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
            return Integer.parseInt(value.toString());
        }

        @Override
        public Number getNumber(String name) {
            JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
            if (value == null) {
                return null;
            }
            switch (value.getValueType()) {
                case NUMBER: {
                    return ((JsonNumber)value).bigDecimalValue();
                }
                case STRING: {
                    return new BigDecimal(((JsonString)value).getString());
                }
            }
            throw new IllegalArgumentException("not a number");
        }

        @Override
        public List<String> getArray(String name) {
            ArrayList<String> result = new ArrayList<String>();
            if (!this.jsonObject.containsKey((Object)name) || this.jsonObject.isNull(name)) {
                return result;
            }
            JsonArray jsonArray = this.jsonObject.getJsonArray(name);
            if (jsonArray != null) {
                for (int c = 0; c < jsonArray.size(); ++c) {
                    result.add(jsonArray.getString(c));
                }
            }
            return result;
        }

        @Override
        public SwaggerParser getChild(String name) {
            JsonValue value = (JsonValue)this.jsonObject.get((Object)name);
            if (value == JsonValue.NULL) {
                return null;
            }
            JsonObject child = (JsonObject)value;
            return child == null ? null : new SwaggerJsonParser(child);
        }

        @Override
        public String[] getChildNames() {
            return this.jsonObject.keySet().toArray(new String[this.jsonObject.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SwaggerXmlParser
    extends SwaggerParser {
        private final Element elm;

        private SwaggerXmlParser(Element elm) {
            this.elm = elm;
        }

        private SwaggerXmlParser(Reader reader) throws IOException {
            assert (reader != null);
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(reader));
                this.elm = document.getDocumentElement();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        @Override
        public String getString(String name) {
            NodeList nl = this.elm.getElementsByTagName(name);
            if (nl.getLength() > 0) {
                return nl.item(0).getTextContent();
            }
            return null;
        }

        @Override
        public List<SwaggerParser> getChildren(String name) {
            ArrayList<SwaggerParser> result = new ArrayList<SwaggerParser>();
            NodeList nl = this.elm.getElementsByTagName(name);
            for (int c = 0; c < nl.getLength(); ++c) {
                result.add(new SwaggerXmlParser((Element)nl.item(c)));
            }
            return result;
        }

        @Override
        public boolean getBoolean(String name) {
            return Boolean.getBoolean(this.getString(name));
        }

        @Override
        public String getString() {
            return this.elm.getTextContent();
        }

        @Override
        public SwaggerFormat getFormat() {
            return SwaggerFormat.xml;
        }

        @Override
        public int getInteger(String name) {
            return Integer.parseInt(this.getString(name));
        }

        @Override
        public Number getNumber(String name) {
            String stringValue = this.getString(name);
            return stringValue == null || stringValue.isEmpty() ? null : new BigDecimal(stringValue);
        }

        @Override
        public List<String> getArray(String name) {
            ArrayList<String> result = new ArrayList<String>();
            NodeList nl = this.elm.getElementsByTagName(name);
            for (int c = 0; c < nl.getLength(); ++c) {
                result.add(nl.item(c).getTextContent());
            }
            return result;
        }

        @Override
        public SwaggerParser getChild(String name) {
            NodeList nl = this.elm.getElementsByTagName(name);
            if (nl.getLength() > 0) {
                return new SwaggerXmlParser((Element)nl.item(0));
            }
            return null;
        }

        @Override
        public String[] getChildNames() {
            ArrayList<String> names = new ArrayList<String>();
            NodeList nl = this.elm.getChildNodes();
            for (int c = 0; c < nl.getLength(); ++c) {
                Node n = nl.item(c);
                if (n.getNodeType() != 1) continue;
                names.add(n.getNodeName());
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

