/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Authorizations;
import com.smartbear.swagger4j.DataType;
import com.smartbear.swagger4j.Info;
import com.smartbear.swagger4j.Model;
import com.smartbear.swagger4j.Operation;
import com.smartbear.swagger4j.Parameter;
import com.smartbear.swagger4j.PrimitiveType;
import com.smartbear.swagger4j.Property;
import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerReader;
import com.smartbear.swagger4j.SwaggerSource;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.URISwaggerSource;
import com.smartbear.swagger4j.impl.ApiDeclarationImpl;
import com.smartbear.swagger4j.impl.Constants;
import com.smartbear.swagger4j.impl.ModelImpl;
import com.smartbear.swagger4j.impl.NamedDataArrayType;
import com.smartbear.swagger4j.impl.NamedDataType;
import com.smartbear.swagger4j.impl.PrimitiveArrayType;
import com.smartbear.swagger4j.impl.PropertyImpl;
import com.smartbear.swagger4j.impl.RefArrayType;
import com.smartbear.swagger4j.impl.RefDataType;
import com.smartbear.swagger4j.impl.ResourceListingImpl;
import com.smartbear.swagger4j.impl.Swagger4jExceptionHandler;
import com.smartbear.swagger4j.impl.SwaggerParser;
import com.smartbear.swagger4j.impl.Utils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SwaggerReaderImpl
implements SwaggerReader {
    private static final Logger logger = Logger.getLogger(SwaggerReaderImpl.class.getName());

    public ResourceListing readResourceListing(URI uri) throws IOException {
        assert (uri != null);
        return this.readResourceListing(new URISwaggerSource(uri));
    }

    public ResourceListing readResourceListing(SwaggerSource source) throws IOException {
        assert (source != null);
        SwaggerParser parser = SwaggerParser.newParser(source.readResourceListing(), source.getFormat());
        SwaggerVersion swaggerVersion = SwaggerVersion.fromIdentifier(parser.getString("swaggerVersion"));
        Constants constants = Constants.get(swaggerVersion);
        String basePath = parser.getString("basePath");
        ResourceListingImpl resourceListing = new ResourceListingImpl(swaggerVersion);
        resourceListing.setBasePath(basePath);
        resourceListing.setApiVersion(parser.getString("apiVersion"));
        resourceListing.setSwaggerVersion(swaggerVersion);
        for (SwaggerParser node : parser.getChildren("apis")) {
            String path = node.getString("path");
            Reader reader = source.readApiDeclaration(basePath, path);
            ApiDeclaration apiDeclaration = this.readApiDeclaration(reader, source.getFormat());
            ResourceListing.ResourceListingApi api = resourceListing.addApi(apiDeclaration, path);
            api.setDescription(node.getString("description"));
        }
        SwaggerParser child = parser.getChild("info");
        if (child != null) {
            this.readResourceListingInfo(constants, resourceListing, child);
        }
        if ((child = parser.getChild("authorizations")) != null) {
            this.readAuthorizations(resourceListing, child);
        }
        return resourceListing;
    }

    private void readAuthorizations(ResourceListingImpl resourceListing, SwaggerParser child) {
        String[] names = child.getChildNames();
        if (names != null) {
            for (String name : names) {
                SwaggerParser auth = child.getChild(name);
                String type = auth.getString("type");
                if (type.equals("oauth2")) {
                    this.readOAuth2Authorization(resourceListing, name, auth);
                    continue;
                }
                if (type.equals("apiKey")) {
                    Authorizations.ApiKeyAuthorization apiKey = (Authorizations.ApiKeyAuthorization)resourceListing.getAuthorizations().addAuthorization(name, Authorizations.AuthorizationType.API_KEY);
                    apiKey.setKeyName(auth.getString("keyName"));
                    apiKey.setPassAs(auth.getString("passAs"));
                    continue;
                }
                if (!type.equals("basicAuth")) continue;
                resourceListing.getAuthorizations().addAuthorization(name, Authorizations.AuthorizationType.BASIC);
            }
        }
    }

    private void readAuthorizations(Operation operation, SwaggerParser child) {
        String[] names = child.getChildNames();
        if (names != null) {
            for (String name : names) {
                List<SwaggerParser> scopes = child.getChildren(name);
                if (scopes.size() > 0) {
                    Authorizations.OAuth2Authorization oauth = (Authorizations.OAuth2Authorization)operation.getAuthorizations().addAuthorization(name, Authorizations.AuthorizationType.OAUTH2);
                    for (SwaggerParser scope : scopes) {
                        oauth.addScope(scope.getString("scope"), scope.getString("description"));
                    }
                    continue;
                }
                operation.getAuthorizations().addAuthorization(name, Authorizations.AuthorizationType.BASIC);
            }
        }
    }

    private void readOAuth2Authorization(ResourceListingImpl resourceListing, String name, SwaggerParser auth) {
        SwaggerParser grants;
        Authorizations.OAuth2Authorization oauth = (Authorizations.OAuth2Authorization)resourceListing.getAuthorizations().addAuthorization(name, Authorizations.AuthorizationType.OAUTH2);
        List<SwaggerParser> scopes = auth.getChildren("scopes");
        if (scopes != null && !scopes.isEmpty()) {
            for (SwaggerParser p : scopes) {
                oauth.addScope(p.getString("scope"), p.getString("description"));
            }
        }
        if ((grants = auth.getChild("grantTypes")) != null) {
            SwaggerParser ac;
            SwaggerParser implicitGrant = grants.getChild("implicit");
            if (implicitGrant != null) {
                Authorizations.OAuth2Authorization.ImplicitGrant ig = oauth.getImplicitGrant();
                if (implicitGrant.getChild("loginEndpoint") != null) {
                    ig.setLoginEndpoint(implicitGrant.getChild("loginEndpoint").getString("url"));
                }
                ig.setTokenName(implicitGrant.getString("tokenName"));
            }
            if ((ac = grants.getChild("authorization_code")) != null) {
                SwaggerParser te;
                Authorizations.OAuth2Authorization.AuthorizationCodeGrant acg = oauth.getAuthorizationCodeGrant();
                SwaggerParser tre = ac.getChild("tokenRequestEndpoint");
                if (tre != null) {
                    acg.setTokenRequestEndpoint(tre.getString("url"));
                    acg.setClientIdName(tre.getString("clientIdName"));
                    acg.setClientSecretName(tre.getString("clientSecretName"));
                }
                if ((te = ac.getChild("tokenEndpoint")) != null) {
                    acg.setTokenEndpoint(te.getString("url"));
                    acg.setTokenName(te.getString("tokenName"));
                }
            }
        }
    }

    private void readResourceListingInfo(Constants constants, ResourceListingImpl resourceListing, SwaggerParser child) {
        Info info = resourceListing.getInfo();
        info.setContact(child.getString("contact"));
        info.setDescription(child.getString("description"));
        info.setLicense(child.getString("license"));
        info.setLicenseUrl(child.getString("licenseUrl"));
        info.setTermsOfServiceUrl(child.getString("termsOfServiceUrl"));
        info.setTitle(child.getString("title"));
    }

    public ApiDeclaration readApiDeclaration(URI uri) throws IOException {
        assert (uri != null) : "uri can not be null";
        SwaggerFormat format = URISwaggerSource.extractFormat(uri);
        InputStreamReader reader = new InputStreamReader(uri.toURL().openStream());
        return this.readApiDeclaration(reader, format);
    }

    public ApiDeclaration readApiDeclaration(Reader reader, SwaggerFormat format) throws IOException {
        SwaggerParser parser = SwaggerParser.newParser(reader, format);
        SwaggerVersion swaggerVersion = SwaggerVersion.fromIdentifier(parser.getString("swaggerVersion"));
        Constants constants = Constants.get(swaggerVersion);
        String basePath = parser.getString("basePath");
        String resourcePath = parser.getString("resourcePath");
        ApiDeclarationImpl apiDeclaration = new ApiDeclarationImpl(basePath, resourcePath);
        apiDeclaration.setSwaggerVersion(swaggerVersion);
        apiDeclaration.setApiVersion(parser.getString("apiVersion"));
        for (String produces : parser.getArray("produces")) {
            apiDeclaration.addProduces(produces);
        }
        for (String consumes : parser.getArray("consumes")) {
            apiDeclaration.addConsumes(consumes);
        }
        for (SwaggerParser apiNode : parser.getChildren("apis")) {
            String apiPath = apiNode.getString("path");
            if (apiDeclaration.getApi(apiPath) != null) {
                logger.log(Level.INFO, "Skipping duplicate API at path [" + apiPath + "] in ApiDeclaration at [" + basePath + resourcePath + "]");
                continue;
            }
            Api api = apiDeclaration.addApi(apiPath);
            api.setDescription(apiNode.getString("description"));
            for (SwaggerParser opNode : apiNode.getChildren("operations")) {
                String nickName = opNode.getString("nickname");
                if (api.getOperation(nickName) != null) {
                    logger.log(Level.INFO, "Skipping duplicate Operation with nickName [" + nickName + "] in API at path [" + apiPath + "] in ApiDeclaration at [" + basePath + resourcePath + "]");
                    continue;
                }
                this.readOperation(constants, api, opNode, nickName);
            }
        }
        if (swaggerVersion == SwaggerVersion.V1_2) {
            SwaggerParser modelsNode = parser.getChild("models");
            if (modelsNode != null) {
                for (String modelKey : modelsNode.getChildNames()) {
                    SwaggerParser node = modelsNode.getChild(modelKey);
                    apiDeclaration.addModel(this.readModel(constants, node));
                }
            }
        } else {
            logger.log(Level.INFO, "skipping models parsing, not supported for version {0}", swaggerVersion.getIdentifier());
        }
        return apiDeclaration;
    }

    private void readOperation(Constants constants, Api api, SwaggerParser opNode, String nickName) {
        String method = opNode.getString(constants.METHOD);
        if (method == null) {
            method = opNode.getString("httpMethod");
        }
        Operation operation = api.addOperation(nickName, Operation.Method.valueOf(method.toUpperCase()));
        operation.setSummary(opNode.getString("summary"));
        operation.setNotes(opNode.getString("notes"));
        operation.setResponseClass(opNode.getString(constants.OPERATION_TYPE));
        for (SwaggerParser parameterNode : opNode.getChildren("parameters")) {
            try {
                Parameter parameter = operation.addParameter(parameterNode.getString("name"), Parameter.ParamType.valueOf(parameterNode.getString("paramType")));
                parameter.setAllowMultiple(parameterNode.getBoolean("allowMultiple"));
                parameter.setDescription(parameterNode.getString("description"));
                parameter.setRequired(parameterNode.getBoolean("required"));
                parameter.setType(parameterNode.getString(constants.TYPE));
            }
            catch (Exception e) {
                Swagger4jExceptionHandler.get().onException(e);
            }
        }
        SwaggerParser child = opNode.getChild("authorizations");
        if (child != null) {
            this.readAuthorizations(operation, child);
        }
        for (SwaggerParser responseMessage : opNode.getChildren(constants.RESPONSE_MESSAGES)) {
            operation.addResponseMessage(responseMessage.getInteger("code"), responseMessage.getString(constants.MESSAGE)).setResponseModel(responseMessage.getString("responseModel"));
        }
        for (String produces : opNode.getArray("produces")) {
            operation.addProduces(produces);
        }
        for (String consumes : opNode.getArray("consumes")) {
            operation.addConsumes(consumes);
        }
    }

    private Model readModel(Constants constants, SwaggerParser modelNode) {
        String id = modelNode.getString("id");
        String modelDescription = modelNode.getString("description");
        ModelImpl model = new ModelImpl(id, modelDescription);
        List<String> requiredProperties = modelNode.getArray("required");
        model.setRequiredProperties(requiredProperties);
        SwaggerParser propertiesNode = modelNode.getChild("properties");
        ArrayList<Property> properties = new ArrayList<Property>();
        for (String propertyName : propertiesNode.getChildNames()) {
            SwaggerParser propertyNode = propertiesNode.getChild(propertyName);
            DataType dataType = this.readDataType(constants, propertyNode);
            String propertyDescription = propertyNode.getString("description");
            boolean required = requiredProperties.contains(propertyName);
            PropertyImpl property = new PropertyImpl(propertyName, dataType, propertyDescription, required);
            if (dataType.isPrimitive() && !dataType.isArray()) {
                PrimitiveType primitiveType = (PrimitiveType)dataType;
                property.setDefaultValue(this.readDefaultValue(constants, propertyNode, primitiveType));
                if (primitiveType.isString()) {
                    property.setEnumValues(propertyNode.getArray("enum"));
                }
                if (primitiveType.isNumber()) {
                    property.setMaximum(propertyNode.getNumber("maximum"));
                    property.setMinimum(propertyNode.getNumber("minimum"));
                }
            }
            properties.add(property);
        }
        model.setProperties(properties);
        return model;
    }

    private DataType readDataType(Constants constants, SwaggerParser node) {
        String type = node.getString(constants.TYPE);
        if (type == null) {
            return new RefDataType(node.getString("$ref"));
        }
        if ("array".equals(type)) {
            return this.readArrayDataType(constants, node.getChild("items"));
        }
        try {
            return PrimitiveType.get(type, node.getString("format"));
        }
        catch (IllegalArgumentException ex) {
            return new NamedDataType(type);
        }
    }

    private DataType readArrayDataType(Constants constants, SwaggerParser itemsNode) {
        String itemsType = itemsNode.getString(constants.TYPE);
        if (itemsType == null) {
            return new RefArrayType(itemsNode.getString("$ref"));
        }
        try {
            return new PrimitiveArrayType(PrimitiveType.get(itemsType, itemsNode.getString("format")));
        }
        catch (IllegalArgumentException ex) {
            return new NamedDataArrayType(itemsType);
        }
    }

    private Object readDefaultValue(Constants constants, SwaggerParser node, PrimitiveType dataType) {
        Utils.SwaggerDataParser dataParser = new Utils.SwaggerDataParser(node);
        switch (dataType) {
            case INTEGER: {
                return dataParser.getInteger("defaultValue");
            }
            case LONG: {
                return dataParser.getLong("defaultValue");
            }
            case FLOAT: {
                return dataParser.getFloat("defaultValue");
            }
            case DOUBLE: {
                return dataParser.getDouble("defaultValue");
            }
            case BOOLEAN: {
                return dataParser.getBoolean("defaultValue");
            }
            case BYTE: 
            case DATE: 
            case DATE_TIME: 
            case STRING: {
                return dataParser.getString("defaultValue");
            }
        }
        throw new AssertionError();
    }
}

