/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.swagger4j.impl;

import com.smartbear.swagger4j.Api;
import com.smartbear.swagger4j.ApiDeclaration;
import com.smartbear.swagger4j.Authorizations;
import com.smartbear.swagger4j.DataType;
import com.smartbear.swagger4j.Info;
import com.smartbear.swagger4j.Model;
import com.smartbear.swagger4j.Operation;
import com.smartbear.swagger4j.Parameter;
import com.smartbear.swagger4j.Property;
import com.smartbear.swagger4j.ResourceListing;
import com.smartbear.swagger4j.ResponseMessage;
import com.smartbear.swagger4j.SwaggerFormat;
import com.smartbear.swagger4j.SwaggerStore;
import com.smartbear.swagger4j.SwaggerVersion;
import com.smartbear.swagger4j.SwaggerWriter;
import com.smartbear.swagger4j.impl.Constants;
import com.smartbear.swagger4j.impl.SwaggerGenerator;
import com.smartbear.swagger4j.impl.Utils;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;

public class SwaggerWriterImpl
implements SwaggerWriter {
    private final SwaggerFormat format;

    public SwaggerWriterImpl(SwaggerFormat format) {
        this.format = format;
    }

    public void writeApiDeclaration(ApiDeclaration declaration, Writer writer) throws IOException {
        SwaggerGenerator w = SwaggerGenerator.newGenerator(writer, this.format);
        SwaggerVersion swaggerVersion = declaration.getSwaggerVersion();
        Constants constants = Constants.get(swaggerVersion);
        w.addString("swaggerVersion", swaggerVersion.getIdentifier());
        w.addString("apiVersion", declaration.getApiVersion());
        w.addString("basePath", declaration.getBasePath());
        w.addString("resourcePath", declaration.getResourcePath());
        if (swaggerVersion.isGreaterThan(SwaggerVersion.V1_1)) {
            Collection<String> consumes;
            Collection<String> produces = declaration.getProduces();
            if (!produces.isEmpty()) {
                w.addArray("produces", produces.toArray(new String[produces.size()]));
            }
            if (!(consumes = declaration.getConsumes()).isEmpty()) {
                w.addArray("consumes", consumes.toArray(new String[consumes.size()]));
            }
        }
        for (Api api : declaration.getApis()) {
            SwaggerGenerator aw = w.addArrayObject("apis");
            aw.addString("path", api.getPath());
            aw.addString("description", api.getDescription());
            for (Operation operation : api.getOperations()) {
                Collection<String> consumes;
                Authorizations authorizations;
                SwaggerGenerator ow = aw.addArrayObject("operations");
                ow.addString("nickname", operation.getNickName());
                ow.addString(constants.METHOD, operation.getMethod().name());
                ow.addString("summary", operation.getSummary());
                ow.addString("notes", operation.getNotes());
                ow.addString(constants.OPERATION_TYPE, operation.getResponseClass());
                if (operation.getDataType().isArray()) {
                    SwaggerGenerator owg = ow.addObject("items");
                    if (operation.getDataType().isRef()) {
                        owg.addString("$ref", operation.getDataType().getRef());
                    } else {
                        owg.addString(constants.TYPE, operation.getDataType().getType());
                        if (operation.getDataType().getFormat() != null) {
                            owg.addString("format", operation.getDataType().getFormat());
                        }
                    }
                }
                if ((authorizations = operation.getAuthorizations()) != null && authorizations.getAuthorizations() != null && !authorizations.getAuthorizations().isEmpty()) {
                    this.writeOperationAuthorizations(ow, constants, authorizations);
                }
                for (Parameter parameter : operation.getParameters()) {
                    SwaggerGenerator pw = ow.addArrayObject("parameters");
                    pw.addString("name", parameter.getName());
                    pw.addString("paramType", parameter.getParamType().name());
                    pw.addBoolean("allowMultiple", parameter.isAllowMultiple());
                    pw.addString("description", parameter.getDescription());
                    pw.addBoolean("required", parameter.isRequired());
                    pw.addString(constants.TYPE, parameter.getType());
                    if (!parameter.getDataType().isArray()) continue;
                    SwaggerGenerator pwg = pw.addObject("items");
                    if (parameter.getDataType().isRef()) {
                        pwg.addString("$ref", parameter.getDataType().getRef());
                        continue;
                    }
                    pwg.addString(constants.TYPE, parameter.getDataType().getType());
                    if (parameter.getDataType().getFormat() == null) continue;
                    pwg.addString("format", parameter.getDataType().getFormat());
                }
                for (ResponseMessage responseMessage : operation.getResponseMessages()) {
                    SwaggerGenerator ew = ow.addArrayObject(constants.RESPONSE_MESSAGES);
                    ew.addInt("code", responseMessage.getCode());
                    ew.addString(constants.MESSAGE, responseMessage.getMessage());
                    if (!swaggerVersion.isGreaterThan(SwaggerVersion.V1_1)) continue;
                    ew.addString("responseModel", responseMessage.getResponseModel());
                }
                Collection<String> produces = operation.getProduces();
                if (!produces.isEmpty()) {
                    ow.addArray("produces", produces.toArray(new String[produces.size()]));
                }
                if ((consumes = operation.getConsumes()).isEmpty()) continue;
                ow.addArray("consumes", consumes.toArray(new String[consumes.size()]));
            }
        }
        SwaggerGenerator models = w.addObject("models");
        for (Model model : declaration.getModels()) {
            List<Property> properties;
            SwaggerGenerator mw = models.addObject(model.getName());
            mw.addString("id", model.getId());
            mw.addString("description", model.getDescription());
            List<String> requiredProperties = model.getRequiredProperties();
            if (requiredProperties != null) {
                mw.addArray("required", requiredProperties.toArray(new String[0]));
            }
            if (model.getRequiredProperties() != null) {
                mw.addArray("required", model.getRequiredProperties().toArray(new String[model.getRequiredProperties().size()]));
            }
            if ((properties = model.getProperties()) == null) continue;
            SwaggerGenerator props = mw.addObject("properties");
            for (Property property : properties) {
                DataType dataType;
                SwaggerGenerator prop = props.addObject(property.getName());
                if (property.getDescription() != null && !property.getDescription().isEmpty()) {
                    prop.addString("description", property.getDescription());
                }
                if ((dataType = property.getDataType()) == null) continue;
                if (dataType.isArray()) {
                    prop.addString(constants.TYPE, "array");
                    prop = prop.addObject("items");
                }
                if (dataType.isRef()) {
                    prop.addString("$ref", dataType.getRef());
                } else {
                    prop.addString(constants.TYPE, dataType.getType());
                }
                if (dataType.getFormat() != null && !dataType.getFormat().isEmpty()) {
                    prop.addString("format", dataType.getFormat());
                }
                if (property.getMinimum() != null) {
                    prop.addString("minimum", property.getMinimum().toString());
                }
                if (property.getMaximum() != null) {
                    prop.addString("maximum", property.getMaximum().toString());
                }
                if (property.getEnumValues() != null && !property.getEnumValues().isEmpty()) {
                    prop.addArray("enum", property.getEnumValues().toArray(new String[property.getEnumValues().size()]));
                }
                if (property.getDefaultValue() == null) continue;
                prop.addString("defaultValue", property.getDefaultValue().toString());
            }
        }
        w.finish();
    }

    public void writeResourceListing(ResourceListing listing, Writer writer) throws IOException {
        SwaggerGenerator w = SwaggerGenerator.newGenerator(writer, this.format);
        Constants constants = Constants.get(listing.getSwaggerVersion());
        w.addString("apiVersion", listing.getApiVersion());
        w.addString("swaggerVersion", listing.getSwaggerVersion().getIdentifier());
        w.addString("basePath", listing.getBasePath());
        for (ResourceListing.ResourceListingApi api : listing.getApis()) {
            SwaggerGenerator sw = w.addArrayObject("apis");
            sw.addString("description", api.getDescription());
            sw.addString("path", api.getPath());
        }
        if (listing.getSwaggerVersion().isGreaterThan(SwaggerVersion.V1_1)) {
            Info info = listing.getInfo();
            SwaggerGenerator sw = w.addObject("info");
            sw.addString("title", info.getTitle());
            sw.addString("description", info.getDescription());
            sw.addString("termsOfServiceUrl", info.getTermsOfServiceUrl());
            sw.addString("contact", info.getContact());
            sw.addString("license", info.getLicense());
            sw.addString("licenseUrl", info.getLicenseUrl());
            Authorizations authorizations = listing.getAuthorizations();
            if (authorizations != null && authorizations.getAuthorizations() != null && !authorizations.getAuthorizations().isEmpty()) {
                this.writeAuthorizations(w, constants, authorizations);
            }
        }
        w.finish();
    }

    private void writeAuthorizations(SwaggerGenerator w, Constants constants, Authorizations authorizations) {
        SwaggerGenerator sg = w.addObject("authorizations");
        for (Authorizations.Authorization aut : authorizations.getAuthorizations()) {
            Authorizations.OAuth2Authorization.AuthorizationCodeGrant acg;
            Authorizations.OAuth2Authorization oaa;
            if (aut.getType() == Authorizations.AuthorizationType.BASIC) {
                sg.addObject(aut.getName()).addString("type", "basicAuth");
                continue;
            }
            if (aut.getType() == Authorizations.AuthorizationType.API_KEY) {
                Authorizations.ApiKeyAuthorization aka = (Authorizations.ApiKeyAuthorization)aut;
                if (!SwaggerWriterImpl.hasContent(aka.getKeyName()) || !SwaggerWriterImpl.hasContent(aka.getPassAs())) continue;
                sg.addObject(aut.getName()).addString("type", "apiKey").addString("keyName", aka.getKeyName()).addString("passAs", aka.getPassAs());
                continue;
            }
            if (aut.getType() != Authorizations.AuthorizationType.OAUTH2 || (oaa = (Authorizations.OAuth2Authorization)aut).getAuthorizationCodeGrant() == null && oaa.getImplicitGrant() == null) continue;
            sg = sg.addObject(aut.getName()).addString("type", "oauth2");
            Authorizations.OAuth2Authorization.Scope[] scopes = oaa.getScopes();
            if (scopes.length > 0) {
                for (Authorizations.OAuth2Authorization.Scope s : scopes) {
                    SwaggerGenerator so = sg.addArrayObject("scopes");
                    so.addString("scope", s.getName());
                    so.addString("description", s.getDescription());
                }
            }
            sg = sg.addObject("grantTypes");
            Authorizations.OAuth2Authorization.ImplicitGrant ig = oaa.getImplicitGrant();
            if (ig != null) {
                sg.addObject("implicit").addString("tokenName", ig.getTokenName()).addObject("loginEndpoint").addString("url", ig.getLoginEndpointUrl());
            }
            if ((acg = oaa.getAuthorizationCodeGrant()) == null) continue;
            sg = sg.addObject("authorization_code");
            sg.addObject("tokenRequestEndpoint").addString("url", acg.getTokenRequestEndpointUrl()).addString("clientIdName", acg.getClientIdName()).addString("clientSecretName", acg.getClientSecretName());
            sg.addObject("tokenEndpoint").addString("url", acg.getTokenEndpointUrl()).addString("tokenName", acg.getTokenName());
        }
    }

    private void writeOperationAuthorizations(SwaggerGenerator w, Constants constants, Authorizations authorizations) {
        SwaggerGenerator sg = w.addObject("authorizations");
        for (Authorizations.Authorization aut : authorizations.getAuthorizations()) {
            Authorizations.OAuth2Authorization.Scope[] scopes;
            Authorizations.OAuth2Authorization oaa;
            if (aut.getType() == Authorizations.AuthorizationType.BASIC) {
                sg.addArrayObject(aut.getName());
                continue;
            }
            if (aut.getType() == Authorizations.AuthorizationType.API_KEY) {
                sg.addArrayObject(aut.getName());
                continue;
            }
            if (aut.getType() != Authorizations.AuthorizationType.OAUTH2 || (oaa = (Authorizations.OAuth2Authorization)aut).getAuthorizationCodeGrant() == null && oaa.getImplicitGrant() == null || (scopes = oaa.getScopes()).length <= 0) continue;
            for (Authorizations.OAuth2Authorization.Scope s : scopes) {
                SwaggerGenerator so = sg.addArrayObject(aut.getName());
                so.addString("scope", s.getName());
                so.addString("description", s.getDescription());
            }
        }
    }

    public SwaggerFormat getFormat() {
        return this.format;
    }

    public void writeSwagger(SwaggerStore store, ResourceListing resourceListing) throws IOException {
        Writer writer = store.createResource("api-docs");
        this.writeResourceListing(resourceListing, writer);
        for (ResourceListing.ResourceListingApi api : resourceListing.getApis()) {
            ApiDeclaration declaration = api.getDeclaration();
            String path = Utils.createFileNameFromPath(api.getPath(), this.format);
            writer = store.createResource(path);
            this.writeApiDeclaration(declaration, writer);
        }
    }

    private static boolean hasContent(String str) {
        return str != null && str.trim().length() > 0;
    }
}

