/*
 * Decompiled with CFR 0.152.
 */
package coldfusion;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;

public class ThreadDump {
    static ThreadGroup rootThreadGroup = null;
    private static String INDENT = "    ";
    static StringBuilder dump;
    static StringBuilder dump2;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;

    public static void main(String[] args) {
        ThreadDump.generateMemorySnapshot();
    }

    public static String captureThreadDump() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        Iterator<Thread> iterator = allThreads.keySet().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Thread key = iterator.next();
            StackTraceElement[] trace = allThreads.get(key);
            stringBuffer.append(key + "\r\n");
            int i = 0;
            while (i < trace.length) {
                stringBuffer.append(" " + trace[i] + "\r\n");
                ++i;
            }
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }

    public static String generateThreadDump() {
        dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100);
        dump.append(new Date());
        dump.append("\nFull thread dump:\n");
        ThreadInfo[] threadInfoArray = threadInfos;
        int n = threadInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            Thread thread = ThreadDump.getThread(threadInfo.getThreadId());
            try {
                StackTraceElement[] stackTraceElements;
                Thread.State state = threadInfo.getThreadState();
                ThreadDump.printThread(threadInfo);
                try {
                    dump.append("\n java.lang.Thread.State: ");
                    dump.append((Object)state);
                    dump.append("\n");
                    dump.append(" prio=" + thread.getPriority());
                    if (threadInfo.getBlockedTime() > -1L) {
                        dump.append(" blockedtime=" + threadInfo.getBlockedTime());
                    }
                    if (threadInfo.getBlockedCount() > -1L) {
                        dump.append(" blockedcount=" + threadInfo.getBlockedCount());
                    }
                    if (threadInfo.getWaitedTime() > -1L) {
                        dump.append(" waitedtime=" + threadInfo.getWaitedTime());
                    }
                    if (threadInfo.getWaitedCount() > -1L) {
                        dump.append(" waitedcount=" + threadInfo.getWaitedCount());
                    }
                    if (threadInfo.getLockOwnerId() > -1L) {
                        dump.append(" lockname=" + threadInfo.getLockName());
                        dump.append(" lockownername=" + threadInfo.getLockOwnerName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                StackTraceElement[] stackTraceElementArray = stackTraceElements = threadInfo.getStackTrace();
                int n3 = stackTraceElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n4];
                    dump.append("\n    at ");
                    dump.append(stackTraceElement);
                    ++n4;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dump.append("\n\n");
            ++n2;
        }
        return dump.toString();
    }

    static Thread getThread(long id) {
        Thread[] threads;
        Thread[] threadArray = threads = ThreadDump.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getId() == id) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    static Thread getThread(String name) {
        Thread[] threads;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        Thread[] threadArray = threads = ThreadDump.getAllThreads();
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            if (thread.getName().equals(name)) {
                return thread;
            }
            ++n2;
        }
        return null;
    }

    static Thread[] getAllThreads() {
        Thread[] threads;
        ThreadGroup root = ThreadDump.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    static ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (rootThreadGroup != null) {
            return rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    private static void printThread(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\"" + " Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        dump.append(sb.toString());
        if (ti.getLockOwnerName() != null) {
            dump.append(String.valueOf(INDENT) + " owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }

    private static void printMonitorInfo(ThreadInfo ti, MonitorInfo[] monitors) {
        dump.append(String.valueOf(INDENT) + "Locked monitors: count = " + monitors.length);
        MonitorInfo[] monitorInfoArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorInfo mi = monitorInfoArray[n2];
            dump.append(String.valueOf(INDENT) + "  - " + mi + " locked at ");
            dump.append(String.valueOf(INDENT) + "      " + mi.getLockedStackDepth() + " " + mi.getLockedStackFrame());
            ++n2;
        }
    }

    private void printLockInfo(LockInfo[] locks) {
        dump.append(String.valueOf(INDENT) + "Locked synchronizers: count = " + locks.length);
        LockInfo[] lockInfoArray = locks;
        int n = locks.length;
        int n2 = 0;
        while (n2 < n) {
            LockInfo li = lockInfoArray[n2];
            dump.append(String.valueOf(INDENT) + "  - " + li);
            ++n2;
        }
        dump.append("\n");
    }

    static void dumpHeap(String fileName, boolean live) {
        ThreadDump.initHotspotMBean();
        try {
            hotspotMBean.dumpHeap(fileName, live);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotspotMBean() {
        if (hotspotMBean != null) return;
        Class<ThreadDump> clazz = ThreadDump.class;
        synchronized (ThreadDump.class) {
            if (hotspotMBean != null) return;
            hotspotMBean = ThreadDump.getHotspotMBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotspotMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HotSpotDiagnosticMXBean.class);
            return bean;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    public static String generateMemorySnapshot() {
        int n;
        dump2 = new StringBuilder();
        List<GarbageCollectorMXBean> gcList = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean tmpGC : gcList) {
            String[] memoryPoolNames;
            dump2.append("\nName: " + tmpGC.getName());
            dump2.append(" Collection count: " + tmpGC.getCollectionCount());
            dump2.append(" Collection time: " + tmpGC.getCollectionTime());
            dump2.append(" Memory Pools: ");
            String[] stringArray = memoryPoolNames = tmpGC.getMemoryPoolNames();
            n = memoryPoolNames.length;
            int n2 = 0;
            while (n2 < n) {
                String mpnTmp = stringArray[n2];
                dump2.append("\t" + mpnTmp);
                ++n2;
            }
        }
        dump2.append("\nMemory Pools Info:\n");
        List<MemoryPoolMXBean> memoryList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean tmpMem : memoryList) {
            String[] memManagerNames;
            dump2.append("\nName: " + tmpMem.getName());
            dump2.append("Usage: " + tmpMem.getUsage());
            dump2.append("Collection Usage: " + tmpMem.getCollectionUsage());
            dump2.append("Peak Usage: " + tmpMem.getPeakUsage());
            dump2.append("Type: " + (Object)((Object)tmpMem.getType()));
            dump2.append("Memory Manager Names: ");
            String[] stringArray = memManagerNames = tmpMem.getMemoryManagerNames();
            int n3 = memManagerNames.length;
            n = 0;
            while (n < n3) {
                String mmnTmp = stringArray[n];
                dump2.append("\t" + mmnTmp);
                ++n;
            }
            dump2.append("\n");
        }
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage muNH = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        dump2.append("\n\nHeap Memory Usage:\nInit :" + mu.getInit() + "\nMax :" + mu.getMax() + "\nUsed :" + mu.getUsed() + "\nCommitted :" + mu.getCommitted() + "\nNon Heap Memory Usage:" + "\nInit NonHeap :" + muNH.getInit() + "\nMax NonHeap :" + muNH.getMax() + "\nUsed NonHeap:" + muNH.getUsed() + "\nCommitted NonHeap:" + muNH.getCommitted());
        return dump2.toString();
    }
}

