/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.InstructionPtr;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JumpInstruction
extends Instruction
implements InstructionPtr {
    protected int _offset = 0;
    protected Instruction _target = null;

    public void setOffset(int n) {
        this._offset = n;
        this._target = null;
    }

    public int getOffset() {
        if (this._target != null) {
            return this._target.getByteIndex() - this.getByteIndex();
        }
        return this._offset;
    }

    public JumpInstruction setTarget(Instruction instruction) {
        this._target = instruction;
        return this;
    }

    public Instruction getTarget() {
        return this._target;
    }

    public void setMarkers(List list) {
        int n = this.getByteIndex() + this._offset;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = (Instruction)iterator.next();
            if (instruction.getByteIndex() != n) continue;
            this.setTarget(instruction);
            break;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JumpInstruction)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Instruction instruction = ((JumpInstruction)object).getTarget();
        return instruction == null || this._target == null || instruction == this._target;
    }

    public int getLength() {
        switch (this._opcode) {
            case 200: 
            case 201: {
                return super.getLength() + 4;
            }
        }
        return super.getLength() + 2;
    }

    public int getStackChange() {
        switch (this._opcode) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return -2;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                return -1;
            }
            case 168: {
                return 1;
            }
        }
        return 0;
    }

    protected void copy(Instruction instruction) {
        super.copy(instruction);
        this.setOffset(((JumpInstruction)instruction).getOffset());
    }

    protected void readData(DataInput dataInput) throws IOException {
        switch (this._opcode) {
            case 200: 
            case 201: {
                this._offset = dataInput.readInt();
                break;
            }
            default: {
                this._offset = dataInput.readShort();
            }
        }
    }

    protected void writeData(DataOutput dataOutput) throws IOException {
        switch (this._opcode) {
            case 200: 
            case 201: {
                dataOutput.writeInt(this.getOffset());
                break;
            }
            default: {
                dataOutput.writeShort(this.getOffset());
            }
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterJumpInstruction(this);
        bCVisitor.exitJumpInstruction(this);
    }

    protected JumpInstruction(Code code, int n) {
        super(code);
        this._opcode = n;
    }
}

