/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode.lowlevel;

import com.techtrader.modules.tools.bytecode.lowlevel.ConstantEntry;
import com.techtrader.modules.tools.bytecode.lowlevel.LowLevelConstants;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StringEntry
implements ConstantEntry,
LowLevelConstants {
    private int _stringIndex = -1;

    public int getType() {
        return 8;
    }

    public int getStringIndex() {
        return this._stringIndex;
    }

    public void setStringIndex(int n) {
        this._stringIndex = n;
    }

    public Object getConstantValue() {
        return new Integer(this._stringIndex);
    }

    public void setConstantValue(Object object) {
        this._stringIndex = ((Number)object).intValue();
    }

    public void readData(DataInput dataInput) throws IOException {
        this.setStringIndex(dataInput.readUnsignedShort());
    }

    public void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getStringIndex());
    }

    public String getKey() {
        return this.getType() + "|" + this.getStringIndex();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterStringEntry(this);
        bCVisitor.exitStringEntry(this);
    }
}

