/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.ApacheConfEditor;
import com.adobe.coldfusion.connector.connectorinstaller.ApacheVHEditor;
import com.adobe.coldfusion.connector.connectorinstaller.ApacheWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.CIConstants;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.CheckApacheVersion;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.JarUtils;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WSVersionNotSupportedException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.util.IPUtil;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;

public class ApacheInstaller
extends WebServerInstaller {
    static final String ACTION_ADD = "Add";
    static final String ACTION_REMOVE = "Remove";
    private int apache2PatchLevel = AP_SERVER_PATCHLEVEL;
    private String serviceName = "";
    private File serverRoot = null;
    private String serverBinPath = null;
    private String scriptPath = null;
    private String resourceName = null;
    private boolean isStronghold = false;
    public static final String CONF_FILE = "/httpd.conf";
    public static final String APACHE2_CONF_FILE = "/apache2.conf";
    public static final String WORKERS_PROPERTIES = "/workers.properties";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private static final String[] ntBinPaths = new String[]{"apache.exe", "bin/apache.exe", "bin/httpd.exe"};
    private static final String[] unixBinPaths = new String[]{"bin/httpd", "/usr/sbin/httpd", "/usr/local/apache/bin/httpd", "/usr/apache/bin/httpd", "/usr/sbin/apache2", "/usr/sbin/apache2ctl"};
    private static final String[] unixScriptPaths = new String[]{"bin/apachectl", "/usr/sbin/apache2ctl", "/usr/sbin/apachectl", "/etc/init.d/httpd", "/etc/init.d/apache", "/etc/rc.d/init.d/httpd", "/etc/rc.d/init.d/apache", "/sbin/init.d/apache", "/sbin/init.d/httpd", "/usr/local/apache/bin/apachectl", "/usr/apache/bin/apachectl", "/etc/init.d/apache2"};
    private static final String[] unixStrongholdScriptPaths = new String[]{"bin/strongholdctl", "/usr/local/stronghold/bin/strongholdctl"};
    private static final String START_ARG_UNIX = " start";
    private static final String STOP_ARG_UNIX = " stop";
    private static final String RESTART_ARG_UNIX = " restart";
    private static final String STATUS_ARG_UNIX = " status";
    private static final String CONNECTOR_APACHE = "mod_jk.so";
    private static final String CONNECTOR_APACHE2 = "mod_jk20.so";
    private static final String CONNECTOR_APACHE22 = "mod_jk22.so";
    private static final String CONNECTOR_APACHE24 = "mod_jk24.so";
    private static final String CONNECTOR_APACHE2_GCC3 = "gcc3/";
    private static int AP_SERVER_PATCHLEVEL = 43;
    private static int AP_SERVER_PATCHLEVEL_RH89 = 40;
    private static final String APACHE2_MMN_MAJOR = "20020903";
    private static final String APACHE2_MMN_MAJOR_RH89 = "20020628";
    private static final String DEFAULT_SERVER_APP_HTTPD = "/Library/Server/Web/Config/apache2/httpd_server_app.conf";

    public ApacheInstaller() throws ConnectorInstallerException, IOException {
        this.supportedVersionStr = "2.0." + AP_SERVER_PATCHLEVEL + " or higher, if not Red Hat 8 or 9, or 2.0." + AP_SERVER_PATCHLEVEL_RH89 + " or higher, if Red Hat 8 or 9";
        this.wsVersionStr = CIConstants.UNKNOWN_VALUE;
    }

    @Override
    public void installConnector() throws Exception {
        this.installConnector(this.getStateWS().isStarted());
    }

    private void populateApacheWebSites() {
        try {
            if (isWindows) {
                ApacheWebSites.populateWebSites(this.wsInfo.getApacheBinPath(), this.wsInfo.getWebServerDir());
            } else {
                String string = this.wsInfo.getApacheScriptPath().length() > 0 ? this.wsInfo.getApacheScriptPath() : this.getScriptPath();
                ApacheWebSites.populateWebSites(string, this.wsInfo.getWebServerDir());
            }
        }
        catch (ConnectorInstallerException connectorInstallerException) {
            CIUtil.logDebug("Error while fetching Apache Websites.");
            CIUtil.logDebug(connectorInstallerException.getMessage());
        }
    }

    @Override
    public void installConnector(boolean bl) throws Exception {
        String string;
        File file;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        WebServerInfo webServerInfo = propertyFileEditor.findEntry(this.wsInfo);
        if (webServerInfo != null) {
            if (this.wsInfo.isRefresh()) {
                // empty if block
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerAlreadyConfigured"));
        }
        if (this.wsInfo.getApacheBinPath().length() == 0) {
            this.wsInfo.setApacheBinPath(this.getServerBinPath());
        }
        if (this.wsInfo.getApacheBinPath().length() != 0) {
            CheckApacheVersion checkApacheVersion = new CheckApacheVersion(this.wsInfo.getApacheBinPath());
            if (checkApacheVersion.apacheVersion.equalsIgnoreCase("32")) {
                this.wsInfo.setBitnessValue("bitness32");
            } else if (checkApacheVersion.apacheVersion.equalsIgnoreCase("64")) {
                this.wsInfo.setBitnessValue("bitness64");
            } else {
                throw new ConnectorInstallerException(RB.getString((Object)this, "CI.BadApacheVersionBin", new File(this.getServerBinPath())));
            }
        }
        if (!this.wsInfo.getApacheApxs() && !this.isValidVersion()) {
            if (wsMajorVer == 2) {
                if (wsMinorVer == 0 && this.wsBuildNum < this.apache2PatchLevel) {
                    throw new WSVersionNotSupportedException(RB.getString((Object)this, "CI.Apache2MinVersion", (Object)this.wsVersionStr, (Object)String.valueOf(this.apache2PatchLevel)));
                }
            }
        }
        if (this.wsInfo.getPlatform() == "pa_risc-hpux") {
            if (wsMajorVer == 2) {
                if (wsMinorVer == 2) {
                    throw new WSVersionNotSupportedException(RB.getString((Object)this, "CI.ApacheVersionNotSupport", (Object)this.wsVersionStr));
                }
            }
        }
        if (!(file = new File(this.wsInfo.getWebServerDir() + CONF_FILE)).exists()) {
            file = new File(this.wsInfo.getWebServerDir() + APACHE2_CONF_FILE);
        }
        if (!file.isFile()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.InvalidConfigDir", (Object)file.getParent(), (Object)this.wsInfo.getWebServerDisplay()));
        }
        this.populateApacheWebSites();
        ApacheConfEditor apacheConfEditor = new ApacheConfEditor(file, this.wsInfo);
        this.isDsoConfigured();
        boolean bl2 = apacheConfEditor.readApacheFile();
        if (!bl2) {
            CIUtil.backupFile(file.getCanonicalPath());
        }
        if (File.separatorChar == '/' && bl) {
            this.getScriptPath();
        }
        File file2 = this.createAppServerWsDir();
        try {
            if (!new File(this.wsInfo.getWebServerDir() + File.separator + CONNECTOR_APACHE).exists()) {
                this.copyFiles(new File(this.wsInfo.getWebServerDir()), this.wsInfo.isForcedExtract());
                this.changesForConnectorBinaryInSELinux();
            }
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotSupported"));
        }
        String string2 = this.wsInfo.getWebServerDir() + File.separator + "workers.properties";
        String string3 = file2 + File.separator + "uriworkermap.properties";
        String string4 = file2 + File.separator + "iprestriction.properties";
        if (!isWindows) {
            string = this.wsInfo.getAppServerWebServerDir().getParent() + File.separator + "shm";
            boolean bl3 = new File(string).mkdir();
        }
        this.writeConnectorPropertiesFile(string2, string3);
        string = this.wsInfo.getWebServerDir() + File.separator + this.getConnectorName();
        OrderedProperties orderedProperties = this.getConnectorProperties(string, string2, string3, string4);
        apacheConfEditor.insert(orderedProperties);
        this.createReadmeFile();
        this.changesToBeMadeForSELinux();
        propertyFileEditor.updateEntry(file2.getName(), this.wsInfo, this.jrunInfo);
        propertyFileEditor.writePropertyFile();
        if (this.wsInfo.getPlatform().equals("intel-macosx64")) {
            File file3 = new File(DEFAULT_SERVER_APP_HTTPD);
            if (file3.exists()) {
                apacheConfEditor = new ApacheConfEditor(file3, this.wsInfo);
                apacheConfEditor.readApacheFile();
                apacheConfEditor.insert(orderedProperties);
            }
            String string5 = this.wsInfo.getOSVersion();
            string5 = this.getOSMinVersion(string5);
            this.handleVHEntries(string5, string3, ACTION_ADD, this.wsInfo.isWebServiceON());
            ApacheVHEditor.updateDefaultVHFile(this.wsInfo.getWebServerDir() + CONF_FILE, string3, ACTION_ADD, this.wsInfo.isWebServiceON());
        }
        if (bl) {
            this.restartWS();
        }
    }

    @Override
    public void removeConnector() throws Exception {
        this.removeConnector(this.getStateWS().isStarted());
    }

    @Override
    public void removeConnector(boolean bl) throws Exception {
        this.removeConnector(bl, true);
    }

    @Override
    public void removeConnector(boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        File file = this.wsInfo.getAppServerWebServerDir();
        if (file == null) {
            this.wsInfo = propertyFileEditor.findEntry(this.wsInfo);
            if (this.wsInfo == null) {
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotConfigured"));
            }
            file = this.wsInfo.getAppServerWebServerDir();
        }
        if (Trace.ci) {
            Trace.trace("removeConnector(" + bl + "): jrunWsDir is " + file);
            Trace.trace("removeConnector(): script is " + this.wsInfo.getApacheScriptPath());
        }
        this.populateApacheWebSites();
        WebSite webSite = ApacheWebSites.getWebSite(this.wsInfo.getApacheVirtualHost());
        propertyFileEditor.removeEntry(file.getName());
        propertyFileEditor.writePropertyFile();
        try {
            object2 = new File(this.wsInfo.getWebServerDir() + CONF_FILE);
            if (!((File)object2).exists()) {
                object2 = new File(this.wsInfo.getWebServerDir() + APACHE2_CONF_FILE);
            }
            object = new ApacheConfEditor((File)object2, this.wsInfo);
            ((ApacheConfEditor)object).readApacheFile();
            ((ApacheConfEditor)object).remove(true, this.wsInfo.getAppServerWebServerDir().getCanonicalPath());
            this.updateWorkersPropertiesFile(this.wsInfo.getWebServerDir() + WORKERS_PROPERTIES);
        }
        catch (IOException iOException) {
            CIUtil.logDebug(iOException.getMessage());
        }
        if (bl && File.separatorChar == '\\') {
            try {
                this.stopWS();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.wsInfo.getPlatform().equals("intel-macosx64")) {
            object2 = new File(DEFAULT_SERVER_APP_HTTPD);
            if (((File)object2).exists()) {
                object = new ApacheConfEditor((File)object2, this.wsInfo);
                ((ApacheConfEditor)object).readApacheFile();
                ((ApacheConfEditor)object).remove(true, this.wsInfo.getAppServerWebServerDir().getCanonicalPath());
            }
            object = this.getOSMinVersion(this.wsInfo.getOSVersion());
            this.handleVHEntries((String)object, null, ACTION_REMOVE, this.wsInfo.isWebServiceON());
        }
        this.removeAppServerWsDir(bl2);
        if (ApacheWebSites.getNoOfConfiguredSites() == 1) {
            object2 = this.wsInfo.getWebServerDir() + File.separator + CONNECTOR_APACHE;
            object = new File((String)object2);
            ((File)object).delete();
            if (!isWindows) {
                String string = file.getParent() + File.separator + "shm";
                String[] stringArray = new String[]{"/bin/bash", "-c", "rm -rf \"" + string + "\""};
                try {
                    Process process = Runtime.getRuntime().exec(stringArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            if (File.separatorChar == '\\') {
                this.startWS();
            } else {
                this.restartWS();
            }
        }
    }

    private void handleVHEntries(String string, String string2, String string3, boolean bl) throws ConnectorInstallerException {
        if (Double.parseDouble(string) >= 10.8) {
            File file = new File(DEFAULT_SERVER_APP_HTTPD);
            if (file.exists()) {
                ApacheVHEditor.updateDefaultVHFile(DEFAULT_SERVER_APP_HTTPD, string2, string3, bl);
            }
        } else if (Double.parseDouble(string) >= 10.7) {
            ApacheVHEditor.updateDefaultVHFile(this.wsInfo.getWebServerDir() + CONF_FILE, string2, string3, bl);
        }
    }

    private String getOSMinVersion(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        string = stringTokenizer.nextToken();
        string = string + "." + stringTokenizer.nextToken();
        return string;
    }

    @Override
    public void modifyConnector() throws Exception {
        this.modifyConnector(this.getStateWS().isStarted());
    }

    @Override
    public void modifyConnector(boolean bl) throws Exception {
        throw new ConnectorInstallerException("modifyConnector TBD");
    }

    @Override
    public void getConnectorConfig() throws Exception {
        throw new ConnectorInstallerException("getConnectorConfig TBD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWS() throws WebServerException {
        block9: {
            if (File.separatorChar == '\\') {
                try {
                    if (new Win32Handler().startNTService(this.getServiceName())) {
                        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartNTService", (Object)this.getServiceName()));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartNTServiceErr", (Object)this.getServiceName()));
            }
            int n = 0;
            boolean bl = false;
            try {
                String string = this.getScriptPath() + START_ARG_UNIX;
                n = CIUtil.exec(string);
            }
            catch (Exception exception) {
                bl = true;
            }
            finally {
                if (n == 0 && !bl) break block9;
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StartServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
            }
        }
        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StartService", (Object)this.wsInfo.getWebServerDisplay()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWS() throws WebServerException {
        block11: {
            if (File.separatorChar == '\\') {
                try {
                    if (new Win32Handler().stopNTService(this.getServiceName())) {
                        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopNTService", (Object)this.getServiceName()));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopNTServiceErr", (Object)this.getServiceName()));
            }
            int n = 0;
            boolean bl = false;
            try {
                String string = this.getScriptPath() + STOP_ARG_UNIX;
                n = CIUtil.exec(string);
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (Exception exception) {
                bl = true;
            }
            finally {
                if (n == 0 && !bl) break block11;
                throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.StopServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
            }
        }
        CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.StopService", (Object)this.wsInfo.getWebServerDisplay()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWS() throws WebServerException {
        if (File.separatorChar == '\\') {
            this.stopWS();
            this.startWS();
        } else {
            block7: {
                int n = 0;
                boolean bl = false;
                try {
                    String string = this.getScriptPath() + RESTART_ARG_UNIX;
                    n = CIUtil.exec(string);
                }
                catch (Exception exception) {
                    bl = true;
                }
                finally {
                    if (n == 0 && !bl) break block7;
                    throw new WebServerException(this.wsInfo.getWebServer(), RB.getString((Object)this, "ConnectorInstaller.RestartServiceErr", (Object)this.wsInfo.getWebServerDisplay()));
                }
            }
            CIUtil.logInfo(RB.getString((Object)this, "ConnectorInstaller.RestartService", (Object)this.wsInfo.getWebServerDisplay()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebServerState getStateWS() {
        WebServerState webServerState = new WebServerState();
        if (File.separatorChar == '\\') {
            try {
                webServerState = this.getNTServiceState(this.getServiceName());
            }
            catch (Exception exception) {}
        } else {
            BufferedReader bufferedReader = null;
            String string = "";
            try {
                String string2;
                Runtime runtime = Runtime.getRuntime();
                string = this.getScriptPath() + STATUS_ARG_UNIX;
                Process process = runtime.exec(string);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    CIUtil.logDebug(string2);
                    if (string2.indexOf("stopped") >= 0) {
                        webServerState.setStopped();
                        break;
                    }
                    if (string2.indexOf("running") < 0) continue;
                    webServerState.setStarted();
                    break;
                }
                process.waitFor();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (Trace.ci) {
            Trace.trace("getStateWS: " + webServerState);
        }
        return webServerState;
    }

    private String getScriptPath() throws ConnectorInstallerException {
        if (this.scriptPath == null) {
            if (this.wsInfo.getApacheScriptPath().length() > 0) {
                this.scriptPath = CIUtil.quotePath(this.wsInfo.getApacheScriptPath());
                CIUtil.logDebug(RB.getString((Object)this, "CI.ApacheScriptPath", (Object)this.scriptPath));
                return this.scriptPath;
            }
            File file = null;
            String[] stringArray = !this.isStronghold ? unixScriptPaths : unixStrongholdScriptPaths;
            for (int i = 0; i < stringArray.length; ++i) {
                file = stringArray[i].charAt(0) == File.separatorChar ? new File(stringArray[i]) : new File(this.getServerRoot(), stringArray[i]);
                if (file.isFile()) {
                    this.scriptPath = file.getPath();
                    CIUtil.logInfo(RB.getString((Object)this, "CI.ApacheScriptPath", (Object)this.scriptPath));
                    return this.scriptPath;
                }
                CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)file.getPath()));
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.BadApacheScriptPath"));
        }
        return this.scriptPath;
    }

    private String getServerBinPath() throws ConnectorInstallerException {
        if (this.serverBinPath == null) {
            if (this.wsInfo.getApacheBinPath().length() > 0) {
                this.serverBinPath = this.wsInfo.getApacheBinPath();
                CIUtil.logDebug(RB.getString((Object)this, "CI.ApacheBinPath", (Object)this.serverBinPath));
                return this.serverBinPath;
            }
            String[] stringArray = File.separatorChar == '\\' ? ntBinPaths : unixBinPaths;
            File file = null;
            for (int i = 0; i < stringArray.length; ++i) {
                file = stringArray[i].charAt(0) == File.separatorChar ? new File(stringArray[i]) : new File(this.getServerRoot(), stringArray[i]);
                if (file.isFile()) {
                    this.serverBinPath = file.getPath();
                    CIUtil.logInfo(RB.getString((Object)this, "CI.ApacheBinPath", (Object)this.serverBinPath));
                    CheckApacheVersion checkApacheVersion = new CheckApacheVersion(this.serverBinPath);
                    if (!checkApacheVersion.apacheVersion.equalsIgnoreCase("32") && !checkApacheVersion.apacheVersion.equalsIgnoreCase("64")) continue;
                    return this.serverBinPath;
                }
                CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", (Object)file.getPath()));
            }
            throw new ConnectorInstallerException(RB.getString(this, "CI.BadApacheBinPath"));
        }
        return this.serverBinPath;
    }

    public static String getApacheBinPath(String string) throws ConnectorInstallerException {
        if (string == null || string.equals("")) {
            return "";
        }
        String string2 = "";
        String[] stringArray = File.separatorChar == '\\' ? ntBinPaths : unixBinPaths;
        File file = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].charAt(0) == File.separatorChar) {
                file = new File(stringArray[i]);
            } else {
                object = new File(string).getParentFile();
                file = new File((File)object, stringArray[i]);
            }
            if (!file.isFile()) continue;
            string2 = file.getPath();
            object = new CheckApacheVersion(string2);
            if (!((CheckApacheVersion)object).apacheVersion.equalsIgnoreCase("32") && !((CheckApacheVersion)object).apacheVersion.equalsIgnoreCase("64")) continue;
            return string2;
        }
        return string2;
    }

    private File getServerRoot() {
        if (this.serverRoot == null) {
            this.serverRoot = new File(this.wsInfo.getWebServerDir()).getParentFile();
        }
        return this.serverRoot;
    }

    @Override
    public boolean isValidVersion() throws ConnectorInstallerException {
        Object object;
        if (this.parseVersionStr(System.getProperty("WSConfig.WebServerVersion"))) {
            return true;
        }
        boolean bl = false;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            String string2;
            Object object2;
            String[] stringArray;
            object = new String[1];
            Runtime runtime = Runtime.getRuntime();
            object[0] = "LD_LIBRARY_PATH=" + new File(new File(this.getServerBinPath()).getParent()).getParent() + File.separatorChar + "lib";
            if (File.separatorChar == '/') {
                try {
                    stringArray = runtime.exec("env");
                    bufferedReader = new BufferedReader(new InputStreamReader(stringArray.getInputStream()));
                    object2 = "";
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.startsWith(LD_LIBRARY_PATH)) continue;
                        int n = string2.indexOf(61);
                        object2 = (String)object2 + string2.substring(n + 1);
                        break;
                    }
                    object[0] = object[0] + File.pathSeparator + (String)object2;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            if (Trace.ci) {
                Trace.trace(object[0]);
            }
            stringArray = new String[]{this.getServerBinPath(), "-v"};
            object2 = new ProcessBuilder(stringArray[0], stringArray[1]);
            Map<String, String> map = ((ProcessBuilder)object2).environment();
            String string3 = "";
            if (object[0].startsWith(LD_LIBRARY_PATH)) {
                int n = object[0].indexOf(61);
                string3 = string3 + object[0].substring(n + 1);
            }
            map.put(LD_LIBRARY_PATH, string3);
            Process process = ((ProcessBuilder)object2).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("Server version:");
                if (n >= 0 && (n = string2.indexOf("Apache", n)) >= 0 && (n = string2.indexOf("/", n)) >= 0) {
                    this.wsVersionStr = string2.substring(n += "/".length());
                    if (!this.parseVersionStr(this.wsVersionStr)) break;
                    if (string2.indexOf("Stronghold") >= 0) {
                        this.isStronghold = true;
                    }
                    CIUtil.logInfo(string2);
                    bl = true;
                    break;
                }
                CIUtil.logDebug(string2);
            }
            process.waitFor();
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.BadApacheVersion", (Object)string, (Object)new File(this.getServerBinPath())));
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            object = RB.getString((Object)this, "ConnectorInstaller.WSVersionNotSupported", (Object)this.wsVersionStr, (Object)this.supportedVersionStr);
            CIUtil.logInfo((String)object);
            throw new WSVersionNotSupportedException((String)object);
        }
        return bl;
    }

    private boolean parseVersionStr(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        if (stringTokenizer.countTokens() >= 3) {
            wsMajorVer = Integer.parseInt(stringTokenizer.nextToken());
            wsMinorVer = Integer.parseInt(stringTokenizer.nextToken());
            this.wsBuildNum = Integer.parseInt(stringTokenizer.nextToken());
            if (Trace.ci) {
                Trace.trace("version " + wsMajorVer + "." + wsMinorVer + "." + this.wsBuildNum + " (min " + this.apache2PatchLevel + ")");
            }
            if (wsMajorVer == 2 && (wsMinorVer > 0 || this.wsBuildNum >= this.apache2PatchLevel)) {
                return true;
            }
        }
        return false;
    }

    void updateWorkersPropertiesFile(String string) throws ConnectorInstallerException {
        boolean bl = false;
        String string2 = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder("");
        String string3 = "";
        string3 = this.wsInfo.getClustername();
        if (string3.equals("")) {
            string3 = this.wsInfo.getInstancename();
        }
        if (new File(string).exists() && !this.checkIfWorkerAlreadyConfiguredWithApache(string3)) {
            Object object;
            Object object2;
            Object object3;
            try {
                CIUtil.backupFile(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object3 = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
                object2 = null;
                try {
                    object = null;
                    while ((object = ((BufferedReader)object3).readLine()) != null) {
                        if (((String)object).startsWith("#Start") && ((String)object).contains(string3) || ((String)object).contains("worker.list") && ((String)object).contains(string3)) {
                            bl = true;
                            continue;
                        }
                        if (!bl) {
                            stringBuilder.append((String)object + string2);
                        }
                        if (((String)object).startsWith("#End") && ((String)object).contains(string3)) {
                            bl = false;
                        }
                        if (!bl || !((String)object).contains("worker.list")) continue;
                        stringBuilder.append((String)object + string2);
                        bl = false;
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (object3 != null) {
                        if (object2 != null) {
                            try {
                                ((BufferedReader)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            ((BufferedReader)object3).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", (Object)string));
            }
            object3 = new String(stringBuilder);
            try {
                object2 = new PrintWriter(new BufferedWriter(new FileWriter(string)));
                object = null;
                try {
                    ((PrintWriter)object2).print((String)object3);
                    ((PrintWriter)object2).flush();
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((PrintWriter)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((PrintWriter)object2).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void changesToBeMadeForSELinux() throws ConnectorInstallerException {
        if (isLinux && this.checkSELinuxEnabled()) {
            Object object;
            String[] stringArray;
            Object object2;
            Object object3;
            String[] stringArray2;
            Runtime runtime = Runtime.getRuntime();
            String string = this.wsInfo.getAppServerWebServerDir() + File.separator + "mod_jk.log";
            String[] stringArray3 = new String[]{"/bin/bash", "-c", "touch \"" + string + "\""};
            try {
                stringArray2 = runtime.exec(stringArray3);
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", (Object)string));
            }
            stringArray2 = new String[]{"/bin/bash", "-c", "chcon -t httpd_log_t -u system_u \"" + string + "\""};
            try {
                object3 = runtime.exec(stringArray2);
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", (Object)string));
            }
            object3 = this.wsInfo.getAppServerWebServerDir().getParent() + File.separator + "shm";
            String[] stringArray4 = new String[]{"/bin/bash", "-c", "chcon -t httpd_sys_rw_content_t -u system_u \"" + (String)object3 + "\""};
            try {
                object2 = runtime.exec(stringArray4);
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", object3));
            }
            object2 = this.wsInfo.getAppServerWebServerDir() + File.separator + "uriworkermap.properties";
            String[] stringArray5 = new String[]{"/bin/bash", "-c", "chmod 550 \"" + (String)object2 + "\""};
            try {
                stringArray = runtime.exec(stringArray5);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            stringArray = new String[]{"/bin/bash", "-c", "chmod 560 \"" + string + "\""};
            try {
                object = runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            object = this.wsInfo.getAppServerWebServerDir().getParent();
            ArrayList<File> arrayList = new ArrayList<File>();
            arrayList.add(new File((String)object + File.separator + ".."));
            arrayList.add(new File((String)object));
            for (File file : arrayList) {
                String string2 = file.getAbsolutePath();
                try {
                    Set<PosixFilePermission> set = Files.getPosixFilePermissions(Paths.get(string2, new String[0]), new LinkOption[0]);
                    if (set.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) continue;
                    Stream<PosixFilePermission> stream = Stream.of(PosixFilePermission.OTHERS_EXECUTE);
                    stream.forEach(posixFilePermission -> set.add((PosixFilePermission)((Object)posixFilePermission)));
                    Files.setPosixFilePermissions(Paths.get(string2, new String[0]), set);
                    Set<PosixFilePermission> set2 = Files.getPosixFilePermissions(Paths.get(string2, new String[0]), new LinkOption[0]);
                    if (set2.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewGccVersionRequired() throws WSVersionNotSupportedException {
        int n;
        Object object;
        Object object2;
        if (this.wsInfo.getOSName().compareToIgnoreCase("linux") != 0 || !new File("/etc/redhat-release").exists()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = System.getProperty("WSConfig.gcc");
        if (string != null) {
            if (string.equals("3") || string.startsWith("3.")) {
                bl2 = true;
            } else {
                bl = true;
            }
        }
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufferedReader = null;
        String string2 = "";
        int n2 = 0;
        try {
            string2 = "cat /etc/redhat-release";
            object2 = runtime.exec(string2);
            bufferedReader = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
            while ((object = bufferedReader.readLine()) != null) {
                int n3 = ((String)object).indexOf("release ");
                if (n3 < 0) continue;
                int n4 = ((String)object).indexOf(" ", n3 += "release ".length());
                n = ((String)object).indexOf(".", n3);
                if (n4 <= 0 && n <= 0) break;
                int n5 = n4 > 0 && n > 0 ? (n4 <= n ? n4 : n) : (n4 > 0 ? n4 : n);
                String string3 = ((String)object).substring(n3, n5);
                n2 = Integer.parseInt(string3);
                CIUtil.logInfo((String)object);
                if (Trace.ci) {
                    Trace.trace("OS version: " + string3 + " (" + n2 + ")");
                }
                if (n2 == 7 || n2 == 2) break;
                if (!bl) {
                    bl2 = true;
                }
                if (!Trace.ci) break;
                Trace.trace("connector built with gcc3 or compat-glibc-7.x rpm required");
                break;
            }
            ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            if (Trace.ci) {
                Trace.trace("exception executing " + string2 + " continuing...");
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        object2 = "";
        if (bl2) {
            try {
                String string4;
                object = new String[]{"LD_LIBRARY_PATH=" + new File(new File(this.getServerBinPath()).getParent()).getParent() + File.separatorChar + "lib"};
                if (File.separatorChar == '/') {
                    try {
                        Process process = runtime.exec("env");
                        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        String string5 = "";
                        while ((string4 = bufferedReader.readLine()) != null) {
                            if (!string4.startsWith(LD_LIBRARY_PATH)) continue;
                            n = string4.indexOf(61);
                            string5 = string5 + string4.substring(n + 1);
                            break;
                        }
                        Object object3 = object;
                        object3[0] = (String)object3[0] + File.pathSeparator + string5;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                    }
                }
                if (Trace.ci) {
                    Trace.trace((String)object[0]);
                }
                string2 = this.getServerBinPath() + " -V";
                Process process = runtime.exec(string2, (String[])object);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string4 = bufferedReader.readLine()) != null) {
                    int n6 = string4.indexOf("Module Magic Number: ");
                    if (n6 < 0) continue;
                    if (Trace.ci) {
                        Trace.trace(string4);
                    }
                    if (string4.indexOf("20020628:", n6 += "Module Magic Number: ".length()) >= 0) {
                        object2 = APACHE2_MMN_MAJOR_RH89;
                        break;
                    }
                    if (string4.indexOf("20020903:", n6) >= 0) {
                        object2 = APACHE2_MMN_MAJOR;
                        break;
                    }
                    this.wsInfo.setApacheApxs(true);
                    break;
                }
                process.waitFor();
            }
            catch (WSVersionNotSupportedException wSVersionNotSupportedException) {
                throw wSVersionNotSupportedException;
            }
            catch (Exception exception) {
                if (Trace.ci) {
                    Trace.trace("exception executing " + string2 + " continuing...");
                }
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (((String)object2).length() > 0) {
                if (Trace.ci) {
                    Trace.trace("Using magic number " + (String)object2 + " to determine connector");
                }
                this.resourceName = "gcc3/mod_jk20.so." + (String)object2;
                CIUtil.logDebug("Using resource " + this.resourceName);
                if (object2 == APACHE2_MMN_MAJOR_RH89) {
                    this.apache2PatchLevel = AP_SERVER_PATCHLEVEL_RH89;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isDsoConfigured() throws ConnectorInstallerException {
        boolean bl = false;
        BufferedReader bufferedReader = null;
        String string = "";
        try {
            String string2;
            Object object;
            Object object2;
            String[] stringArray = new String[1];
            Runtime runtime = Runtime.getRuntime();
            stringArray[0] = "LD_LIBRARY_PATH=" + new File(new File(this.getServerBinPath()).getParent()).getParent() + File.separatorChar + "lib";
            if (File.separatorChar == '/') {
                try {
                    object2 = runtime.exec("env");
                    bufferedReader = new BufferedReader(new InputStreamReader(((Process)object2).getInputStream()));
                    object = "";
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if (!string2.startsWith(LD_LIBRARY_PATH)) continue;
                        int n = string2.indexOf(61);
                        object = (String)object + string2.substring(n + 1);
                        break;
                    }
                    stringArray[0] = stringArray[0] + File.pathSeparator + (String)object;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
            if (Trace.ci) {
                Trace.trace(stringArray[0]);
            }
            object2 = new ProcessBuilder(string);
            object = ((ProcessBuilder)object2).environment();
            String string3 = "";
            if (stringArray[0].startsWith(LD_LIBRARY_PATH)) {
                int n = stringArray[0].indexOf(61);
                string3 = string3 + stringArray[0].substring(n + 1);
            }
            object.put(LD_LIBRARY_PATH, string3);
            Process process = ((ProcessBuilder)object2).start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (Trace.ci) {
                    Trace.trace(string2);
                }
                if (string2.indexOf("mod_so.c") < 0) continue;
                bl = true;
                break;
            }
            process.waitFor();
        }
        catch (Exception exception) {
            CIUtil.logDebug(RB.getString((Object)this, "CI.AssumeDSO", (Object)string));
            bl = true;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            throw new ConnectorInstallerException(RB.getString(this, "CI.NoDSOSupport"));
        }
    }

    private String getModuleName() throws ConnectorInstallerException {
        return ApacheInstaller.getMajorVersion(this.wsInfo.getApacheBinPath()) >= 2 ? (ApacheInstaller.getMinorVersion(this.wsInfo.getApacheBinPath()) >= 2 ? "mod_jrun22.c" : "mod_jrun20.c") : "mod_jrun.c";
    }

    String getResourceName() throws ConnectorInstallerException {
        if (this.resourceName == null) {
            this.resourceName = ApacheInstaller.getMajorVersion(this.wsInfo.getApacheBinPath()) >= 2 && ApacheInstaller.getMinorVersion(this.wsInfo.getApacheBinPath()) < 4 ? CONNECTOR_APACHE22 : (ApacheInstaller.getMajorVersion(this.wsInfo.getApacheBinPath()) >= 2 && ApacheInstaller.getMinorVersion(this.wsInfo.getApacheBinPath()) >= 4 ? CONNECTOR_APACHE24 : CONNECTOR_APACHE);
        }
        return this.resourceName;
    }

    @Override
    String getConnectorName() throws ConnectorInstallerException {
        return CONNECTOR_APACHE;
    }

    @Override
    boolean copyFiles(File file, boolean bl) throws Exception {
        String string = this.wsInfo.getResourcePath() + this.getResourceName();
        String string2 = file + File.separator + this.getConnectorName();
        return CIUtil.extractConnector(string, string2, bl);
    }

    protected static int getMajorVersion(String string) throws ConnectorInstallerException {
        if (wsMajorVer == 0) {
            ApacheInstaller.isValidVersion(string);
        }
        return wsMajorVer;
    }

    protected static int getMinorVersion(String string) throws ConnectorInstallerException {
        if (wsMinorVer == 0) {
            ApacheInstaller.isValidVersion(string);
        }
        return wsMinorVer;
    }

    private String getServiceName() {
        if (this.serviceName.length() == 0) {
            try {
                this.serviceName = this.wsInfo.getApacheNTServiceName();
                if (this.serviceName.length() == 0) {
                    this.serviceName = new Win32Handler().getServiceNameFromPath(this.getServerBinPath());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.serviceName;
    }

    private boolean buildModuleFromSource(String string, String string2) throws ConnectorInstallerException, IOException {
        String string3;
        String string4 = ApacheInstaller.getMajorVersion(this.wsInfo.getApacheBinPath()) >= 2 ? (ApacheInstaller.getMinorVersion(this.wsInfo.getApacheBinPath()) >= 2 ? "jrun22" : "jrun20") : "jrun";
        string = string + File.separatorChar;
        JarUtils jarUtils = new JarUtils(CIUtil.getJarDir() + File.separator + CIUtil.getJarFilename());
        jarUtils.extractToDir("connectors/src/", string);
        String string5 = new File(this.getServerBinPath()).getParent() + File.separatorChar + "apxs";
        if (!new File(string5).exists() && new File(string3 = new File(this.getServerBinPath()).getParent() + File.separatorChar + "apxs2").exists()) {
            string5 = string3;
        }
        string3 = "";
        InetAddress inetAddress = InetAddress.getByName(string2);
        if (IPUtil.isIPv6Address(inetAddress)) {
            string3 = " -DUSE_WINSOCK2";
        }
        String string6 = string5 + string3 + " -c  -Wc,-w -n " + string4 + " " + string + this.getModuleName() + " \\\n" + string + "jrun_maptable_impl.c \\\n" + string + "jrun_mutex.c \\\n" + string + "jrun_property.c \\\n" + string + "jrun_proxy.c \\\n" + string + "jrun_session.c \\\n" + string + "jrun_utils.c \\\n" + string + "platform.c \n";
        String string7 = ApacheInstaller.getMajorVersion(this.wsInfo.getApacheBinPath()) >= 2 ? string5 + " -i -S LIBEXECDIR=" + string + " -n " + string4 + " " + string + "mod_" + string4 + ".la\n" : "\n";
        String string8 = "strip " + string + this.getConnectorName() + "\n";
        String string9 = string + "build_" + string4;
        FileWriter fileWriter = new FileWriter(string9);
        fileWriter.write("#!/bin/sh -e\n");
        fileWriter.write("#\n");
        fileWriter.write("# To build Apache module " + string4 + " for JRun/ColdFusion\n");
        fileWriter.write("#\n");
        fileWriter.write(string6);
        fileWriter.write(string7);
        fileWriter.write(string8);
        fileWriter.close();
        CIUtil.makeExecutable(string9);
        if (!new File(string5).exists()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.ApacheNoApxs", (Object)string5) + " " + RB.getString((Object)this, "CI.Apachehttpd-devel", null) + RB.getString((Object)this, "CI.ApacheFromSource", (Object)string9));
        }
        if (CIUtil.exec(string9, true) != 0) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "CI.ApacheFromSource", (Object)string9));
        }
        return true;
    }

    public static boolean isValidVersion(String string) {
        try {
            ApacheInstaller apacheInstaller = new ApacheInstaller();
            apacheInstaller.wsInfo = new WebServerInfo();
            apacheInstaller.wsInfo.setWebServer("Apache");
            apacheInstaller.wsInfo.setApacheBinPath(string);
            return apacheInstaller.isValidVersion();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println("isValidVersion returns " + ApacheInstaller.isValidVersion("d:\\apache2\\bin\\apache.exe"));
    }
}

