/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;

public class ApacheVHEditor {
    private static String getDefaultVirtualHostFile(File file, boolean bl) throws ConnectorInstallerException {
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        string2 = bl ? "WEBSERVICE_ON" : "!WEBSERVICE_ON";
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(string2) < 0) continue;
                string3 = bufferedReader.readLine();
                String string4 = string3.trim();
                while (string4 != null && string4.indexOf(".conf") > 0) {
                    string4 = string3.trim();
                    if (string4 != null && string4.toLowerCase().startsWith("include") && string4.indexOf(" ") != -1) {
                        String string5 = string4.substring(string4.indexOf(" "));
                        if (bl) {
                            string5 = string5.substring(0, string5.lastIndexOf("/"));
                        }
                        if (new File(string5.trim()).exists()) {
                            string = string5.trim();
                            break;
                        }
                    }
                    string3 = bufferedReader.readLine();
                }
                if (string == null) continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    private static int getDefaultVHPort(String string) throws ConnectorInstallerException {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.trim().toLowerCase().startsWith("listen")) continue;
                String string3 = string2.substring(string2.indexOf(":") + 1);
                int n = Integer.parseInt(string3.trim());
                return n;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ConnectorInstallerException("No default VirtualHost file present");
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException("Failed to read the Default VirtualHost file. Check for the required permission for the current user");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConnectorInstallerException("Error occured while parsing the VirtualHost port");
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return -1;
    }

    private static File[] getConfigFiles(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".conf");
            }
        };
        return file.listFiles(filenameFilter);
    }

    private static File getDefaultVHFile(File[] fileArray, int n) throws ConnectorInstallerException {
        block16: for (int i = 0; i < fileArray.length; ++i) {
            String string = null;
            File file = fileArray[i];
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                while (true) {
                    if ((string = bufferedReader.readLine()) == null) continue block16;
                    if (!string.toLowerCase().trim().startsWith("<virtualhost") || string.indexOf(":") <= 0) continue;
                    String string2 = string.trim().substring(string.indexOf(":") + 1, string.indexOf(">"));
                    if (n != Integer.parseInt(string2.trim())) continue;
                    File file2 = file;
                    return file2;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException("Failed to update the Default VirtualHost file. Check the permission of virtualhost file.");
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addVHConfiguration(File file, String string) throws ConnectorInstallerException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        Writer writer = null;
        try {
            CIUtil.backupFile(file.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException("Failed to take the backup of VirtualHost file");
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().startsWith("JkMountFile")) {
                    boolean bl = false;
                    return bl;
                }
                if (string2.trim().startsWith("DirectoryIndex")) {
                    string2 = ApacheVHEditor.updateIndexFileEntry(string2);
                }
                if (string2.trim().equalsIgnoreCase("</virtualhost>")) {
                    stringBuffer.append("\tJkMountFile \"" + string + "\" ");
                    stringBuffer.append("\n");
                } else if (string2.toLowerCase().lastIndexOf("</virtualhost>") > 0) {
                    stringBuffer.append(string2.substring(0, string2.toLowerCase().indexOf("</virtualhost>")));
                    stringBuffer.append("\n");
                    stringBuffer.append("\tJkMountFile \"" + string + "\" ");
                    stringBuffer.append(string2.substring(string2.toLowerCase().indexOf("</virtualhost>") + 14));
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            writer.write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    private static String updateIndexFileEntry(String string) {
        if (string.indexOf("index.cfm") != -1) {
            return string;
        }
        if (string.trim().startsWith("DirectoryIndex")) {
            return string + " index.cfm";
        }
        if (string.trim().indexOf("DirectoryIndex") != -1) {
            String string2 = string.substring(0, string.indexOf("DirectoryIndex") + 14);
            string = string2 + " index.cfm " + string.substring(string.indexOf("DirectoryIndex") + 14);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeVHConfiguration(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        Writer writer = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().startsWith("JkMountFile")) continue;
                if (string.trim().startsWith("DirectoryIndex") && string.indexOf("index.cfm") != -1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.trim().startsWith("index.cfm")) continue;
                        stringBuffer2.append(string2);
                        stringBuffer2.append(" ");
                    }
                    string = stringBuffer2.toString();
                }
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            writer.write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    static boolean updateDefaultVHFile(String string, String string2, String string3, boolean bl) throws ConnectorInstallerException {
        try {
            File[] fileArray;
            if (string3 == null) {
                throw new ConnectorInstallerException("Wrong action on connector configuration");
            }
            File file = new File(string);
            String string4 = ApacheVHEditor.getDefaultVirtualHostFile(file, bl);
            if (string4 == null || !new File(string4).exists()) {
                return false;
            }
            String string5 = string4;
            if (!bl) {
                string5 = new File(string4).getParent();
            }
            if ((fileArray = ApacheVHEditor.getConfigFiles(string5)) == null || fileArray.length == 0) {
                throw new ConnectorInstallerException("unable to locate the VirtualHost configuration files.");
            }
            if (string3.equals("Add")) {
                if (!bl) {
                    int n = ApacheVHEditor.getDefaultVHPort(string4);
                    if (n == -1) {
                        return false;
                    }
                    File file2 = ApacheVHEditor.getDefaultVHFile(fileArray, n);
                    if (file2 == null) {
                        throw new ConnectorInstallerException("Failed to locate the default VirtualHost file");
                    }
                    return ApacheVHEditor.addVHConfiguration(file2, string2);
                }
                return ApacheVHEditor.addVHConfiguration(fileArray, string2);
            }
            if (!bl) {
                int n = ApacheVHEditor.getDefaultVHPort(string4);
                File file3 = ApacheVHEditor.getDefaultVHFile(fileArray, n);
                if (file3 == null) {
                    throw new ConnectorInstallerException("Failed to locate the default VirtualHost file");
                }
                return ApacheVHEditor.removeVHConfiguration(file3);
            }
            return ApacheVHEditor.removeVHConfiguration(fileArray);
        }
        catch (ConnectorInstallerException connectorInstallerException) {
            throw new ConnectorInstallerException(connectorInstallerException.getMessage());
        }
    }

    private static boolean removeVHConfiguration(File[] fileArray) {
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (ApacheVHEditor.removeVHConfiguration(fileArray[i])) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean addVHConfiguration(File[] fileArray, String string) throws ConnectorInstallerException {
        boolean bl = true;
        for (int i = 0; i < fileArray.length; ++i) {
            if (ApacheVHEditor.addVHConfiguration(fileArray[i], string)) continue;
            bl = false;
        }
        return bl;
    }
}

