/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.ApacheConfEditor;
import com.adobe.coldfusion.connector.connectorinstaller.ApacheInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.util.RB;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApacheWebSites {
    private static Map allSites = new HashMap();
    private static Map configuredSites = new HashMap();
    private static int noOfConfiguredSites;

    public static Map getAllSites() {
        return allSites;
    }

    public static File getConfFile(String string) {
        File file = new File(string + "/httpd.conf");
        if (!file.exists()) {
            file = new File(string + "/apache2.conf");
        }
        return file;
    }

    public static void setConfiguredWebSites(WebServerInfo webServerInfo) {
        WebServerInfo webServerInfo2;
        PropertyFileEditor propertyFileEditor = null;
        try {
            propertyFileEditor = new PropertyFileEditor();
        }
        catch (Exception exception) {
            return;
        }
        configuredSites.clear();
        while ((webServerInfo2 = propertyFileEditor.nextEntry()) != null) {
            if (!webServerInfo2.getWebServer().equalsIgnoreCase("apache")) continue;
            configuredSites.put(webServerInfo2.getApacheVirtualHost(), webServerInfo2.getWebServerDir());
        }
    }

    public static Map getConfiguredSites() {
        return configuredSites;
    }

    private static boolean isRhelOrCentOS(Runtime runtime) {
        if (ApacheConfEditor.IS_MAC || ConnectorInstaller.isWindows) {
            return false;
        }
        String[] stringArray = new String[]{"bash", "-c", "cat /etc/*-release"};
        try {
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            do {
                string = bufferedReader.readLine();
                if (!(string = string.trim()).contains("rhel") && !string.contains("CentOS")) continue;
                return true;
            } while (string != null);
        }
        catch (Exception exception) {
            CIUtil.logDebug("Error while accessing the /etc/*-release file");
            CIUtil.logDebug(exception.getMessage());
            return false;
        }
        return false;
    }

    public static void populateWebSites(String string, String string2) throws ConnectorInstallerException {
        if (string == "" || string == null) {
            string = ApacheInstaller.getApacheBinPath(string2);
        }
        if (string == "") {
            return;
        }
        allSites.clear();
        noOfConfiguredSites = 0;
        HashSet<String> hashSet = new HashSet<String>();
        File file = ApacheWebSites.getConfFile(string2);
        WebSite webSite = new WebSite("All", file.getAbsolutePath(), 0, true);
        allSites.put(webSite.getSiteName(), webSite);
        hashSet.add(webSite.getConfLocation());
        WebSite webSite2 = new WebSite("All-Individually", file.getAbsolutePath(), 0, false);
        allSites.put(webSite2.getSiteName(), webSite2);
        hashSet.add(webSite2.getConfLocation());
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{ApacheWebSites.isRhelOrCentOS(runtime) ? "httpd" : string, "-t", "-D", "DUMP_VHOSTS"};
        try {
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string3 = string3.trim();
                Matcher matcher = Pattern.compile(".*\\s([^\"]+)\\s\\(([^)]+)\\)").matcher(string3);
                if (matcher.find()) {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    String string6 = new File(string5.substring(0, string5.lastIndexOf(":"))).getAbsolutePath();
                    int n = Integer.parseInt(string5.substring(string5.lastIndexOf(":") + 1));
                    WebSite webSite3 = new WebSite(string4, string6, n, false);
                    allSites.put(string4, webSite3);
                    hashSet.add(webSite3.getConfLocation());
                }
                string3 = bufferedReader.readLine();
            }
            if (process.waitFor() != 0) {
                CIUtil.logDebug("Error while getting Apache Websites. Make sure you have administrator privileges");
                System.out.println("Error while getting Apache Websites. Make sure you have administrator privileges");
            }
            ApacheWebSites.parseConfFiles(hashSet);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static ArrayList getWebSites() {
        ArrayList arrayList = new ArrayList(allSites.values());
        return arrayList;
    }

    public static int getNoOfConfiguredSites() {
        return noOfConfiguredSites;
    }

    public static WebSite getWebSite(String string) throws ConnectorInstallerException {
        WebSite webSite = (WebSite)allSites.get(string);
        if (webSite == null) {
            throw new ConnectorInstallerException(RB.getString(ApacheWebSites.class, "CI.ApacheVHostNotFound", (Object)string));
        }
        return webSite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseConfFiles(Set<String> set) throws ConnectorInstallerException {
        String string = CIUtil.getJRunDir();
        boolean bl = false;
        for (String string2 : set) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(string2));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.startsWith("#")) continue;
                    if (string3.indexOf("mod_jk.conf") >= 0) {
                        bl = true;
                        continue;
                    }
                    if (string3.indexOf("mod_jk_vhost.conf") < 0) continue;
                    String[] stringArray = string3.trim().split(" ");
                    String string4 = "";
                    for (String string5 : stringArray) {
                        if (string5.indexOf("mod_jk_vhost.conf") < 0) continue;
                        string4 = new File(string5).getParentFile().getParent().replace("\"", " ").trim();
                        if (string.equals(string4)) {
                            ++noOfConfiguredSites;
                            continue;
                        }
                        noOfConfiguredSites = 0;
                        throw new ConnectorInstallerException(RB.getString(ApacheWebSites.class, "CI.WebServerUnconfigurable"));
                    }
                }
            }
            catch (IOException iOException) {}
            continue;
            finally {
                try {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bl && noOfConfiguredSites == 0) {
            throw new ConnectorInstallerException(RB.getString(ApacheWebSites.class, "CI.WebServerUnconfigurable"));
        }
    }
}

