/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.JarUtils;
import com.adobe.coldfusion.connector.launcher.JRunPumpStreamHandler;
import com.adobe.coldfusion.connector.logger.FileLogEventHandler;
import com.adobe.coldfusion.connector.logger.Logger;
import com.adobe.coldfusion.connector.logger.LoggerService;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.GeneralizedURLDecoder;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public final class CIUtil {
    private static String jarDir;
    private static String jarFile;
    private static String jrunDir;
    private static boolean isRunningDebugger;
    private static Logger logger;
    private static FileLogEventHandler handler;
    private static boolean logToStderr;

    public static void exit(int n) {
        System.exit(n);
    }

    public static String getJarFilename() {
        return jarFile;
    }

    public static String getCurrentDir() {
        String string = System.getProperty("user.dir");
        if (string != null && string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getJarDir() {
        if (jarDir == null) {
            jarDir = GeneralizedURLDecoder.decode(CIUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
            if (jarDir.lastIndexOf(".jar") >= 0 || jarDir.lastIndexOf(".zip") >= 0) {
                File file = new File(jarDir);
                jarDir = file.getParent();
                jarFile = file.getName();
                isRunningDebugger = false;
            } else {
                URL uRL = CIUtil.class.getClassLoader().getResource(jarFile);
                if (uRL != null) {
                    File file = new File(uRL.getFile());
                    jarDir = file.getParent();
                } else {
                    jarDir = "";
                }
                isRunningDebugger = true;
            }
            CIUtil.logDebug(RB.getString(CIUtil.class, "CIUtil.DirIs", (Object)"jarDir", (Object)jarDir));
        }
        return jarDir;
    }

    public static String getJRunDir() {
        if (jrunDir == null) {
            File file = new File(CIUtil.getJarDir());
            jrunDir = file.getParentFile().getParentFile().getParentFile() + File.separator + "config" + File.separator + "wsconfig";
            File file2 = new File(jrunDir);
            if (!file2.isDirectory() && !file2.mkdir()) {
                CIUtil.logError(RB.getString(CIUtil.class, "ConnectorInstaller.WriteDirErr", (Object)file2.getPath()));
            }
            CIUtil.logDebug(RB.getString(CIUtil.class, "CIUtil.DirIs", (Object)"jrunDir", (Object)jarDir));
        }
        return jrunDir;
    }

    public static void deleteDir(File file) {
        if (file != null && file.isDirectory()) {
            if (file.getPath().indexOf(CIUtil.getJRunDir()) < 0) {
                CIUtil.logError(RB.getString(CIUtil.class, "ConnectorInstaller.DirNotFound", file));
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        CIUtil.deleteDir(fileArray[i]);
                        continue;
                    }
                    if (fileArray[i].delete()) {
                        if (!Trace.ci) continue;
                        Trace.trace(RB.getString(CIUtil.class, "ConnectorInstaller.DeleteFile", (Object)fileArray[i].getPath()));
                        continue;
                    }
                    CIUtil.logDebug(RB.getString(CIUtil.class, "ConnectorInstaller.DeleteFileErr", (Object)fileArray[i].getPath()));
                }
            }
            if (file.delete()) {
                CIUtil.logDebug(RB.getString(CIUtil.class, "ConnectorInstaller.DeleteDir", (Object)file.getPath()));
            } else {
                CIUtil.logDebug(RB.getString(CIUtil.class, "ConnectorInstaller.DeleteDirErr", (Object)file.getPath()));
            }
        }
    }

    public static void backupFile(String string) throws Exception {
        int n = 1;
        String string2 = string + "." + n;
        File file = new File(string2);
        while (file.exists()) {
            string2 = string + "." + ++n;
            file = new File(string2);
        }
        File file2 = new File(string);
        if (file2.exists()) {
            BufferedReader bufferedReader = null;
            PrintWriter printWriter = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), StandardCharsets.UTF_8));
                printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)));
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null) {
                    printWriter.println(string3);
                }
                printWriter.flush();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void backupDir(File file) throws IOException {
        if (file == null) {
            return;
        }
        String string = file.getName();
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        if (!(file2 = new File(file2.getCanonicalPath() + File.separator + "backup" + File.separator)).exists()) {
            file2.mkdirs();
        }
        file2.setWritable(true);
        String string2 = file2.getCanonicalPath() + File.separator + string;
        int n = 1;
        String string3 = string2 + "." + n;
        file2 = new File(string3);
        while (file2.exists()) {
            string3 = string2 + "." + ++n;
            file2 = new File(string3);
        }
        if (file.exists()) {
            FileUtils.copyDir(file, file2);
        }
    }

    public static String quotePath(String string) {
        if (File.separatorChar == '\\' && string.charAt(0) != '\"' && string.indexOf(32) >= 0) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String unquotePath(String string) {
        if (File.separatorChar == '\\' && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String unquoteString(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String getPath(File file) {
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    static boolean extractConnector(String string, String string2, boolean bl) throws IOException {
        boolean bl2 = false;
        String string3 = CIUtil.getJarDir() + File.separator + jarFile;
        File file = new File(string3);
        File file2 = new File(string2);
        JarUtils jarUtils = new JarUtils(string3);
        if (bl && !isRunningDebugger || file2.lastModified() < jarUtils.getLastModified(string)) {
            jarUtils.extractToFile(string, string2);
            CIUtil.makeExecutable(string2);
            CIUtil.logDebug(RB.getString(CIUtil.class, "ConnectorInstaller.CreateFile", (Object)string2));
            bl2 = true;
        } else if (Trace.ci) {
            Trace.trace(RB.getString(CIUtil.class, "CI.FileNotExtracted", (Object)string2, (Object)string, (Object)file));
        }
        return bl2;
    }

    static void createLogger(boolean bl, String string) {
        try {
            logger = new LoggerService();
            logger.setDebugEnabled(false);
            logger.setInfoEnabled(true);
            logger.setWarningEnabled(true);
            logger.setErrorEnabled(true);
            handler = new FileLogEventHandler();
            String string2 = CIUtil.getJRunDir() + File.separator + "wsconfig.log";
            handler.setFilename(string2);
            logger.addLogEventHandler(handler);
            if (string.length() > 0) {
                logger.logInfo(string);
            }
            logToStderr = bl;
        }
        catch (Exception exception) {
            CIUtil.logDebug(exception.getMessage());
        }
    }

    static void logDebug(String string) {
        CIUtil.logDebug(string, null);
    }

    static void logDebug(String string, Throwable throwable) {
        if (logger != null) {
            logger.logDebug(string, throwable);
            logger.flush();
        }
        if (logToStderr && logger.isDebugEnabled()) {
            System.err.println(string);
        }
    }

    static void logError(String string) {
        CIUtil.logError(string, null);
    }

    static void logError(String string, Throwable throwable) {
        if (logger != null) {
            logger.logError(string, throwable);
        }
        if (logToStderr) {
            System.err.println(string);
        }
    }

    static void logInfo(String string) {
        if (logger != null) {
            logger.logInfo(string);
        }
        if (logToStderr) {
            System.err.println(string);
        }
    }

    static void logWarning(String string) {
        if (logger != null) {
            logger.logWarning(string);
        }
        if (logToStderr) {
            System.err.println(string);
        }
    }

    static void setDebugEnabled(boolean bl) {
        if (logger != null) {
            logger.setDebugEnabled(bl);
        }
    }

    public static boolean isDebugEnabled() {
        if (logger != null) {
            return logger.isDebugEnabled();
        }
        return false;
    }

    public static void makeExecutable(String string) {
        if (File.separatorChar == '/') {
            CIUtil.exec("chmod +x " + string);
            CIUtil.logDebug("Set permission to execute on " + string);
        }
    }

    public static void makeExecutableAndWritable(String string) {
        if (File.separatorChar == '/') {
            CIUtil.exec("chmod 777 " + string);
            CIUtil.logDebug("Set permission to 777 on " + string);
        }
    }

    public static int exec(String string, boolean bl) {
        int n = -1;
        CIUtil.logDebug(RB.getString(CIUtil.class, "CIUtil.Exec", (Object)string));
        try {
            JRunPumpStreamHandler jRunPumpStreamHandler = null;
            jRunPumpStreamHandler = logger != null && !logToStderr ? new JRunPumpStreamHandler(logger) : new JRunPumpStreamHandler();
            Process process = Runtime.getRuntime().exec(string);
            jRunPumpStreamHandler.setProcessOutputStream(process.getInputStream());
            jRunPumpStreamHandler.setProcessErrorStream(process.getErrorStream());
            jRunPumpStreamHandler.start();
            try {
                process.waitFor();
                n = process.exitValue();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            CIUtil.logError(RB.getString(CIUtil.class, "CIUtil.ExecIOException", (Object)string, (Object)iOException.getMessage()), iOException);
        }
        if (n != 0) {
            CIUtil.logError(RB.getString(CIUtil.class, "CIUtil.ExecError", (Object)string, (Object)String.valueOf(n)));
        }
        return n;
    }

    public static int exec(String string) {
        return CIUtil.exec(string, true);
    }

    static {
        jarFile = "wsconfig.jar";
        isRunningDebugger = false;
        logToStderr = false;
        CIUtil.getJarDir();
    }
}

