/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.ApacheWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.CIConstants;
import com.adobe.coldfusion.connector.connectorinstaller.CIJndi;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConfigParser;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IISWebSites;
import com.adobe.coldfusion.connector.connectorinstaller.NoServerException;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WSVersionNotSupportedException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebSite;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.connectorinstaller.gui.ConfigFrame;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import javax.naming.AuthenticationException;

public class ConnectorInstaller {
    private static final String INTERFACE_GUI = "gui";
    private static final String INTERFACE_CMDLINE = "cmdline";
    public static final int NORMAL_EXIT = 0;
    public static final int FATAL_ERROR_EXIT = 1;
    public static final int NO_SERVER_ERROR_EXIT = 2;
    public static final int BAD_WS_VERSION_EXIT = 3;
    private static final String clusterFile = "cluster.xml";
    private static final String instanceFile = "instances.xml";
    public static final boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    private Properties args;
    private WebServerInfo wsInfo;
    private CIJndi jrunInfo;
    private boolean isRemove;
    private boolean isListConfigurations;
    private boolean isListServers;
    private boolean isUninstall;
    private boolean isUpgrade;
    private boolean doRestart;
    private boolean isCF;
    private boolean isIISSiteAllIndividually = false;
    private boolean isApacheSiteAllIndividually = false;

    public ConnectorInstaller(Properties properties) throws Exception, ConnectorInstallerException {
        this.parseArgs(properties);
    }

    public ConnectorInstaller(Properties properties, String string) throws FileNotFoundException, IOException, ConnectorInstallerException, Exception {
        Properties properties2 = new Properties(properties);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        properties2.load(fileInputStream);
        fileInputStream.close();
        this.parseArgs(properties2);
    }

    private void parseArgs(Properties properties) throws ConnectorInstallerException, Exception {
        ConfigParser configParser;
        Map<String, Map<String, Object>> map;
        Set<String> set;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        WebServerInfo webServerInfo = new WebServerInfo();
        if (webServerInfo.isSupportedWebServer("IIS")) {
            try {
                new Win32Handler();
            }
            catch (Exception exception) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "CIError.AnotherInstanceRunning"));
            }
        }
        this.args = properties;
        this.isRemove = Boolean.valueOf(properties.getProperty("remove"));
        this.isUninstall = Boolean.valueOf(properties.getProperty("uninstall"));
        this.isUpgrade = Boolean.valueOf(properties.getProperty("upgrade"));
        this.isListConfigurations = Boolean.valueOf(properties.getProperty("list"));
        this.doRestart = Boolean.valueOf(properties.getProperty("restart"));
        this.isCF = true;
        if (properties.getProperty("refresh") != null) {
            Object[] objectArray;
            String string6 = properties.getProperty("refresh");
            PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
            while ((objectArray = propertyFileEditor.nextFullEntry()) != null) {
                WebServerInfo webServerInfo2 = (WebServerInfo)objectArray[0];
                webServerInfo2.setHostname((String)objectArray[1]);
                if (!webServerInfo2.getClustername().equals(string6)) continue;
                this.wsInfo = webServerInfo2;
                this.wsInfo.setRefresh(true);
                String string7 = CIUtil.getJRunDir();
                String string8 = new File(string7).getParent();
                String string9 = string8 + File.separator + clusterFile;
                if (!new File(string9).exists()) break;
                ConfigParser configParser2 = new ConfigParser(string9);
                Map<String, Map<String, Object>> map2 = configParser2.doClusterList();
                if (map2.size() == 0) {
                    this.isRemove = true;
                    break;
                }
                Map<String, Object> map3 = map2.get(string6);
                ArrayList arrayList = (ArrayList)map3.get("serverlist");
                if (arrayList != null && arrayList.size() > 0) {
                    this.wsInfo.setClusterMap(map2);
                    break;
                }
                this.isRemove = true;
                break;
            }
            return;
        }
        CIUtil.setDebugEnabled(Boolean.valueOf(properties.getProperty("debug")));
        boolean bl = false;
        String string10 = properties.getProperty("ws");
        String string11 = properties.getProperty("dir");
        if (string11.length() == 0 && (string11 = properties.getProperty("site")).length() > 0) {
            bl = true;
        }
        if ((string5 = properties.getProperty("host")).length() == 0) {
            string5 = "localhost";
        }
        if (this.isRemove) {
            if (this.isListConfigurations) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"remove", (Object)"list"));
            }
            if (this.isUninstall) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"remove", (Object)"uninstall"));
            }
            if (this.isUpgrade) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"remove", (Object)"upgrade"));
            }
        }
        if (this.isUpgrade) {
            if (this.isListConfigurations) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"upgrade", (Object)"list"));
            }
            if (this.isUninstall) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"upgrade", (Object)"uninstall"));
            }
            if (this.isRemove) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"upgrade", (Object)"remove"));
            }
        }
        if (this.isUninstall) {
            if (this.isListConfigurations) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"uninstall", (Object)"list"));
            }
            if (this.isUpgrade) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"uninstall", (Object)"upgrade"));
            }
            if (string10.length() > 0) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"uninstall", (Object)"ws"));
            }
            if (string11.length() > 0) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"uninstall", (Object)(bl ? "site" : "dir")));
            }
            return;
        }
        if (this.isListConfigurations || this.isUpgrade && string10.length() == 0 && string11.length() == 0) {
            return;
        }
        if (bl && string11.equals(RB.getString(this, "CI.IISAllIndividulyGuiTag"))) {
            this.isIISSiteAllIndividually = true;
            string11 = null;
        }
        if (!properties.getProperty("instance").isEmpty() && !properties.getProperty("cluster").isEmpty()) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.Bad2Args", (Object)"instance", (Object)"cluster"));
        }
        this.wsInfo = new WebServerInfo(string10, string11);
        if (this.wsInfo.getWebServer().equals("Apache") && !this.isUpgrade) {
            if (properties.getProperty("vhost").length() == 0) {
                throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstaller.NoApacheVHostSite"));
            }
            if (properties.getProperty("vhost").equalsIgnoreCase(RB.getString(this, "CI.ApacheAllIndividuallyGuiTag"))) {
                this.isApacheSiteAllIndividually = true;
            }
        }
        if (!(string4 = properties.getProperty("instance")).isEmpty()) {
            boolean bl2 = false;
            String string12 = "";
            try {
                string3 = CIUtil.getJRunDir();
                string2 = new File(string3).getParent();
                string = string2 + File.separator + instanceFile;
                if (new File(string).exists() && (set = (map = (configParser = new ConfigParser(string)).doServerList()).keySet()).contains(string4)) {
                    Map<String, Object> map4 = map.get(string4);
                    String string13 = (String)map4.get("remote");
                    if (!Boolean.parseBoolean(string13)) {
                        bl2 = true;
                    } else {
                        string12 = "Local";
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.wsInfo.setInstancename(string4);
        }
        if (properties.getProperty("cfscripts") == null) {
            String string14 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "cf_scripts";
            this.wsInfo.setCfscriptsPath(string14);
        } else {
            this.wsInfo.setCfscriptsPath(properties.getProperty("cfscripts"));
        }
        if (!this.isRemove && !this.isUpgrade) {
            this.wsInfo.setUseIISFilter(true);
            String string15 = properties.getProperty("cluster").trim();
            if (string15.length() > 0) {
                boolean bl3 = false;
                string3 = CIUtil.getJRunDir();
                string2 = new File(string3).getParent();
                string = string2 + File.separator + clusterFile;
                if (new File(string).exists()) {
                    configParser = new ConfigParser(string);
                    map = configParser.doClusterList();
                    set = map.keySet();
                    for (String string13 : set) {
                        if (!string13.equalsIgnoreCase(string15)) continue;
                        bl3 = true;
                        Map<String, Object> map5 = map.get(string15);
                        ArrayList arrayList = (ArrayList)map5.get("serverlist");
                        if (arrayList != null && arrayList.size() != 0) continue;
                        throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.InvalidCluster", (Object)string15));
                    }
                    this.wsInfo.setClusterMap(map);
                    this.wsInfo.setClustername(string15);
                }
                if (!bl3) {
                    throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadClusterName", (Object)string15));
                }
            }
            this.wsInfo.setHostname(string5);
        }
        String string16 = this.wsInfo.getClustername().equals("") ? this.wsInfo.getInstancename() : this.wsInfo.getClustername();
        this.jrunInfo = new CIJndi(string5, string16);
        this.wsInfo.setApialloc(Boolean.valueOf(properties.getProperty("apialloc")));
        this.wsInfo.setWS32(Boolean.valueOf(properties.getProperty("ws32")));
        String string17 = null;
        try {
            string17 = (String)properties.get("connectionPoolTimeout");
            if (string17 != null) {
                this.wsInfo.setConnectionTimeout(Integer.parseInt(string17));
            }
            if ((string17 = (String)properties.get("connectionPoolSize")) != null) {
                this.wsInfo.setConnectionPoolSize(Integer.parseInt(string17));
            }
            if ((string17 = (String)properties.get("reuseConnectionCount")) != null) {
                this.wsInfo.setResueCount(Integer.parseInt(string17));
            }
            if ((string17 = (String)properties.get("verboseLogging")) != null) {
                this.wsInfo.setVerboseLogging(Boolean.parseBoolean(string17));
            }
            if ((string17 = (String)properties.get("enableBuffering")) != null) {
                this.wsInfo.setEnableBuffer(Boolean.parseBoolean(string17));
            }
            if ((string17 = (String)properties.get("skipIISCustomErrors")) != null) {
                this.wsInfo.setSetSkipCustomErros(Boolean.parseBoolean(string17));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.WrongValueErr", (Object)string17));
        }
        string17 = properties.getProperty("isWebServiceON");
        if (string17 != null && !this.wsInfo.getPlatform().equals("intel-macosx64")) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.ErrorArgForWS", (Object)"isWebServiceON"));
        }
        if (string17 != null) {
            this.wsInfo.setWebServiceON(Boolean.valueOf(string17));
        }
        if ((string17 = (String)properties.get("allowedIPList")) != null) {
            this.wsInfo.setAllowedIPs(string17);
        }
        this.setBinFile(properties.getProperty("bin"));
        this.setApacheApxs(Boolean.valueOf(properties.getProperty("apxs")));
        this.setApacheServiceName(properties.getProperty("service"));
        this.setApacheScriptFile(properties.getProperty("script"));
        this.setApacheVHost(properties.getProperty("vhost"));
    }

    private void doIt() throws Exception {
        if (this.isRemove) {
            this.removeConnector();
        } else if (this.isUninstall) {
            this.removeAll();
        } else if (this.isUpgrade) {
            if (this.wsInfo == null) {
                this.upgradeAll();
            } else {
                this.upgradeConnector();
            }
        } else if (this.isListConfigurations) {
            this.listConfigurations();
        } else {
            this.installConnector();
        }
    }

    private void setApacheServiceName(String string) throws ConnectorInstallerException {
        if (string.length() > 0) {
            if (this.wsInfo.getWebServer().equals("Apache") && File.separatorChar == '\\') {
                this.wsInfo.setApacheNTServiceName(string);
            } else {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadArgForWS", (Object)"-service", (Object)this.wsInfo.getWebServer()));
            }
        }
    }

    private void setBinFile(String string) throws ConnectorInstallerException {
        if (string.length() > 0) {
            if (this.wsInfo.getWebServer().equals("Apache")) {
                this.wsInfo.setApacheBinPath(string);
            } else if (this.wsInfo.getWebServer().equals("Nginx")) {
                this.wsInfo.setNginxBinPath(string);
            } else {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadArgForWS", (Object)"-bin", (Object)this.wsInfo.getWebServer()));
            }
        }
    }

    private void setApacheScriptFile(String string) throws ConnectorInstallerException {
        if (string.length() > 0) {
            if (this.wsInfo.getWebServer().equals("Apache") && File.separatorChar == '/') {
                this.wsInfo.setApacheScriptPath(string);
            } else {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadArgForWS", (Object)"-script", (Object)this.wsInfo.getWebServer()));
            }
        }
    }

    private void setApacheVHost(String string) throws ConnectorInstallerException {
        if (string.length() > 0) {
            if (this.wsInfo.getWebServer().equals("Apache")) {
                this.wsInfo.setApacheVirtualHost(string);
            } else {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadArgForWS", (Object)"-vhost", (Object)this.wsInfo.getWebServer()));
            }
        }
    }

    private void setApacheApxs(boolean bl) throws ConnectorInstallerException {
        if (this.wsInfo.getWebServer().equals("Apache") && File.separatorChar == '/') {
            this.wsInfo.setApacheApxs(bl);
        } else if (bl) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.BadArgForWS", (Object)"-apxs", (Object)this.wsInfo.getWebServer()));
        }
    }

    private void installConnector() throws Exception {
        if (this.isIISSiteAllIndividually) {
            this.installAllIISConnectorsIndividually();
        } else if (this.isApacheSiteAllIndividually) {
            this.installAllApacheConnectorsIndividually();
        } else {
            WebServerInstaller webServerInstaller = WebServerInstaller.createObject(this.wsInfo, this.jrunInfo);
            if (!this.doRestart) {
                webServerInstaller.installConnector(false);
            } else if (this.wsInfo.isColdFusion()) {
                webServerInstaller.installConnector(true);
            } else {
                try {
                    webServerInstaller.installConnector();
                }
                catch (WebServerException webServerException) {
                    CIUtil.logInfo(webServerException.getLocalizedMessage());
                }
            }
            if (webServerInstaller.restartRequired) {
                System.err.println(RB.getString(ConnectorInstaller.class, "CISuccess.RestartRequired"));
            }
            if (!this.wsInfo.isRefresh()) {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Install", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            } else {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Refresh", (Object)this.wsInfo.getClustername()));
            }
        }
    }

    private String getApacheScriptPath() {
        if (this.wsInfo.getApacheScriptPath().length() > 0) {
            String string = CIUtil.quotePath(this.wsInfo.getApacheScriptPath());
            return string;
        }
        File file = null;
        String[] stringArray = new String[]{"bin/apachectl", "/usr/sbin/apache2ctl", "/usr/sbin/apachectl", "/etc/init.d/httpd", "/etc/init.d/apache", "/etc/rc.d/init.d/httpd", "/etc/rc.d/init.d/apache", "/sbin/init.d/apache", "/sbin/init.d/httpd", "/usr/local/apache/bin/apachectl", "/usr/apache/bin/apachectl", "/etc/init.d/apache2", "bin/strongholdctl", "/usr/local/stronghold/bin/strongholdctl"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == File.separatorChar) {
                file = new File(stringArray[i]);
            } else {
                File file2 = new File(this.wsInfo.getWebServerDir()).getParentFile();
                file = new File(file2, stringArray[i]);
            }
            if (!file.isFile()) continue;
            String string = file.getPath();
            return string;
        }
        return null;
    }

    private void installAllApacheConnectorsIndividually() throws Exception {
        Object object;
        String string;
        Object object2;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        if (isWindows) {
            ApacheWebSites.populateWebSites(this.wsInfo.getApacheBinPath(), this.wsInfo.getWebServerDir());
        } else {
            object2 = this.wsInfo.getApacheScriptPath().length() > 0 ? this.wsInfo.getApacheScriptPath() : this.getApacheScriptPath();
            ApacheWebSites.populateWebSites((String)object2, this.wsInfo.getWebServerDir());
        }
        ApacheWebSites.setConfiguredWebSites(this.wsInfo);
        object2 = ApacheWebSites.getWebSites();
        Map map = ApacheWebSites.getConfiguredSites();
        if (object2 == null) {
            return;
        }
        ListIterator listIterator = ((ArrayList)object2).listIterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (listIterator.hasNext()) {
            WebSite webSite = (WebSite)listIterator.next();
            if (map.containsKey(webSite.getSiteName())) {
                string = FileUtils.normalizeSeparator(webSite.getConfLocation());
                object = FileUtils.normalizeSeparator((String)map.get(webSite.getSiteName()));
                if (new File(string).getParent().equals(new File((String)object).getPath())) continue;
                arrayList.add(webSite.getSiteName());
                continue;
            }
            arrayList.add(webSite.getSiteName());
        }
        if (arrayList.contains(RB.getString(CIUtil.class, "CI.ApacheAllIndividuallyGuiTag"))) {
            arrayList.remove(RB.getString(CIUtil.class, "CI.ApacheAllIndividuallyGuiTag"));
        }
        if (arrayList.contains(RB.getString(CIUtil.class, "CI.ApacheAllSitesGuiTag"))) {
            arrayList.remove(RB.getString(CIUtil.class, "CI.ApacheAllSitesGuiTag"));
        }
        if (arrayList.size() == 0) {
            System.out.println(RB.getString(ConnectorInstaller.class, "CI.ApacheWebServerUnconfigurable"));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            this.wsInfo.setApacheVirtualHost(string);
            this.wsInfo.setAppServerWebServerDir(null);
            object = WebServerInstaller.createObject(this.wsInfo, this.jrunInfo);
            ((WebServerInstaller)object).installConnector(false);
            if (!this.wsInfo.isRefresh()) {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Install", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            } else {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Refresh", (Object)this.wsInfo.getClustername()));
            }
            if (!this.doRestart || i != arrayList.size() - 1) continue;
            ((WebServerInstaller)object).restartWS();
        }
    }

    private void installAllIISConnectorsIndividually() throws Exception {
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        IISWebSites iISWebSites = new IISWebSites(propertyFileEditor, false);
        ArrayList arrayList = iISWebSites.getConfigurable();
        boolean bl = this.wsInfo.isColdFusion();
        for (int i = 0; i < arrayList.size(); ++i) {
            WebSite webSite = (WebSite)arrayList.get(i);
            this.wsInfo.setWebServerDirectory(webSite.getSiteName());
            this.wsInfo.setAppServerWebServerDir(null);
            WebServerInstaller webServerInstaller = WebServerInstaller.createObject(this.wsInfo, this.jrunInfo);
            webServerInstaller.installConnector(false);
            if (!this.wsInfo.isRefresh()) {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Install", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            } else {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Refresh", (Object)this.wsInfo.getClustername()));
            }
            if (!this.doRestart || i != arrayList.size() - 1) continue;
            webServerInstaller.restartWS();
        }
    }

    private void removeConnector() throws Exception {
        WebServerInstaller webServerInstaller = WebServerInstaller.createObject(this.wsInfo);
        if (!this.doRestart) {
            webServerInstaller.removeConnector(false);
        } else if (this.isCF || this.wsInfo.isColdFusion()) {
            webServerInstaller.removeConnector(true);
        } else {
            try {
                webServerInstaller.removeConnector();
            }
            catch (WebServerException webServerException) {
                CIUtil.logInfo(webServerException.getLocalizedMessage());
            }
        }
        if (webServerInstaller.restartRequired) {
            System.err.println(RB.getString(ConnectorInstaller.class, "CISuccess.RestartRequired"));
        }
        System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Remove", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
    }

    private void removeAll() throws Exception {
        int n = 0;
        int n2 = 0;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        while ((this.wsInfo = propertyFileEditor.nextEntry()) != null) {
            try {
                this.removeConnector();
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : exception.toString());
                ++n2;
            }
            ++n;
        }
        if (n == 0) {
            System.err.println(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.NoConfigurations"));
        } else if (n2 > 0) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "CIError.RemoveAll"));
        }
    }

    private void upgradeConnector() throws Exception {
        boolean bl = false;
        WebServerInstaller webServerInstaller = WebServerInstaller.createObject(this.wsInfo);
        try {
            bl = !this.doRestart ? webServerInstaller.upgradeConnector(false) : (this.isCF || this.wsInfo.isColdFusion() ? webServerInstaller.upgradeConnector(true) : webServerInstaller.upgradeConnector());
            if (webServerInstaller.restartRequired) {
                System.err.println(RB.getString(ConnectorInstaller.class, "CISuccess.RestartRequired"));
            }
            if (bl) {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.Upgrade", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            } else {
                System.out.println(RB.getString(ConnectorInstaller.class, "CISuccess.NoUpgrade", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            }
        }
        catch (Exception exception) {
            System.err.println(RB.getString(ConnectorInstaller.class, "CIError.NoUpgrade", (Object)this.wsInfo.getWebServerDisplay(), (Object)this.wsInfo.formatWebServerDir()));
            throw exception;
        }
    }

    private void upgradeAll() throws Exception {
        int n = 0;
        int n2 = 0;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        while ((this.wsInfo = propertyFileEditor.nextEntry()) != null) {
            try {
                this.upgradeConnector();
            }
            catch (Exception exception) {
                System.err.println(exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : exception.toString());
                ++n2;
            }
            ++n;
        }
        if (n == 0) {
            System.err.println(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.NoConfigurations"));
        } else if (n2 > 0) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "CIError.Upgrade"));
        }
    }

    private void listConfigurations() throws Exception {
        Object[] objectArray;
        PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
        int n = 0;
        boolean bl = false;
        String string = this.args.getProperty("ws");
        String string2 = null;
        String string3 = null;
        while ((objectArray = propertyFileEditor.nextFullEntry()) != null) {
            this.wsInfo = (WebServerInfo)objectArray[0];
            string2 = (String)objectArray[1];
            string3 = (String)objectArray[2];
            if (string != "" && !this.wsInfo.getWebServer().equalsIgnoreCase(string)) continue;
            if (this.wsInfo.getWebServer().equals("IIS")) {
                if (bl) continue;
                bl = true;
                this.listIISWebSites();
            } else {
                String string4 = CIUtil.quotePath(new File(this.wsInfo.getWebServerDir()).getCanonicalPath());
                string4 = string4 + " (" + this.wsInfo.getApacheVirtualHost() + ")";
                System.out.println(this.wsInfo.getWebServerDisplay() + " : " + string4);
            }
            ++n;
        }
        if (n == 0) {
            System.err.println(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.NoConfigurations"));
        }
    }

    public void listIISWebSites() {
        try {
            StringBuffer stringBuffer;
            WebSite webSite;
            ListIterator listIterator;
            String string = RB.getString(this, "CI.IISAllSitesGuiTag");
            PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
            IISWebSites iISWebSites = new IISWebSites(propertyFileEditor, true);
            ArrayList arrayList = iISWebSites.getConfigured();
            ArrayList arrayList2 = iISWebSites.getUnconfigured();
            System.out.println(this.wsInfo.getWebServerDisplay() + " : ");
            System.out.println(RB.getString((Object)this, "CI.IISList", (Object)Integer.toString(arrayList.size()), (Object)Integer.toString(arrayList2.size())));
            if (arrayList.size() > 0) {
                System.out.println(RB.getString(this, "CI.IISConfiguredSites"));
                listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    webSite = (WebSite)listIterator.next();
                    stringBuffer = new StringBuffer(webSite.getMetabaseKey());
                    stringBuffer.append("               ");
                    System.out.print(RB.getString((Object)this, "CI.IISWebSiteDisplay", (Object)stringBuffer.substring(0, 15), (Object)webSite.getSiteName()));
                    if (!webSite.isGlobalSite() && iISWebSites.isConfiguredUnderGlobal(webSite)) {
                        System.out.println(" (" + string + ")");
                        continue;
                    }
                    System.out.println("");
                }
            }
            if (arrayList2.size() > 0) {
                System.out.println(RB.getString(this, "CI.IISUnconfiguredSites"));
                listIterator = arrayList2.listIterator();
                while (listIterator.hasNext()) {
                    webSite = (WebSite)listIterator.next();
                    stringBuffer = new StringBuffer(webSite.getMetabaseKey());
                    stringBuffer.append("               ");
                    System.out.println(RB.getString((Object)this, "CI.IISWebSiteDisplay", (Object)stringBuffer.substring(0, 15), (Object)webSite.getSiteName()));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(CIConstants.UNKNOWN_VALUE);
        }
    }

    public static void refreshClusterSettings(String string) throws Exception, ConnectorInstallerException {
        Properties properties = ConnectorInstaller.getDefaults();
        properties.setProperty("refresh", string);
        ConnectorInstaller connectorInstaller = new ConnectorInstaller(properties);
        if (connectorInstaller.wsInfo != null) {
            connectorInstaller.doIt();
        }
    }

    static String getInfo() {
        return "Tomcat Connector";
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        Properties properties = ConnectorInstaller.getDefaults();
        int n = 0;
        while (n < stringArray.length && (stringArray[n].startsWith("-") || stringArray[n].startsWith("/"))) {
            String string3;
            if ((string3 = stringArray[n++].substring(1)).equals("i")) {
                if (n < stringArray.length && stringArray[n].equalsIgnoreCase(INTERFACE_GUI)) {
                    string = stringArray[n++];
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadInterface", string3);
                continue;
            }
            if (string3.equals("f")) {
                if (n < stringArray.length) {
                    string2 = stringArray[n++];
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadPropertyFile", string3);
                continue;
            }
            if (string3.equals("ws")) {
                if (n < stringArray.length) {
                    properties.setProperty("ws", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadWS", string3);
                continue;
            }
            if (string3.equals("dir") || string3.equals("site")) {
                if (n < stringArray.length) {
                    properties.setProperty(string3, stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadConfigDir", string3);
                continue;
            }
            if (string3.equals("host")) {
                if (n < stringArray.length) {
                    properties.setProperty("host", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadHost", string3);
                continue;
            }
            if (string3.equals("vhost")) {
                if (n < stringArray.length) {
                    properties.setProperty("vhost", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadVHost", string3);
                continue;
            }
            if (string3.equals("cluster")) {
                if (n < stringArray.length) {
                    properties.setProperty("cluster", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadCluster", string3);
                continue;
            }
            if (string3.equals("instance")) {
                if (n < stringArray.length) {
                    properties.setProperty("instance", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadInstance", string3);
                continue;
            }
            if (string3.equals("cfscripts")) {
                if (n < stringArray.length) {
                    properties.setProperty("cfscripts", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadCfscripts", string3);
                continue;
            }
            if (string3.equals("service")) {
                if (n < stringArray.length) {
                    properties.setProperty("service", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadServiceName", string3);
                continue;
            }
            if (string3.equals("bin")) {
                if (n < stringArray.length) {
                    properties.setProperty("bin", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadBinFile", string3);
                continue;
            }
            if (string3.equals("script")) {
                if (n < stringArray.length) {
                    properties.setProperty("script", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadScriptFile", string3);
                continue;
            }
            if (string3.equals("refresh")) {
                if (n < stringArray.length) {
                    properties.setProperty("refresh", stringArray[n++]);
                    continue;
                }
                ConnectorInstaller.printErrorAndExit("ConnectorInstaller.BadCluster", string3);
                continue;
            }
            if (string3.equals("norestart")) {
                properties.setProperty("restart", "false");
                continue;
            }
            if (string3.equals("list")) {
                properties.setProperty("list", "true");
                continue;
            }
            if (string3.equals("remove")) {
                properties.setProperty("remove", "true");
                continue;
            }
            if (string3.equals("uninstall")) {
                properties.setProperty("uninstall", "true");
                continue;
            }
            if (string3.equals("upgrade")) {
                properties.setProperty("upgrade", "true");
                continue;
            }
            if (string3.equals("ws32")) {
                properties.setProperty("ws32", "true");
                continue;
            }
            if (string3.equalsIgnoreCase("reuseConnectionCount")) {
                if (n >= stringArray.length) continue;
                properties.setProperty("reuseConnectionCount", stringArray[n++]);
                continue;
            }
            if (string3.equalsIgnoreCase("connectionPoolTimeout")) {
                if (n >= stringArray.length) continue;
                properties.setProperty("connectionPoolTimeout", stringArray[n++]);
                continue;
            }
            if (string3.equalsIgnoreCase("connectionPoolSize")) {
                if (n >= stringArray.length) continue;
                properties.setProperty("connectionPoolSize", stringArray[n++]);
                continue;
            }
            if (string3.equalsIgnoreCase("verboseLogging")) {
                properties.setProperty("verboseLogging", "true");
                continue;
            }
            if (string3.equalsIgnoreCase("enableBuffering")) {
                properties.setProperty("enableBuffering", "true");
                continue;
            }
            if (string3.equalsIgnoreCase("skipIISCustomErrors")) {
                properties.setProperty("skipIISCustomErrors", "true");
                continue;
            }
            if (string3.equalsIgnoreCase("allowedIPList")) {
                if (n >= stringArray.length) continue;
                properties.setProperty("allowedIPList", stringArray[n++]);
                continue;
            }
            if (string3.equalsIgnoreCase("isWebServiceON")) {
                if (n >= stringArray.length) continue;
                properties.setProperty("isWebServiceON", stringArray[n++]);
                continue;
            }
            block8: for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                switch (c) {
                    case 'r': {
                        properties.setProperty("remove", "true");
                        continue block8;
                    }
                    case 'u': {
                        properties.setProperty("uninstall", "true");
                        continue block8;
                    }
                    case 'v': {
                        properties.setProperty("debug", "true");
                        continue block8;
                    }
                    default: {
                        ConnectorInstaller.usage();
                    }
                }
            }
        }
        if (n < stringArray.length) {
            ConnectorInstaller.usage();
        }
        if (properties.getProperty("ws").equalsIgnoreCase("apache") && properties.getProperty("vhost").length() == 0) {
            properties.setProperty("vhost", "All");
        }
        if (string.length() == 0) {
            string = stringArray.length > 0 ? INTERFACE_CMDLINE : INTERFACE_GUI;
        }
        boolean bl = string.equals(INTERFACE_CMDLINE) || Trace.ci;
        CIUtil.createLogger(bl, ConnectorInstaller.getInfo());
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n] + " ");
        }
        try {
            if (string.equals(INTERFACE_GUI)) {
                ConfigFrame.run();
                return;
            }
            ConnectorInstaller connectorInstaller = string2.length() > 0 ? new ConnectorInstaller(properties, string2) : new ConnectorInstaller(properties);
            CIUtil.logDebug("command line: " + stringBuffer);
            connectorInstaller.doIt();
            CIUtil.exit(0);
        }
        catch (Exception exception) {
            ConnectorInstallerException connectorInstallerException;
            int n2 = 1;
            if (exception instanceof AuthenticationException) {
                connectorInstallerException = new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "CIError.Authentication"));
            } else if (exception instanceof NoServerException) {
                n2 = 2;
            } else if (exception instanceof WSVersionNotSupportedException) {
                n2 = 3;
            }
            CIUtil.logError(connectorInstallerException.getLocalizedMessage() != null ? connectorInstallerException.getLocalizedMessage() : connectorInstallerException.toString(), connectorInstallerException);
            CIUtil.exit(n2);
        }
    }

    private static void printErrorAndExit(String string, String string2) {
        System.err.println(RB.getString(ConnectorInstaller.class, string, (Object)string2));
        System.exit(1);
    }

    private static void usage() {
        String string = "CI.Usage";
        boolean bl = false;
        int n = 1;
        while (!bl) {
            try {
                System.out.println(RB.getString(ConnectorInstaller.class, string + n, (Object)CIUtil.getJarFilename()));
            }
            catch (MissingResourceException missingResourceException) {
                bl = true;
            }
            ++n;
        }
        System.exit(1);
    }

    static Properties getDefaults() {
        Properties properties = new Properties();
        properties.setProperty("ws", "");
        properties.setProperty("dir", "");
        properties.setProperty("site", "");
        properties.setProperty("host", "localhost");
        properties.setProperty("cluster", "");
        properties.setProperty("service", "");
        properties.setProperty("bin", "");
        properties.setProperty("script", "");
        properties.setProperty("vhost", "");
        properties.setProperty("verbose", "false");
        properties.setProperty("restart", "true");
        properties.setProperty("coldfusion", "true");
        properties.setProperty("instance", "");
        properties.setProperty("debug", "false");
        properties.setProperty("remove", "false");
        properties.setProperty("list", "false");
        properties.setProperty("uninstall", "false");
        properties.setProperty("upgrade", "false");
        return properties;
    }
}

