/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIJndi;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public final class PropertyFileEditor {
    Enumeration enumNames;
    OrderedProperties p = new OrderedProperties();
    String currentKey;

    public PropertyFileEditor() throws IOException, ConnectorInstallerException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getPropertyFile());
            this.p.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.resetEnumerator();
    }

    public void writePropertyFile() throws IOException {
        this.p.clearComments();
        FileOutputStream fileOutputStream = new FileOutputStream(this.getPropertyFile());
        this.p.store(fileOutputStream, "ColdFusion Web Server Configuration File");
        fileOutputStream.close();
        CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.getPropertyFile()));
    }

    public void resetEnumerator() {
        this.currentKey = null;
        this.enumNames = this.p.propertyNames();
    }

    public Object[] nextFullEntry() {
        String string;
        String string2;
        WebServerInfo webServerInfo = this.nextEntry();
        if (webServerInfo == null) {
            return null;
        }
        String string3 = "";
        String string4 = "";
        if (this.currentKey != null && !this.currentKey.endsWith(".srv") && (string2 = this.p.getProperty(string = this.currentKey + ".srv")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.hasMoreTokens()) {
                string3 = CIUtil.unquoteString(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = CIUtil.unquoteString(stringTokenizer.nextToken());
            }
        }
        return new Object[]{webServerInfo, string3, string4};
    }

    public WebServerInfo nextEntry() {
        String string;
        String string2;
        do {
            if (!this.enumNames.hasMoreElements()) {
                return null;
            }
            this.currentKey = (String)this.enumNames.nextElement();
        } while (this.currentKey.indexOf(46) != -1 || (string2 = this.p.getProperty(this.currentKey)) == null);
        WebServerInfo webServerInfo = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() >= 2) {
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            try {
                webServerInfo = new WebServerInfo(string3, string4);
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                this.removeEntry(this.currentKey);
                return this.nextEntry();
            }
            if (string3.equalsIgnoreCase("IIS")) {
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setUseIISFilter(new Boolean((String)stringTokenizer.nextElement()));
                }
                if (stringTokenizer.countTokens() == 3) {
                    if (stringTokenizer.hasMoreTokens()) {
                        webServerInfo.setInstancename(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        webServerInfo.setClustername(stringTokenizer.nextToken());
                    }
                }
            } else if (string3.equalsIgnoreCase("Apache")) {
                try {
                    if (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).length() > 0) {
                        webServerInfo.setApacheVirtualHost(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).length() > 0) {
                        webServerInfo.setApacheNTServiceName(string);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (stringTokenizer.hasMoreTokens()) {
                        webServerInfo.setApacheBinPath(stringTokenizer.nextToken());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (stringTokenizer.hasMoreTokens()) {
                        webServerInfo.setApacheScriptPath(stringTokenizer.nextToken());
                    }
                }
                catch (ConnectorInstallerException connectorInstallerException) {
                    // empty catch block
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setApacheApxs(Boolean.valueOf(stringTokenizer.nextToken()));
                } else {
                    webServerInfo.setApacheApxs(false);
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setInstancename(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setClustername(stringTokenizer.nextToken());
                }
            } else if (string3.equalsIgnoreCase("SunJWS")) {
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setInstancename(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setClustername(stringTokenizer.nextToken());
                }
            } else if (string3.equalsIgnoreCase("Nginx")) {
                try {
                    if (stringTokenizer.hasMoreTokens()) {
                        webServerInfo.setNginxBinPath(stringTokenizer.nextToken());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setInstancename(stringTokenizer.nextToken());
                }
                if (stringTokenizer.hasMoreTokens()) {
                    webServerInfo.setClustername(stringTokenizer.nextToken());
                }
            }
        } else {
            this.removeEntry(this.currentKey);
            return this.nextEntry();
        }
        webServerInfo.setAppServerWebServerDir(new File(CIUtil.getJRunDir(), this.currentKey));
        string = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + webServerInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "cf_scripts";
        webServerInfo.setCfscriptsPath(string);
        if (stringTokenizer.hasMoreTokens()) {
            webServerInfo.setBitnessValue(stringTokenizer.nextToken());
        }
        return webServerInfo;
    }

    public void updateEntry(String string, WebServerInfo webServerInfo, CIJndi cIJndi) throws ConnectorInstallerException {
        String string2 = null;
        string2 = webServerInfo.getWebServer() + "," + webServerInfo.getWebServerDir();
        if (webServerInfo.getWebServer().equals("IIS")) {
            string2 = string2 + "," + String.valueOf(webServerInfo.getUseIISFilter());
        } else if (webServerInfo.getWebServer().equals("Apache")) {
            string2 = string2 + "," + (webServerInfo.getApacheVirtualHost().length() > 0 ? webServerInfo.getApacheVirtualHost() : "\"\"") + "," + (webServerInfo.getApacheNTServiceName().length() > 0 ? webServerInfo.getApacheNTServiceName() : "\"\"") + "," + (webServerInfo.getApacheBinPath().length() > 0 ? webServerInfo.getApacheBinPath() : "\"\"") + "," + (webServerInfo.getApacheScriptPath().length() > 0 ? webServerInfo.getApacheScriptPath() : "\"\"") + "," + webServerInfo.getApacheApxs();
        } else if (webServerInfo.getWebServer().equals("Nginx")) {
            string2 = string2 + "," + (webServerInfo.getNginxBinPath().length() > 0 ? webServerInfo.getNginxBinPath() : "\"\"");
        }
        string2 = string2 + ",";
        string2 = string2 + webServerInfo.getInstancename();
        string2 = string2 + ",";
        string2 = string2 + (webServerInfo.getClustername().length() > 0 ? webServerInfo.getClustername() : "\"\"");
        string2 = string2 + "," + webServerInfo.getBitnessValue();
        this.p.setProperty(string, string2);
        string2 = cIJndi.getHost() + "," + cIJndi.getServername();
        this.p.setProperty(string + ".srv", string2);
    }

    public void removeEntry(String string) {
        this.p.remove(string);
        this.p.remove(string + ".srv");
    }

    public WebServerInfo findEntry(String string) {
        WebServerInfo webServerInfo;
        this.resetEnumerator();
        while ((webServerInfo = this.nextEntry()) != null) {
            if (!webServerInfo.getWebServer().equalsIgnoreCase(string)) continue;
            return webServerInfo;
        }
        return null;
    }

    public List<String> getListOfWorkers(String string) {
        WebServerInfo webServerInfo;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.resetEnumerator();
        while ((webServerInfo = this.nextEntry()) != null) {
            if (!webServerInfo.getWebServer().equalsIgnoreCase(string)) continue;
            arrayList.add(webServerInfo.getClustername().equals("") ? webServerInfo.getInstancename() : webServerInfo.getClustername());
        }
        return arrayList;
    }

    public WebServerInfo findEntry(WebServerInfo webServerInfo) {
        return this.findEntry(webServerInfo.getWebServer(), webServerInfo.getWebServerDir(), webServerInfo.getApacheVirtualHost());
    }

    public WebServerInfo findEntry(String string, String string2) {
        return this.findEntry(string, string2, "");
    }

    public WebServerInfo findEntry(String string, String string2, String string3) {
        WebServerInfo webServerInfo;
        this.resetEnumerator();
        while ((webServerInfo = this.nextEntry()) != null) {
            if (!webServerInfo.getWebServer().equalsIgnoreCase(string)) continue;
            String string4 = FileUtils.normalizeSeparator(webServerInfo.getWebServerDir());
            String string5 = FileUtils.normalizeSeparator(string2);
            if (!new File(string4).getPath().equals(new File(string5).getPath()) || !webServerInfo.getWebServer().equalsIgnoreCase("iis") && !webServerInfo.getApacheVirtualHost().equals(string3)) continue;
            return webServerInfo;
        }
        return null;
    }

    private File getPropertyFile() {
        return new File(CIUtil.getJRunDir(), "wsconfig.properties");
    }

    private void dumpEntries() {
        Enumeration enumeration = this.p.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.p.getProperty(string);
            System.err.println(string + " : " + string2);
        }
    }
}

