/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIJndi;
import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConfigParser;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.IISInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerException;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.UUID;
import java.util.Vector;

public abstract class WebServerInstaller {
    protected static final String serversFile = "instances.xml";
    protected static final String serverFile = "server.xml";
    private static final String clusterFile = "cluster.xml";
    protected static final String webxmlFile = "web.xml";
    protected static final String tmpSecretFile = "_tempajpsecret.txt";
    protected static final String conf = "conf";
    protected static final String runtime = "runtime";
    protected static final String lib = "lib";
    protected static final String sunone_connectionpoolsize = "100";
    protected String port = "8012";
    protected String workername = "standalone";
    protected String lbfactor = "1";
    protected boolean restartRequired = false;
    protected WebServerInfo wsInfo;
    protected CIJndi jrunInfo;
    protected static int wsMajorVer = 0;
    protected static int wsMinorVer = 0;
    protected int wsBuildNum = 0;
    protected String wsVersionStr = "";
    protected String supportedVersionStr = "";
    private static String lineSeparator = System.getProperty("line.separator");
    protected static final String shmFolderName = "shm";
    protected static final boolean isLinux = System.getProperty("os.name").toUpperCase().startsWith("LINUX");
    protected static final boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
    private static final String OLD_CFIDE_URI_MAPPING = "/CFIDE/*";
    private static final String NEW_CFIDE_URI_MAPPING = "/CFIDE*";

    public static WebServerInstaller createObject(WebServerInfo webServerInfo, CIJndi cIJndi) throws ConnectorInstallerException {
        WebServerInstaller webServerInstaller = null;
        Object var3_3 = null;
        webServerInfo.dump(cIJndi != null);
        String string = webServerInfo.getWebServer();
        try {
            Class<?> clazz = Class.forName("com.adobe.coldfusion.connector.connectorinstaller." + string + "Installer");
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            webServerInstaller = (WebServerInstaller)obj;
            webServerInstaller.wsInfo = webServerInfo;
            webServerInstaller.jrunInfo = cIJndi;
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.WSNotSupported", (Object)string));
        }
        return webServerInstaller;
    }

    public static WebServerInstaller createObject(WebServerInfo webServerInfo) throws ConnectorInstallerException {
        return WebServerInstaller.createObject(webServerInfo, null);
    }

    public abstract void installConnector() throws Exception;

    public abstract void installConnector(boolean var1) throws Exception;

    public abstract void removeConnector() throws Exception;

    public abstract void removeConnector(boolean var1) throws Exception;

    public abstract void removeConnector(boolean var1, boolean var2) throws Exception;

    public abstract void modifyConnector() throws Exception;

    public abstract void modifyConnector(boolean var1) throws Exception;

    public abstract void getConnectorConfig() throws Exception;

    public abstract void restartWS() throws WebServerException;

    public abstract void startWS() throws WebServerException;

    public abstract void stopWS() throws WebServerException;

    public abstract WebServerState getStateWS() throws Exception;

    public abstract boolean isValidVersion() throws ConnectorInstallerException;

    abstract String getConnectorName() throws ConnectorInstallerException;

    abstract boolean copyFiles(File var1, boolean var2) throws Exception;

    public boolean upgradeConnector() throws Exception {
        return this.upgradeConnector(this.getStateWS().isStarted());
    }

    private String unquoteClusterName(String string) {
        if (string.length() > 0 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private Map fetchClusterMap(String string) {
        ConfigParser configParser;
        Map<String, Map<String, Object>> map;
        String string2 = CIUtil.getJRunDir();
        String string3 = new File(string2).getParent();
        String string4 = string3 + File.separator + clusterFile;
        if (new File(string4).exists() && (map = (configParser = new ConfigParser(string4)).doClusterList()) != null) {
            Map<String, Object> map2 = map.get(string);
            ArrayList arrayList = null;
            if (map2 != null) {
                arrayList = (ArrayList)map2.get("serverlist");
            }
            if (arrayList != null && arrayList.size() > 0) {
                return map;
            }
        }
        return null;
    }

    private void writePropertiesToFile(boolean bl, String string, String string2, String string3, String string4, String string5) throws Exception {
        if (bl) {
            CIUtil.backupFile(string);
        }
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        boolean bl2 = new File(string).exists();
        if (bl2) {
            OrderedProperties orderedProperties = new OrderedProperties();
            bufferedReader = new BufferedReader(new FileReader(string));
            orderedProperties.load(bufferedReader);
            String string6 = "worker." + string5 + ".secret";
            String string7 = "worker." + string5 + ".heartbeat_servlet_path";
            if (string2 != null && !orderedProperties.containsKey(string6) && string3 != null && !orderedProperties.containsKey(string7)) {
                String string8 = string6 + "=" + string2;
                String string9 = string7 + "=" + string3;
                printWriter = new PrintWriter(new FileWriter(string, true));
                printWriter.println();
                printWriter.println(string8);
                printWriter.println(string9);
                printWriter.close();
            } else if (!(string2 == null || !orderedProperties.containsKey(string6) || string2.equals(orderedProperties.get(string6)) || string3 != null && orderedProperties.containsKey(string7) && string3.equals(orderedProperties.get(string7)))) {
                String string10 = string6 + "=" + orderedProperties.get(string6);
                String string11 = string6 + "=" + string2;
                Path path = Paths.get(string, new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>(Files.readAllLines(path, StandardCharsets.UTF_8));
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((String)arrayList.get(i)).equals(string10)) continue;
                    arrayList.set(i, string11);
                    break;
                }
                Files.write(path, arrayList, StandardCharsets.UTF_8, new OpenOption[0]);
            } else if (!(string2 != null && orderedProperties.containsKey(string6) && !string2.equals(orderedProperties.get(string6)) || string3 != null && orderedProperties.containsKey(string7) && string3.equals(orderedProperties.get(string7)))) {
                String string12 = string7 + "=" + orderedProperties.get(string7);
                String string13 = string7 + "=" + string3;
                Path path = Paths.get(string, new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>(Files.readAllLines(path, StandardCharsets.UTF_8));
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!((String)arrayList.get(i)).equals(string12)) continue;
                    arrayList.set(i, string13);
                    break;
                }
                Files.write(path, arrayList, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
    }

    private void updateProperties() throws Exception {
        String string;
        String string2 = this.wsInfo.getAppServerWebServerDir() + File.separator + "workers.properties";
        boolean bl = this.wsInfo.getWebServer().equalsIgnoreCase("Apache");
        if (bl) {
            string2 = this.wsInfo.getWebServerDir() + File.separator + "workers.properties";
        }
        if (!(string = this.unquoteClusterName(this.wsInfo.getClustername())).isEmpty()) {
            Map map = this.wsInfo.getClusterMap();
            if (map == null) {
                map = this.fetchClusterMap(this.wsInfo.getClustername());
            }
            if (map != null && !map.isEmpty()) {
                Map map2 = (Map)map.get(this.wsInfo.getClustername());
                ArrayList arrayList = (ArrayList)map2.get("serverlist");
                String string3 = CIUtil.getJRunDir();
                String string4 = new File(string3).getParent();
                String string5 = string4 + File.separator + serversFile;
                ConfigParser configParser = new ConfigParser(string5);
                Map<String, Map<String, Object>> map3 = configParser.doServerList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string6 = (String)arrayList.get(i);
                    Map<String, Object> map4 = map3.get(string6);
                    String string7 = (String)map4.get("remote");
                    String string8 = null;
                    String string9 = null;
                    if (Boolean.parseBoolean(string7)) {
                        this.workername = string6;
                        string8 = (String)map4.get("ajpSharedSecret");
                        if (string8 == null) {
                            continue;
                        }
                    } else {
                        String string10 = (String)map4.get("directory");
                        String string11 = string10 + File.separator + runtime + File.separator + conf + File.separator + serverFile;
                        ConfigParser configParser2 = new ConfigParser(string11);
                        String string12 = configParser2.getjvmRoute();
                        if (string12 != null) {
                            this.workername = string12;
                        }
                        string8 = configParser2.getConnectorSecret();
                        String string13 = string10 + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + webxmlFile;
                        ConfigParser configParser3 = new ConfigParser(string13);
                        string9 = configParser3.getConnectorHeartbeatPath();
                        if (string8 == null && string9 == null) continue;
                    }
                    this.writePropertiesToFile(bl, string2, string8, string9, this.wsInfo.getClustername(), this.workername);
                }
            }
        } else {
            String string14 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + runtime + File.separator + conf + File.separator + serverFile;
            ConfigParser configParser = new ConfigParser(string14);
            String string15 = configParser.getjvmRoute();
            if (string15 != null) {
                this.workername = string15;
            }
            String string16 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + webxmlFile;
            ConfigParser configParser4 = new ConfigParser(string16);
            String string17 = configParser.getConnectorSecret();
            String string18 = configParser4.getConnectorHeartbeatPath();
            if (string17 == null && string18 == null) {
                return;
            }
            this.writePropertiesToFile(bl, string2, string17, string18, null, this.workername);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void modifyBlockingURLRule(String string) {
        Object object;
        ArrayList<String> arrayList;
        block34: {
            BufferedReader bufferedReader;
            block33: {
                arrayList = new ArrayList<String>();
                bufferedReader = null;
                string = string + File.separator + "uriworkermap.properties";
                bufferedReader = new BufferedReader(new FileReader(string));
                String string2 = null;
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)object).contains(OLD_CFIDE_URI_MAPPING)) {
                        string2 = object;
                        continue;
                    }
                    arrayList.add((String)object);
                }
                if (string2 == null) break block33;
                arrayList.add(string2.replace(OLD_CFIDE_URI_MAPPING, NEW_CFIDE_URI_MAPPING));
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block34;
            }
            catch (IOException iOException) {}
            break block34;
            catch (IOException iOException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        object = null;
        try {
            object = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (int i = 0; i < arrayList.size(); ++i) {
                ((PrintWriter)object).println((String)arrayList.get(i));
            }
            ((PrintWriter)object).flush();
        }
        catch (IOException iOException) {
            try {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
            }
            catch (ConnectorInstallerException | MissingResourceException exception) {
            }
        }
        finally {
            try {
                if (object != null) {
                    ((PrintWriter)object).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean upgradeConnector(boolean bl) throws Exception {
        boolean bl2 = false;
        File file = this.wsInfo.getAppServerWebServerDir();
        if (file == null) {
            PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
            this.wsInfo = propertyFileEditor.findEntry(this.wsInfo);
            if (this.wsInfo == null) {
                throw new ConnectorInstallerException(RB.getString(this, "CI.WebServerNotConfigured"));
            }
            file = this.wsInfo.getAppServerWebServerDir();
        }
        try {
            if (bl) {
                this.stopWS();
            }
        }
        catch (WebServerException webServerException) {
            CIUtil.logInfo(webServerException.getLocalizedMessage());
        }
        this.modifyBlockingURLRule(file.getPath());
        CIUtil.backupDir(file);
        if (this.wsInfo.getWebServer().equals("Apache")) {
            bl2 = this.copyFiles(new File(this.wsInfo.getWebServerDir()), true);
            this.changesForConnectorBinaryInSELinux();
        } else {
            bl2 = this.copyFiles(file, true);
        }
        try {
            this.updateProperties();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (bl) {
                this.startWS();
            }
        }
        catch (WebServerException webServerException) {
            CIUtil.logInfo(webServerException.getLocalizedMessage());
        }
        return bl2;
    }

    WebServerState getNTServiceState(String string) {
        return this.getNTServiceState(string, string);
    }

    WebServerState getNTServiceState(String string, String string2) {
        WebServerState webServerState = new WebServerState();
        try {
            int n;
            if (new Win32Handler().isNTServiceDisabled(string)) {
                webServerState.setDisabled();
                CIUtil.logInfo(RB.getString((Object)this, "CI.WebServerDisabled", (Object)string2));
            }
            if ((n = new Win32Handler().statusNTService(string)) == 1) {
                webServerState.setStopped();
            } else if (n != 0) {
                webServerState.setStarted();
            }
        }
        catch (Exception exception) {
            webServerState.setUnknown();
        }
        if (Trace.ci) {
            Trace.trace(string2 + " (" + string + ") service state is " + webServerState);
        }
        return webServerState;
    }

    String getServerstoreFile() {
        File file = new File(this.wsInfo.getAppServerWebServerDir(), "jrunserver.store");
        return FileUtils.normalizeSeparator(file.getPath());
    }

    File createReadmeFile() throws ConnectorInstallerException {
        File file = new File(this.wsInfo.getAppServerWebServerDir(), "README");
        try {
            OutputStreamWriter outputStreamWriter;
            Charset charset = Charset.forName("UTF-8");
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset);
            outputStreamWriter2.write("This file was created by the ColdFusion Connector Installer." + lineSeparator);
            outputStreamWriter2.write("Do not delete this directory or the files in it because your web server" + lineSeparator);
            outputStreamWriter2.write("configuration files contain references to the files in this directory." + lineSeparator + lineSeparator);
            outputStreamWriter2.write("web server: " + this.wsInfo.getWebServer() + lineSeparator);
            if (this.wsVersionStr.length() > 0) {
                outputStreamWriter2.write("web server version: " + this.wsVersionStr + lineSeparator);
            }
            if (this.wsInfo.getWebServer().equals("IIS")) {
                outputStreamWriter2.write("IIS web site: " + ((IISInstaller)this).getSiteDisplayStr() + lineSeparator);
            } else {
                outputStreamWriter2.write("directory: " + this.wsInfo.getWebServerDir() + lineSeparator);
            }
            ((Writer)outputStreamWriter2).close();
            CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.CreateFile", file));
        }
        catch (Exception exception) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", file));
        }
        return file;
    }

    File createAppServerWsDir() throws ConnectorInstallerException {
        if (this.wsInfo.getAppServerWebServerDir() == null) {
            String string = CIUtil.getJRunDir();
            boolean bl = false;
            for (int i = 1; i <= Integer.MAX_VALUE; ++i) {
                File file = new File(string + File.separator + i);
                if (file.isDirectory()) continue;
                if (file.mkdir()) {
                    this.wsInfo.setAppServerWebServerDir(file);
                    bl = true;
                    break;
                }
                CIUtil.logDebug(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.WriteDirErr", file));
            }
            if (!bl) {
                throw new ConnectorInstallerException(RB.getString(ConnectorInstaller.class, "ConnectorInstaller.WriteDirErr", (Object)(string + File.separator + "1-" + Integer.MAX_VALUE)));
            }
            CIUtil.makeExecutableAndWritable(this.wsInfo.getAppServerWebServerDir().getPath());
        }
        return this.wsInfo.getAppServerWebServerDir();
    }

    void removeAppServerWsDir(boolean bl) throws IOException {
        if (bl) {
            CIUtil.backupDir(this.wsInfo.getAppServerWebServerDir());
        }
        CIUtil.deleteDir(this.wsInfo.getAppServerWebServerDir());
        this.wsInfo.setAppServerWebServerDir(null);
    }

    OrderedProperties getConnectorProperties(String string) throws ConnectorInstallerException {
        OrderedProperties orderedProperties = new OrderedProperties();
        return orderedProperties;
    }

    OrderedProperties getConnectorProperties(String string, String string2, String string3, String string4) throws ConnectorInstallerException {
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.put("sofile", string);
        orderedProperties.put("workerfile", string2);
        orderedProperties.put("iprestriction", string4);
        orderedProperties.put("uriworkermapfile", string3);
        orderedProperties.put("GlobalLogFile", this.wsInfo.getWebServerDir() + File.separator + "mod_jk_global.log");
        orderedProperties.put("LogFile", this.wsInfo.getAppServerWebServerDir() + File.separator + "mod_jk.log");
        if (isWindows) {
            orderedProperties.put("shmFile", this.wsInfo.getWebServerDir() + File.separator + "jk_shm");
        } else {
            orderedProperties.put("shmFile", this.wsInfo.getAppServerWebServerDir().getParent() + File.separator + shmFolderName + File.separator + "jk_shm");
        }
        if (this.wsInfo.isVerboseEnable()) {
            orderedProperties.put("LogLevel", "debug");
        } else {
            orderedProperties.put("LogLevel", "info");
        }
        orderedProperties.put("LogStampFormat", "[%a %b %d %H:%M:%S %Y] ");
        orderedProperties.put("CfscriptsPath", this.wsInfo.getCfscriptsPath());
        orderedProperties.put("workerFileReloadInterval", String.valueOf(this.wsInfo.getWorkerFileReloadInterval()));
        return orderedProperties;
    }

    OrderedProperties getWorkerProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.put("workerName", string);
        orderedProperties.put("hostname", string2);
        orderedProperties.put("portName", string3);
        orderedProperties.put("protocol", string4);
        orderedProperties.put("lbfactor", string5);
        orderedProperties.put("jvmroute", string6);
        orderedProperties.put("heartBeatInterval", this.wsInfo.getHeartBeatInterval() + "");
        orderedProperties.put("heartbeatLimit", this.wsInfo.getHeartbeatLimit() + "");
        if (string7 != null) {
            orderedProperties.put("secretKey", string7);
        }
        if (string8 != null) {
            orderedProperties.put("ajpSharedSecret", string8);
        }
        if (this.wsInfo.getWebServer().equalsIgnoreCase("SunJWS")) {
            orderedProperties.put("connectionpoolsize", sunone_connectionpoolsize);
        } else if (this.wsInfo.getWebServer().equalsIgnoreCase("IIS")) {
            orderedProperties.put("connectionpoolsize", String.valueOf(this.wsInfo.getConnectionPoolSize()));
        }
        orderedProperties.put("connectionPoolTimeout", String.valueOf(this.wsInfo.getConnectionTimeout()));
        if (this.wsInfo.getReuseCount() != 0) {
            orderedProperties.put("maxReuseConnections", String.valueOf(this.wsInfo.getReuseCount()));
        }
        if (string9 != null) {
            orderedProperties.put("connectorHeartBeatPath", string9);
        }
        return orderedProperties;
    }

    OrderedProperties getRedirectorProperties(String string, String string2, String string3, String string4, String string5) {
        OrderedProperties orderedProperties = new OrderedProperties();
        orderedProperties.put("extension_uri", string);
        orderedProperties.put("log_file", string2);
        if (this.wsInfo.isVerboseEnable()) {
            orderedProperties.put("log_level", "debug");
        } else {
            orderedProperties.put("log_level", "info");
        }
        orderedProperties.put("worker_file", string3);
        orderedProperties.put("worker_mount_file", string4);
        if (this.wsInfo.isBufferEnable()) {
            orderedProperties.put("iis_buffer_enable", "true");
        } else {
            orderedProperties.put("iis_buffer_enable", "false");
        }
        orderedProperties.put("ip_restriction_file", string5);
        orderedProperties.put("enable_chunked_encoding", (Object)true);
        orderedProperties.put("auth_complete", "1");
        if (this.wsInfo.isSetSkipCustomErros()) {
            orderedProperties.put("iis_skip_custom_errors_enable", "true");
        } else {
            orderedProperties.put("iis_skip_custom_errors_enable", "false");
        }
        return orderedProperties;
    }

    boolean writeWorkerFile(String string, OrderedProperties orderedProperties) throws ConnectorInstallerException {
        String string2;
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>(50, 25);
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = "true";
        boolean bl4 = this.wsInfo.getWebServer().equalsIgnoreCase("Apache");
        bl3 = new File(string).exists();
        if (bl3) {
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
                object2 = null;
                while ((object2 = bufferedReader.readLine()) != null) {
                    if (!this.wsInfo.getClustername().equals("")) {
                        object = "worker." + this.wsInfo.getClustername() + ".type";
                        string2 = "worker.list=";
                        if (((String)object2).indexOf(string2) != -1) {
                            bl2 = true;
                        }
                        if (((String)object2).indexOf((String)object) != -1) {
                            bl = true;
                            vector.addElement((String)object2);
                            object2 = bufferedReader.readLine();
                            if (object2 != null) {
                                object2 = ((String)object2).concat("," + orderedProperties.getProperty("workerName"));
                            }
                        }
                    }
                    vector.addElement((String)object2);
                }
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.LoadFileErr", (Object)string));
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.wsInfo.getClustername().equals("")) {
            vector.addElement("worker.list=" + orderedProperties.getProperty("workerName"));
        } else if (!bl2) {
            vector.addElement("worker.list=" + this.wsInfo.getClustername());
        }
        vector.addElement("");
        if (!this.wsInfo.getClustername().equals("") && !bl) {
            vector.addElement("worker." + this.wsInfo.getClustername() + ".type=lb");
            vector.addElement("worker." + this.wsInfo.getClustername() + ".balance_workers=" + orderedProperties.getProperty("workerName"));
            object2 = this.wsInfo.getClusterMap();
            object = (Map)object2.get(this.wsInfo.getClustername());
            string2 = (String)object.get("stickysession");
            if (string2 != null) {
                string3 = string2;
            }
            vector.addElement("worker." + this.wsInfo.getClustername() + ".sticky_session=" + string3);
            vector.addElement("");
        }
        if (this.wsInfo.getHeartBeatInterval() > 0 && !bl3 && !bl4) {
            vector.addElement("heartbeat_interval=" + orderedProperties.getProperty("heartBeatInterval"));
        }
        if (this.wsInfo.getHeartbeatLimit() > 0 && !bl3 && !bl4) {
            vector.addElement("heartbeat_limit=" + orderedProperties.getProperty("heartbeatLimit"));
            vector.addElement("");
        }
        vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".type=" + orderedProperties.getProperty("protocol"));
        vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".host=" + orderedProperties.getProperty("hostname"));
        vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".port=" + orderedProperties.getProperty("portName"));
        if (orderedProperties.getProperty("connectorHeartBeatPath") != null) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".heartbeat_servlet_path=" + orderedProperties.getProperty("connectorHeartBeatPath"));
        }
        if (this.wsInfo.getWebServer().equalsIgnoreCase("SunJWS") || this.wsInfo.getWebServer().equalsIgnoreCase("IIS")) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".connection_pool_size=" + orderedProperties.getProperty("connectionpoolsize"));
        }
        if (orderedProperties.getProperty("connectionPoolTimeout") != null) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".connection_pool_timeout=" + orderedProperties.getProperty("connectionPoolTimeout"));
        }
        if (orderedProperties.getProperty("maxReuseConnections") != null && Integer.parseInt(orderedProperties.getProperty("maxReuseConnections")) != 0 && this instanceof IISInstaller) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".max_reuse_connections=" + orderedProperties.getProperty("maxReuseConnections"));
        }
        if ((object2 = orderedProperties.getProperty("secretKey")) != null && !((String)object2).equals("")) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".monitoringsecret=" + (String)object2);
        }
        if (!this.wsInfo.getClustername().equals("")) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".lbfactor=" + orderedProperties.getProperty("lbfactor"));
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".route=" + orderedProperties.getProperty("jvmroute"));
        }
        if ((object = orderedProperties.getProperty("ajpSharedSecret")) != null) {
            vector.addElement("worker." + orderedProperties.getProperty("workerName") + ".secret=" + (String)object);
        }
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.elementAt(i));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    boolean writeUriWorkerMapFile(String string, String string2) throws ConnectorInstallerException {
        int n;
        Vector<String> vector = new Vector<String>(50, 25);
        PrintWriter printWriter = null;
        Vector vector2 = this.wsInfo.getDefaultCFMappings();
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement(vector2.elementAt(n) + " = " + string2);
        }
        vector2 = this.wsInfo.getDefaultBlockedURLs();
        for (n = 0; n < vector2.size(); ++n) {
            vector.addElement("!" + vector2.elementAt(n) + " = " + string2);
        }
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (n = 0; n < vector.size(); ++n) {
                printWriter.println((String)vector.elementAt(n));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    boolean writeRedirectFile(String string, OrderedProperties orderedProperties) throws Exception {
        Vector<String> vector = new Vector<String>(20);
        PrintWriter printWriter = null;
        vector.addElement("extension_uri= " + orderedProperties.getProperty("extension_uri"));
        vector.addElement("log_file= " + orderedProperties.getProperty("log_file"));
        vector.addElement("log_level= " + orderedProperties.getProperty("log_level"));
        vector.addElement("worker_file= " + orderedProperties.getProperty("worker_file"));
        vector.addElement("worker_mount_file= " + orderedProperties.getProperty("worker_mount_file"));
        vector.addElement("iis_buffer_enable= " + orderedProperties.getProperty("iis_buffer_enable"));
        vector.addElement("auth_complete= " + orderedProperties.getProperty("auth_complete"));
        vector.addElement("iis_skip_custom_errors_enable= " + orderedProperties.getProperty("iis_skip_custom_errors_enable"));
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.elementAt(i));
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    void writeIPRestrictionFile(String string, String string2) throws Exception {
        PrintWriter printWriter = null;
        Vector vector = this.wsInfo.getDefaultURLRestriction();
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            for (int i = 0; i < vector.size(); ++i) {
                printWriter.println((String)vector.elementAt(i) + "=" + string2);
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.CommitFileErr", (Object)string));
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    void writeConnectorPropertiesFile(String string, String string2) throws ConnectorInstallerException {
        Object object;
        Object object2;
        Map<String, Object> map;
        String string3;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        OrderedProperties orderedProperties = null;
        String string4 = null;
        File file = null;
        if (this.wsInfo.getWebServer().equalsIgnoreCase("Apache")) {
            file = this.wsInfo.getAppServerWebServerDir();
            string4 = string;
            string = string + "_" + this.wsInfo.getAppServerWebServerDir().getName() + ".tmp";
        }
        if (!this.wsInfo.getClustername().equals("")) {
            object10 = this.wsInfo.getClusterMap();
            if (!object10.isEmpty()) {
                object9 = (Map)object10.get(this.wsInfo.getClustername());
                object8 = (ArrayList)object9.get("serverlist");
                object7 = CIUtil.getJRunDir();
                object6 = new File((String)object7).getParent();
                object5 = (String)object6 + File.separator + serversFile;
                object4 = new ConfigParser((String)object5);
                object3 = ((ConfigParser)object4).doServerList();
                for (int i = 0; i < ((ArrayList)object8).size(); ++i) {
                    String string5;
                    String string6;
                    string3 = (String)((ArrayList)object8).get(i);
                    map = object3.get(string3);
                    object2 = (String)map.get("lbfactor");
                    this.lbfactor = object2 != null ? object2 : "1";
                    object = (String)map.get("secretKey");
                    String string7 = (String)map.get("remote");
                    if (Boolean.parseBoolean(string7)) {
                        this.port = (String)map.get("port");
                        this.workername = string3;
                        string6 = (String)map.get("host");
                        string5 = (String)map.get("ajpSharedSecret");
                        orderedProperties = this.getWorkerProperties(this.workername, string6, this.port, "ajp13", this.lbfactor, (String)map.get("jvmroute"), (String)object, string5, "/__cf_connector_heartbeat__");
                    } else {
                        Object object11;
                        Object object12;
                        String string8;
                        string6 = (String)map.get("directory");
                        string5 = string6 + File.separator + runtime + File.separator + conf + File.separator + serverFile;
                        ConfigParser configParser = new ConfigParser(string5);
                        String string9 = configParser.getConnectorPort();
                        String string10 = configParser.getConnectorSecret();
                        if (string10 == null) {
                            string8 = string6 + File.separator + lib + File.separator + tmpSecretFile;
                            object12 = new File(string8);
                            try {
                                if (((File)object12).createNewFile()) {
                                    string10 = UUID.randomUUID().toString();
                                    object11 = new FileWriter(string8, true);
                                    ((Writer)object11).write(string10);
                                    ((OutputStreamWriter)object11).close();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        string8 = string6 + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + webxmlFile;
                        object12 = new ConfigParser(string8);
                        if (string9 != null) {
                            this.port = string9;
                        }
                        if ((object11 = configParser.getjvmRoute()) != null) {
                            this.workername = object11;
                        }
                        orderedProperties = this.getWorkerProperties(this.workername, this.wsInfo.getHostName(), this.port, "ajp13", this.lbfactor, this.workername, (String)object, string10, ((ConfigParser)object12).getConnectorHeartbeatPath());
                    }
                    this.writeWorkerFile(string, orderedProperties);
                }
                if (!string2.equals("")) {
                    this.writeUriWorkerMapFile(string2, this.wsInfo.getClustername());
                }
            }
        } else {
            object10 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + runtime + File.separator + conf + File.separator + serverFile;
            object9 = new ConfigParser((String)object10);
            object8 = ((ConfigParser)object9).getConnectorPort();
            if (object8 != null) {
                this.port = object8;
            }
            if ((object7 = ((ConfigParser)object9).getjvmRoute()) != null) {
                this.workername = object7;
            }
            if ((object4 = ((ConfigParser)(object5 = new ConfigParser((String)(object6 = new File(CIUtil.getJRunDir()).getParent() + File.separator + serversFile)))).getInstanceSecretKey(this.workername)) == null || ((String)object4).equals("")) {
                object4 = UUID.randomUUID().toString();
                ((ConfigParser)object5).setInstanceSecretKey(this.workername, (String)object4);
                ((ConfigParser)object5).store();
            }
            object3 = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + webxmlFile;
            ConfigParser configParser = new ConfigParser((String)object3);
            string3 = ((ConfigParser)object9).getConnectorSecret();
            if (string3 == null) {
                map = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + this.wsInfo.getInstancename() + File.separator + lib + File.separator + tmpSecretFile;
                object2 = new File((String)((Object)map));
                try {
                    if (((File)object2).createNewFile()) {
                        string3 = UUID.randomUUID().toString();
                        object = new FileWriter((String)((Object)map), true);
                        ((Writer)object).write(string3);
                        ((OutputStreamWriter)object).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            orderedProperties = this.getWorkerProperties(this.workername, this.wsInfo.getHostName(), this.port, "ajp13", this.lbfactor, this.workername, (String)object4, string3, configParser.getConnectorHeartbeatPath());
            this.writeWorkerFile(string, orderedProperties);
            if (!string2.equals("")) {
                this.writeUriWorkerMapFile(string2, this.workername);
            }
        }
        if (this.wsInfo.getWebServer().equalsIgnoreCase("Apache")) {
            object10 = new File(string);
            boolean bl = new File(string4).exists();
            object8 = "";
            object8 = this.wsInfo.getClustername();
            if (((String)object8).equals("")) {
                object8 = this.workername;
            }
            if (!this.checkIfWorkerAlreadyConfiguredWithApache((String)object8)) {
                try {
                    object7 = new BufferedReader(new InputStreamReader(new FileInputStream((File)object10)));
                    object6 = null;
                    try {
                        object5 = new PrintWriter(new BufferedWriter(new FileWriter(string4, true)));
                        object4 = null;
                        try {
                            object3 = null;
                            StringBuilder stringBuilder = new StringBuilder("");
                            while ((object3 = ((BufferedReader)object7).readLine()) != null) {
                                stringBuilder.append((String)object3 + lineSeparator);
                            }
                            if (!bl) {
                                ((PrintWriter)object5).println("heartbeat_interval=" + orderedProperties.getProperty("heartBeatInterval"));
                                ((PrintWriter)object5).println("heartbeat_limit=" + orderedProperties.getProperty("heartbeatLimit") + lineSeparator);
                            }
                            ((PrintWriter)object5).println("#Start of workers.properties associated with '" + (String)object8 + "'");
                            ((PrintWriter)object5).print(stringBuilder.toString());
                            ((PrintWriter)object5).println("#End of workers.properties associated with '" + (String)object8 + "'" + lineSeparator);
                            ((PrintWriter)object5).flush();
                        }
                        catch (Throwable throwable) {
                            object4 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object5 != null) {
                                if (object4 != null) {
                                    try {
                                        ((PrintWriter)object5).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object4).addSuppressed(throwable);
                                    }
                                } else {
                                    ((PrintWriter)object5).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        object6 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object7 != null) {
                            if (object6 != null) {
                                try {
                                    ((BufferedReader)object7).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object6).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedReader)object7).close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            try {
                if (((File)object10).exists()) {
                    ((File)object10).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected boolean checkIfWorkerAlreadyConfiguredWithApache(String string) {
        PropertyFileEditor propertyFileEditor = null;
        try {
            propertyFileEditor = new PropertyFileEditor();
        }
        catch (ConnectorInstallerException | IOException exception) {
            exception.printStackTrace();
        }
        List<String> list = propertyFileEditor.getListOfWorkers("Apache");
        for (int i = 0; i < list.size(); ++i) {
            if (!string.equals(list.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkSELinuxEnabled() {
        String[] stringArray = new String[]{"sestatus"};
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufferedReader = null;
        try {
            Process process = runtime.exec(stringArray);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("SELinux status:") || !string.contains("enabled")) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected void changesForConnectorBinaryInSELinux() throws ConnectorInstallerException {
        if (isLinux && this.checkSELinuxEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            String string = this.wsInfo.getWebServerDir() + File.separator + "mod_jk.so";
            String[] stringArray = new String[]{"/bin/bash", "-c", "chcon -t httpd_modules_t -u system_u \"" + string + "\""};
            try {
                Process process = runtime.exec(stringArray);
            }
            catch (IOException iOException) {
                throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.WriteFileErr", (Object)string));
            }
        }
    }
}

