/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.Win32NativeHandler;
import com.adobe.coldfusion.connector.util.RB;
import java.io.File;
import java.io.IOException;

public class Win32Handler
extends Win32NativeHandler {
    private static final String IIS7ComponentsKey = "SOFTWARE\\Microsoft\\InetStp\\Components";
    private static final String IIS7ISAPIExtKey = "ISAPIExtensions";
    private static final String IIS7ISAPIFilterKey = "ISAPIFilter";
    private static final String IIS7MetabaseKey = "ADSICompatibility";
    private static final String ASPNETKey = "ASPNET";
    private static final String ASPNETKeyNewVer = "ASPNET45";
    private static final String CGIKey = "CGI";
    private static boolean dllLoaded = false;
    public static String appCmdExePath = null;
    public static String portExePath = null;

    public Win32Handler() throws IOException, ConnectorInstallerException {
        Object object;
        if (File.separatorChar == '/') {
            throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstallerInternalError"));
        }
        if (!dllLoaded) {
            object = this.extractDll();
            System.load((String)object);
            dllLoaded = true;
        }
        object = this.getIISVersion();
        Object object2 = object[0];
        Object object3 = object[1];
        if (appCmdExePath == null) {
            appCmdExePath = this.extractExe();
        }
    }

    public boolean checkWindowsOptions() {
        int n = this.getRegIntValue(IIS7ComponentsKey, ASPNETKey);
        int n2 = this.getRegIntValue(IIS7ComponentsKey, ASPNETKeyNewVer);
        int n3 = this.getRegIntValue(IIS7ComponentsKey, IIS7ISAPIExtKey);
        int n4 = this.getRegIntValue(IIS7ComponentsKey, IIS7ISAPIFilterKey);
        int n5 = this.getRegIntValue(IIS7ComponentsKey, CGIKey);
        return (n != 0 || n2 != 0) && n3 != 0 && n4 != 0 && n5 != 0;
    }

    public Win32Handler(String string) throws IOException, ConnectorInstallerException {
        if (File.separatorChar == '/') {
            throw new ConnectorInstallerException(RB.getString(this, "ConnectorInstallerInternalError"));
        }
        if (!dllLoaded) {
            System.load(string);
            dllLoaded = true;
        }
    }

    private String extractDll() throws IOException {
        String string;
        String string2;
        String string3 = System.getProperty("os.arch");
        if (string3.indexOf("64") != -1) {
            string2 = "connectors/installers/intel-win64/prebuilt/cfwin32.dll";
            string = CIUtil.getJRunDir() + File.separator + "cfwin32.dll";
        } else {
            string2 = "connectors/installers/intel-win/prebuilt/cfwin32.dll";
            string = CIUtil.getJRunDir() + File.separator + "cfwin32.dll";
        }
        CIUtil.extractConnector(string2, string, true);
        return string;
    }

    private String extractExe() throws IOException {
        String string;
        String string2;
        String string3 = System.getProperty("os.arch");
        if (string3.indexOf("64") != -1) {
            string2 = "connectors/installers/ExecuteAppCmd/x64/Release_64/ExecuteAppCmd.exe";
            string = System.getProperty("java.io.tmpdir") + File.separator + "ExecuteAppCmd" + File.separator + "ExecuteAppCmd.exe";
        } else {
            string2 = "connectors/installers/ExecuteAppCmd/Release/ExecuteAppCmd.exe";
            string = System.getProperty("java.io.tmpdir") + File.separator + "ExecuteAppCmd" + File.separator + "ExecuteAppCmd.exe";
        }
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "ExecuteAppCmd");
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        CIUtil.extractConnector(string2, string, true);
        return string;
    }

    private String extractPortExe() throws IOException {
        String string = "connectors/installers/utils/getIISPort.exe";
        String string2 = System.getProperty("java.io.tmpdir") + File.separator + "PortAppCmd" + File.separator + "getIISPort.exe";
        File file = new File(System.getProperty("java.io.tmpdir") + File.separator + "PortAppCmd");
        if (!file.exists() && !file.mkdir()) {
            return null;
        }
        CIUtil.extractConnector(string, string2, true);
        return string2;
    }
}

