/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller.gui;

import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.OrderedProperties;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.gui.AddConfigDialog;
import com.adobe.coldfusion.connector.connectorinstaller.gui.CIGuiUtil;
import com.adobe.coldfusion.connector.util.RB;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdvDialog
extends JDialog {
    private static final String DIALOG_TITLE = RB.getString(AdvDialog.class, "Adv.DialogTitle");
    private static final String ADVANCED_PANEL_TITLE = RB.getString(AdvDialog.class, "Adv.AdvancedPanelTitle");
    private static final String FILE_DIALOG_TITLE = RB.getString(AddConfigDialog.class, "Adv.FileDialogTitle");
    private static final String FILE_DIALOG_BUTTON = RB.getString(AddConfigDialog.class, "Adv.FileDialogButton");
    private static final String ENABLEBUFFER_LABEL = RB.getString(AdvDialog.class, "Adv.enableBufferLabel");
    private static final String SKIP_CUSTOM_ERROR_LABEL = RB.getString(AdvDialog.class, "Adv.skipCustomErrorLabel");
    private static final String VERBOSE_LABEL = RB.getString(AdvDialog.class, "Adv.VerboseLabel");
    private static final String REUSE_LABEL = RB.getString(AdvDialog.class, "Adv.ReUseLabel");
    private static final String CONNECTION_TIMEOUT_LABEL = RB.getString(AdvDialog.class, "Adv.ConnectionTimeout");
    private static final String CONNECTION_POOL_SIZE_LABEL = RB.getString(AdvDialog.class, "Adv.ConnectionPoolSize");
    private static final String CONNECTION_PANEL_TITLE = RB.getString(AdvDialog.class, "Adv.ConnectionPanelTitle");
    private static final String APACHE_PANEL_TITLE = RB.getString(AdvDialog.class, "Adv.ApachePanelTitle");
    private static final String NGINX_PANEL_TITLE = RB.getString(AdvDialog.class, "Adv.NginxPanelTitle");
    private static final String REUSE_CONNECTION_PROMPT = RB.getString(AdvDialog.class, "Adv.ReUseConnectionPrompt");
    private static final String CONNECTION_TIMEOUT_PROMPT = RB.getString(AdvDialog.class, "Adv.ConnectionTimeoutPrompt");
    private static final String CONNECTION_POOL_SIZE_PROMPT = RB.getString(AdvDialog.class, "Adv.ConnectionPoolSizePrompt");
    private static final String APACHE_BIN_FILE_LABEL = RB.getString(AdvDialog.class, "Adv.ApacheBinFileLabel");
    private static final String APACHE_BIN_FILE_PROMPT = RB.getString(AdvDialog.class, "Adv.ApacheBinFilePrompt");
    private static final String APACHE_SCRIPT_FILE_LABEL = RB.getString(AdvDialog.class, "Adv.ApacheScriptFileLabel");
    private static final String APACHE_SCRIPT_FILE_PROMPT = RB.getString(AdvDialog.class, "Adv.ApacheScriptFilePrompt");
    private static final String APACHE_CHOOSE_FILE_BUTTON = RB.getString(AddConfigDialog.class, "Add.ChooseDirButton");
    private static final String NGINX_BIN_FILE_LABEL = RB.getString(AdvDialog.class, "Adv.NginxBinFileLabel");
    private static final String NGINX_BIN_FILE_PROMPT = RB.getString(AdvDialog.class, "Adv.NginxBinFilePrompt");
    private static final String NGINX_CHOOSE_FILE_BUTTON = RB.getString(AddConfigDialog.class, "Add.ChooseDirButton");
    private static final String OK_BUTTON = RB.getString(AdvDialog.class, "Adv.OkButton");
    private static final String CANCEL_BUTTON = RB.getString(AdvDialog.class, "Adv.CancelButton");
    private JTextField apacheBinPathFld;
    private JButton apacheBinChooseFileButton;
    private JTextField apacheScriptPathFld;
    private JButton apacheScriptChooseFileButton;
    private JTextField nginxBinPathFld;
    private JButton nginxBinChooseFileButton;
    private JCheckBox verboseCheckBox;
    private JCheckBox enableBufferCheckBox;
    private JCheckBox skipCustomErrorCheckBox;
    private JTextField reUseConnectionTextFld;
    private JTextField connectionTimeoutTextFld;
    private JTextField connectionPoolSizeTextFld;
    private JTextField highReUseConnectionTextFld;
    private JTextField highConnectionTimeoutTextFld;
    private JTextField highConnectionPoolSizeTextFld;
    private JTextField mediumReUseConnectionTextFld;
    private JTextField mediumConnectionTimeoutTextFld;
    private JTextField mediumConnectionPoolSizeTextFld;
    private JTextField lowReUseConnectionTextFld;
    private JTextField lowConnectionTimeoutTextFld;
    private JTextField lowConnectionPoolSizeTextFld;
    private JFileChooser chooser;
    private JButton okButton = new JButton(OK_BUTTON);
    private JButton cancelButton = new JButton(CANCEL_BUTTON);
    private WebServerInfo wsInfo;

    public AdvDialog(Dialog dialog, WebServerInfo webServerInfo, JFileChooser jFileChooser) {
        super(dialog, true);
        this.setTitle(DIALOG_TITLE);
        this.setDefaultCloseOperation(2);
        this.wsInfo = webServerInfo;
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel = this.getAdvancedPropertiesPanel();
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 0;
        JPanel jPanel2 = this.getButtonPanel();
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        this.chooser = jFileChooser;
        this.addUIListeners();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    private JPanel getAdvancedPropertiesPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel2, ADVANCED_PANEL_TITLE);
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.verboseCheckBox = new JCheckBox(VERBOSE_LABEL, this.wsInfo.isVerboseEnable());
        this.verboseCheckBox.setBackground(CIGuiUtil.getJRunColor());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        jPanel2.add((Component)this.verboseCheckBox, gridBagConstraints);
        if (this.wsInfo.getWebServer().equals("IIS")) {
            this.enableBufferCheckBox = new JCheckBox(ENABLEBUFFER_LABEL, this.wsInfo.isBufferEnable());
            this.enableBufferCheckBox.setBackground(CIGuiUtil.getJRunColor());
            ++gridBagConstraints.gridy;
            jPanel2.add((Component)this.enableBufferCheckBox, gridBagConstraints);
            this.skipCustomErrorCheckBox = new JCheckBox(SKIP_CUSTOM_ERROR_LABEL, this.wsInfo.isSetSkipCustomErros());
            this.skipCustomErrorCheckBox.setBackground(CIGuiUtil.getJRunColor());
            ++gridBagConstraints.gridy;
            jPanel2.add((Component)this.skipCustomErrorCheckBox, gridBagConstraints);
        } else if (this.wsInfo.getWebServer().equals("Apache")) {
            jPanel = this.getApachePropertiesPanel();
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            jPanel2.add((Component)jPanel, gridBagConstraints);
        } else if (this.wsInfo.getWebServer().equals("Nginx")) {
            jPanel = this.getNginxPropertiesPanel();
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        jPanel = this.getConnectionPropertiesPanel();
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    private JPanel getConnectionPropertiesPanel() {
        JPanel jPanel = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel, CONNECTION_PANEL_TITLE);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        if (this.wsInfo.getWebServer().equals("IIS")) {
            JPanel jPanel2 = this.getWebsiteLoadPanel("High");
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            JPanel jPanel3 = this.getWebsiteLoadPanel("Medium");
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            JPanel jPanel4 = this.getWebsiteLoadPanel("Low");
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        } else if (this.wsInfo.getWebServer().equals("Apache")) {
            gridBagConstraints.gridx = 1;
            JLabel jLabel = new JLabel(CONNECTION_TIMEOUT_LABEL);
            jLabel.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
            jLabel.setText(CONNECTION_TIMEOUT_LABEL);
            this.connectionTimeoutTextFld = new JTextField(25);
            this.connectionTimeoutTextFld.setText("" + this.wsInfo.getConnectionTimeout());
            this.connectionTimeoutTextFld.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
            this.connectionTimeoutTextFld.setSize(20, 20);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)this.connectionTimeoutTextFld, gridBagConstraints);
        } else if (this.wsInfo.getWebServer().equals("Nginx")) {
            gridBagConstraints.gridx = 1;
            JLabel jLabel = new JLabel(REUSE_LABEL);
            jLabel.setToolTipText(REUSE_CONNECTION_PROMPT);
            this.reUseConnectionTextFld = new JTextField(25);
            this.reUseConnectionTextFld.setText("" + this.wsInfo.getReuseCount());
            this.reUseConnectionTextFld.setToolTipText(REUSE_CONNECTION_PROMPT);
            this.reUseConnectionTextFld.setSize(20, 20);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this.reUseConnectionTextFld, gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel getWebsiteLoadPanel(String string) {
        switch (string) {
            case "High": {
                this.highConnectionPoolSizeTextFld = new JTextField(25);
                this.highConnectionPoolSizeTextFld.setText("" + this.wsInfo.getHighConnectionPoolSize());
                this.highConnectionPoolSizeTextFld.setToolTipText(CONNECTION_POOL_SIZE_PROMPT);
                this.highConnectionPoolSizeTextFld.setSize(20, 20);
                this.connectionPoolSizeTextFld = this.highConnectionPoolSizeTextFld;
                this.highReUseConnectionTextFld = new JTextField(25);
                this.highReUseConnectionTextFld.setText("" + this.wsInfo.getHighReuseConnections());
                this.highReUseConnectionTextFld.setToolTipText(REUSE_CONNECTION_PROMPT);
                this.highReUseConnectionTextFld.setSize(20, 20);
                this.reUseConnectionTextFld = this.highReUseConnectionTextFld;
                this.highConnectionTimeoutTextFld = new JTextField(25);
                this.highConnectionTimeoutTextFld.setText("" + this.wsInfo.getHighConnectionTimeout());
                this.highConnectionTimeoutTextFld.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
                this.highConnectionTimeoutTextFld.setSize(20, 20);
                this.connectionTimeoutTextFld = this.highConnectionTimeoutTextFld;
                break;
            }
            case "Medium": {
                this.mediumConnectionPoolSizeTextFld = new JTextField(25);
                this.mediumConnectionPoolSizeTextFld.setText("" + this.wsInfo.getMediumConnectionPoolSize());
                this.mediumConnectionPoolSizeTextFld.setToolTipText(CONNECTION_POOL_SIZE_PROMPT);
                this.mediumConnectionPoolSizeTextFld.setSize(20, 20);
                this.connectionPoolSizeTextFld = this.mediumConnectionPoolSizeTextFld;
                this.mediumReUseConnectionTextFld = new JTextField(25);
                this.mediumReUseConnectionTextFld.setText("" + this.wsInfo.getMediumReuseConnections());
                this.mediumReUseConnectionTextFld.setToolTipText(REUSE_CONNECTION_PROMPT);
                this.mediumReUseConnectionTextFld.setSize(20, 20);
                this.reUseConnectionTextFld = this.mediumReUseConnectionTextFld;
                this.mediumConnectionTimeoutTextFld = new JTextField(25);
                this.mediumConnectionTimeoutTextFld.setText("" + this.wsInfo.getMediumConnectionTimeout());
                this.mediumConnectionTimeoutTextFld.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
                this.mediumConnectionTimeoutTextFld.setSize(20, 20);
                this.connectionTimeoutTextFld = this.mediumConnectionTimeoutTextFld;
                break;
            }
            case "Low": {
                this.lowConnectionPoolSizeTextFld = new JTextField(25);
                this.lowConnectionPoolSizeTextFld.setText("" + this.wsInfo.getLowConnectionPoolSize());
                this.lowConnectionPoolSizeTextFld.setToolTipText(CONNECTION_POOL_SIZE_PROMPT);
                this.lowConnectionPoolSizeTextFld.setSize(20, 20);
                this.connectionPoolSizeTextFld = this.lowConnectionPoolSizeTextFld;
                this.lowReUseConnectionTextFld = new JTextField(25);
                this.lowReUseConnectionTextFld.setText("" + this.wsInfo.getLowReuseConnections());
                this.lowReUseConnectionTextFld.setToolTipText(REUSE_CONNECTION_PROMPT);
                this.lowReUseConnectionTextFld.setSize(20, 20);
                this.reUseConnectionTextFld = this.lowReUseConnectionTextFld;
                this.lowConnectionTimeoutTextFld = new JTextField(25);
                this.lowConnectionTimeoutTextFld.setText("" + this.wsInfo.getLowConnectionTimeout());
                this.lowConnectionTimeoutTextFld.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
                this.lowConnectionTimeoutTextFld.setSize(20, 20);
                this.connectionTimeoutTextFld = this.lowConnectionTimeoutTextFld;
            }
        }
        Object object = new JPanel();
        CIGuiUtil.SetTitledBorder((JPanel)object, "Website Load " + string);
        ((Container)object).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        JLabel jLabel = new JLabel(CONNECTION_POOL_SIZE_LABEL);
        jLabel.setToolTipText(CONNECTION_POOL_SIZE_PROMPT);
        jLabel.setText(CONNECTION_POOL_SIZE_LABEL);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        ((Container)object).add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ((Container)object).add((Component)this.connectionPoolSizeTextFld, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        JLabel jLabel2 = new JLabel(REUSE_LABEL);
        jLabel2.setToolTipText(REUSE_CONNECTION_PROMPT);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        ((Container)object).add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ((Container)object).add((Component)this.reUseConnectionTextFld, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        JLabel jLabel3 = new JLabel(CONNECTION_TIMEOUT_LABEL);
        jLabel3.setToolTipText(CONNECTION_TIMEOUT_PROMPT);
        jLabel3.setText(CONNECTION_TIMEOUT_LABEL);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        ((Container)object).add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ((Container)object).add((Component)this.connectionTimeoutTextFld, gridBagConstraints);
        return object;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private void addUIListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AdvDialog.this.close();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvDialog.this.wsInfo.setVerboseLogging(AdvDialog.this.verboseCheckBox.isSelected());
                if (!AdvDialog.this.setBinPath()) {
                    return;
                }
                String string = null;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                if (AdvDialog.this.wsInfo.getWebServer().equals("IIS")) {
                    AdvDialog.this.wsInfo.setEnableBuffer(AdvDialog.this.enableBufferCheckBox.isSelected());
                    AdvDialog.this.wsInfo.setSetSkipCustomErros(AdvDialog.this.skipCustomErrorCheckBox.isSelected());
                    string = AdvDialog.this.connectionTimeoutTextFld.getText();
                    string3 = AdvDialog.this.connectionPoolSizeTextFld.getText();
                    string2 = AdvDialog.this.reUseConnectionTextFld.getText();
                    string4 = AdvDialog.this.highConnectionTimeoutTextFld.getText();
                    string6 = AdvDialog.this.highConnectionPoolSizeTextFld.getText();
                    string5 = AdvDialog.this.highReUseConnectionTextFld.getText();
                    string7 = AdvDialog.this.mediumConnectionTimeoutTextFld.getText();
                    string9 = AdvDialog.this.mediumConnectionPoolSizeTextFld.getText();
                    string8 = AdvDialog.this.mediumReUseConnectionTextFld.getText();
                    string10 = AdvDialog.this.lowConnectionTimeoutTextFld.getText();
                    string12 = AdvDialog.this.lowConnectionPoolSizeTextFld.getText();
                    string11 = AdvDialog.this.lowReUseConnectionTextFld.getText();
                } else if (AdvDialog.this.wsInfo.getWebServer().equals("Apache")) {
                    string = AdvDialog.this.connectionTimeoutTextFld.getText();
                } else if (AdvDialog.this.wsInfo.getWebServer().equals("Nginx")) {
                    string2 = AdvDialog.this.reUseConnectionTextFld.getText();
                }
                try {
                    if (string2 != null) {
                        AdvDialog.this.wsInfo.setResueCount(Integer.parseInt(string2));
                    }
                    if (string != null) {
                        AdvDialog.this.wsInfo.setConnectionTimeout(Integer.parseInt(string));
                    }
                    if (string3 != null) {
                        AdvDialog.this.wsInfo.setConnectionPoolSize(Integer.parseInt(string3));
                    }
                    if (string5 != null) {
                        AdvDialog.this.wsInfo.setHighReuseConnections(Integer.parseInt(string5));
                    }
                    if (string4 != null) {
                        AdvDialog.this.wsInfo.setHighConnectionTimeout(Integer.parseInt(string4));
                    }
                    if (string6 != null) {
                        AdvDialog.this.wsInfo.setHighConnectionPoolSize(Integer.parseInt(string6));
                    }
                    if (string8 != null) {
                        AdvDialog.this.wsInfo.setMediumReuseConnections(Integer.parseInt(string8));
                    }
                    if (string7 != null) {
                        AdvDialog.this.wsInfo.setMediumConnectionTimeout(Integer.parseInt(string7));
                    }
                    if (string9 != null) {
                        AdvDialog.this.wsInfo.setMediumConnectionPoolSize(Integer.parseInt(string9));
                    }
                    if (string11 != null) {
                        AdvDialog.this.wsInfo.setLowReuseConnections(Integer.parseInt(string11));
                    }
                    if (string10 != null) {
                        AdvDialog.this.wsInfo.setLowConnectionTimeout(Integer.parseInt(string10));
                    }
                    if (string12 != null) {
                        AdvDialog.this.wsInfo.setLowConnectionPoolSize(Integer.parseInt(string12));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    CIGuiUtil.showWarningMessage((Component)AdvDialog.this, "Invalid Input, Please enter a valid number");
                    return;
                }
                OrderedProperties orderedProperties = new OrderedProperties();
                orderedProperties.setProperty("iis.connectionpool.high", AdvDialog.this.wsInfo.getHighConnectionPoolSize() + "");
                orderedProperties.setProperty("iis.maxreuse.high", AdvDialog.this.wsInfo.getHighReuseConnections() + "");
                orderedProperties.setProperty("iis.connectionpooltimeout.high", AdvDialog.this.wsInfo.getHighConnectionTimeout() + "");
                orderedProperties.setProperty("iis.connectionpool.low", AdvDialog.this.wsInfo.getLowConnectionPoolSize() + "");
                orderedProperties.setProperty("iis.maxreuse.low", AdvDialog.this.wsInfo.getLowReuseConnections() + "");
                orderedProperties.setProperty("iis.connectionpooltimeout.low", AdvDialog.this.wsInfo.getLowConnectionTimeout() + "");
                orderedProperties.setProperty("iis.connectionpool.medium", AdvDialog.this.wsInfo.getMediumConnectionPoolSize() + "");
                orderedProperties.setProperty("iis.maxreuse.medium", AdvDialog.this.wsInfo.getMediumReuseConnections() + "");
                orderedProperties.setProperty("iis.connectionpooltimeout.medium", AdvDialog.this.wsInfo.getMediumConnectionTimeout() + "");
                FileOutputStream fileOutputStream = null;
                try {
                    String string13 = System.getProperty("user.dir");
                    File file = new File(string13);
                    string13 = string13.endsWith("bin") ? file.getParent() + File.separator + "lib" + File.separator + "config.properties" : string13 + File.separator + "config.properties";
                    fileOutputStream = new FileOutputStream(string13);
                    orderedProperties.store(fileOutputStream, null);
                }
                catch (Exception exception) {
                    System.err.println("Error occured: " + exception.getMessage());
                }
                finally {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                AdvDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvDialog.this.close();
            }
        });
        if (this.apacheBinPathFld != null) {
            this.apacheBinPathFld.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AdvDialog.this.apacheScriptPathFld != null) {
                        AdvDialog.this.apacheScriptPathFld.requestFocus();
                    } else {
                        AdvDialog.this.okButton.requestFocus();
                    }
                }
            });
        }
        if (this.apacheScriptChooseFileButton != null) {
            this.apacheScriptChooseFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AdvDialog.this.chooser.setFileSelectionMode(0);
                    AdvDialog.this.chooser.setDialogTitle(FILE_DIALOG_TITLE);
                    AdvDialog.this.chooser.setForeground(CIGuiUtil.getJRunColor());
                    int n = AdvDialog.this.chooser.showDialog(AdvDialog.this, FILE_DIALOG_BUTTON);
                    if (n == 0) {
                        AdvDialog.this.apacheScriptPathFld.setText(AdvDialog.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        if (this.apacheBinChooseFileButton != null) {
            this.apacheBinChooseFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AdvDialog.this.chooser.setFileSelectionMode(0);
                    AdvDialog.this.chooser.setDialogTitle(FILE_DIALOG_TITLE);
                    AdvDialog.this.chooser.setForeground(CIGuiUtil.getJRunColor());
                    int n = AdvDialog.this.chooser.showDialog(AdvDialog.this, FILE_DIALOG_BUTTON);
                    if (n == 0) {
                        AdvDialog.this.apacheBinPathFld.setText(AdvDialog.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
        if (this.nginxBinChooseFileButton != null) {
            this.nginxBinChooseFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AdvDialog.this.chooser.setFileSelectionMode(0);
                    AdvDialog.this.chooser.setDialogTitle(FILE_DIALOG_TITLE);
                    AdvDialog.this.chooser.setForeground(CIGuiUtil.getJRunColor());
                    int n = AdvDialog.this.chooser.showDialog(AdvDialog.this, FILE_DIALOG_BUTTON);
                    if (n == 0) {
                        AdvDialog.this.nginxBinPathFld.setText(AdvDialog.this.chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        }
    }

    private void close() {
        this.dispose();
    }

    private JPanel getApachePropertiesPanel() {
        JPanel jPanel = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel, APACHE_PANEL_TITLE);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel(APACHE_BIN_FILE_LABEL);
        jLabel.setToolTipText(APACHE_BIN_FILE_PROMPT);
        this.apacheBinPathFld = new JTextField(25);
        this.apacheBinPathFld.setText(this.wsInfo.getApacheBinPath());
        this.apacheBinPathFld.setToolTipText(APACHE_BIN_FILE_PROMPT);
        this.apacheBinChooseFileButton = new JButton(APACHE_CHOOSE_FILE_BUTTON);
        this.apacheBinChooseFileButton.setToolTipText(APACHE_BIN_FILE_PROMPT);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.apacheBinPathFld, gridBagConstraints);
        this.apacheBinChooseFileButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        jPanel.add((Component)this.apacheBinChooseFileButton, gridBagConstraints);
        if (File.separatorChar == '/') {
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            JLabel jLabel2 = new JLabel(APACHE_SCRIPT_FILE_LABEL);
            jLabel2.setToolTipText(APACHE_SCRIPT_FILE_PROMPT);
            this.apacheScriptPathFld = new JTextField(25);
            this.apacheScriptPathFld.setText(this.wsInfo.getApacheScriptPath());
            this.apacheScriptPathFld.setToolTipText(APACHE_SCRIPT_FILE_PROMPT);
            this.apacheScriptChooseFileButton = new JButton(APACHE_CHOOSE_FILE_BUTTON);
            this.apacheScriptChooseFileButton.setToolTipText(APACHE_SCRIPT_FILE_PROMPT);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 10, 10, 10);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)this.apacheScriptPathFld, gridBagConstraints);
            this.apacheScriptChooseFileButton.setMargin(new Insets(0, 0, 0, 0));
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 5, 10, 10);
            jPanel.add((Component)this.apacheScriptChooseFileButton, gridBagConstraints);
        }
        return jPanel;
    }

    private boolean setBinPath() {
        if (this.apacheBinPathFld != null) {
            try {
                this.wsInfo.setApacheBinPath(this.apacheBinPathFld.getText());
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                this.apacheBinPathFld.requestFocus();
                CIGuiUtil.showWarningMessage((Component)this, connectorInstallerException);
                return false;
            }
        }
        if (this.nginxBinPathFld != null) {
            try {
                this.wsInfo.setNginxBinPath(this.nginxBinPathFld.getText());
            }
            catch (ConnectorInstallerException connectorInstallerException) {
                this.nginxBinPathFld.requestFocus();
                CIGuiUtil.showWarningMessage((Component)this, connectorInstallerException);
                return false;
            }
        }
        return true;
    }

    private JPanel getNginxPropertiesPanel() {
        JPanel jPanel = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel, NGINX_PANEL_TITLE);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel = new JLabel(NGINX_BIN_FILE_LABEL);
        jLabel.setToolTipText(NGINX_BIN_FILE_PROMPT);
        this.nginxBinPathFld = new JTextField(25);
        this.nginxBinPathFld.setText(this.wsInfo.getNginxBinPath());
        this.nginxBinPathFld.setToolTipText(NGINX_BIN_FILE_PROMPT);
        this.nginxBinChooseFileButton = new JButton(NGINX_CHOOSE_FILE_BUTTON);
        this.nginxBinChooseFileButton.setToolTipText(NGINX_BIN_FILE_PROMPT);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)this.nginxBinPathFld, gridBagConstraints);
        this.nginxBinChooseFileButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        jPanel.add((Component)this.nginxBinChooseFileButton, gridBagConstraints);
        return jPanel;
    }
}

