/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller.gui;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.util.RB;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

class CIGuiUtil {
    private static final String WARNING_STRING = RB.getString(CIGuiUtil.class, "CIGui.Warning");
    private static final String CONFIRM_STRING = RB.getString(CIGuiUtil.class, "CIGui.Confirm");

    CIGuiUtil() {
    }

    static ImageIcon getIcon(String string) {
        String string2 = CIGuiUtil.class.getPackage().getName().replace('.', '/');
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource(string2 + string);
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(string2 + string);
        }
        return new ImageIcon(uRL);
    }

    static void centerWindow(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - window.getSize().width) / 2;
        int n2 = (dimension.height - window.getSize().height) / 2;
        window.setLocation(n, n2);
    }

    static void setUIState(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                CIGuiUtil.setUIState((Container)componentArray[i], bl);
            }
            CIGuiUtil.setTextEnable(componentArray[i], bl);
        }
    }

    static void setTextEnable(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof JTextComponent && !bl) {
            component.setBackground(SystemColor.control);
        } else if (component instanceof JTextComponent) {
            component.setBackground(Color.white);
        }
    }

    static TitledBorder SetTitledBorder(JPanel jPanel, String string) {
        LineBorder lineBorder = new LineBorder(CIGuiUtil.getJRunLightColor());
        TitledBorder titledBorder = new TitledBorder(lineBorder, "   " + string + "   ", 1, 2);
        titledBorder.setTitleColor(CIGuiUtil.getJRunLightColor());
        Font font = jPanel.getFont();
        Font font2 = font.deriveFont(1, font.getSize() + 2);
        titledBorder.setTitleFont(font2);
        jPanel.setBorder(titledBorder);
        return titledBorder;
    }

    static Color getJRunColor() {
        return new Color(225, 235, 230);
    }

    static Color getJRunLightColor() {
        return new Color(80, 100, 90);
    }

    static int showConfirmationMessageWithCancel(Component component, String string) {
        return JOptionPane.showConfirmDialog(component, string, CONFIRM_STRING, 1);
    }

    static boolean showConfirmationMessage(Component component, String string) {
        return JOptionPane.showConfirmDialog(component, string, CONFIRM_STRING, 0) == 0;
    }

    static void showMessage(Component component, String string) {
        JOptionPane.showMessageDialog(component, string);
    }

    static void showWarningMessage(Component component, String string) {
        if (string == null) {
            string = RB.getString(CIGuiUtil.class, "CIGui.UnknownError");
        }
        JOptionPane.showMessageDialog(component, string, WARNING_STRING, 2);
    }

    static void showWarningMessage(Component component, Exception exception) {
        String string = !CIUtil.isDebugEnabled() ? exception.getMessage() : exception.toString();
        if (string == null) {
            string = RB.getString(CIGuiUtil.class, "CIGui.UnknownError");
        }
        JOptionPane.showMessageDialog(component, string, WARNING_STRING, 2);
    }

    public static void setUIProperties() {
        UIManager.put("OptionPane.background", CIGuiUtil.getJRunColor());
        UIManager.put("Panel.background", CIGuiUtil.getJRunColor());
        UIManager.put("Panel.foreground", CIGuiUtil.getJRunLightColor());
        UIManager.put("List.background", CIGuiUtil.getJRunColor());
        UIManager.put("ToolTip.background", SystemColor.info);
    }

    public static String getSelectedButtonText(ButtonGroup buttonGroup) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            return abstractButton.getText();
        }
        return null;
    }
}

