/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller.gui;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.PropertyFileEditor;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInfo;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerInstaller;
import com.adobe.coldfusion.connector.connectorinstaller.WebServerState;
import com.adobe.coldfusion.connector.connectorinstaller.Win32Handler;
import com.adobe.coldfusion.connector.connectorinstaller.gui.AddConfigDialog;
import com.adobe.coldfusion.connector.connectorinstaller.gui.CIGuiUtil;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.ui.BusyJFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfigFrame
extends BusyJFrame {
    private static final String WINDOW_TITLE = RB.getString(ConfigFrame.class, "Frame.WindowTitle");
    private static final String CONFIG_PANEL_TITLE = RB.getString(ConfigFrame.class, "Frame.ConfigPanelTitle");
    private static final String ADD_BUTTON = RB.getString(ConfigFrame.class, "Frame.AddButton");
    private static final String REMOVE_BUTTON = RB.getString(ConfigFrame.class, "Frame.RemoveButton");
    private static final String UPGRADE_BUTTON = RB.getString(ConfigFrame.class, "Frame.UpgradeButton");
    private static final String CANCEL_BUTTON = RB.getString(ConfigFrame.class, "Frame.ExitButton");
    private JButton addButton = new JButton(ADD_BUTTON);
    private JButton removeButton = new JButton(REMOVE_BUTTON);
    private JButton upgradeButton = new JButton(UPGRADE_BUTTON);
    private JButton cancelButton = new JButton(CANCEL_BUTTON);
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    private ArrayList configList = new ArrayList(5);

    public ConfigFrame() throws Exception {
        super(WINDOW_TITLE);
        this.setDefaultCloseOperation(3);
        WebServerInfo webServerInfo = new WebServerInfo();
        if (webServerInfo.isSupportedWebServer("IIS")) {
            try {
                new Win32Handler();
            }
            catch (Exception exception) {
                CIGuiUtil.showWarningMessage((Component)this, RB.getString(this, "CIGui.AnotherInstanceRunning"));
                throw new ConnectorInstallerException(RB.getString(this, "CIGui.AnotherInstanceRunning"));
            }
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipady = 10;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        JPanel jPanel = this.getConfigPanel();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        JPanel jPanel2 = this.getButtonsPanel();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        this.addUIListeners();
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.pack();
    }

    private JPanel getButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(this.addButton);
        jPanel.add(this.upgradeButton);
        jPanel.add(this.removeButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private JPanel getConfigPanel() {
        JPanel jPanel = new JPanel();
        CIGuiUtil.SetTitledBorder(jPanel, CONFIG_PANEL_TITLE);
        jPanel.setLayout(new BorderLayout());
        this.list = this.getConfigList();
        jPanel.add((Component)new JScrollPane(this.list), "Center");
        int n = this.list.getModel().getSize();
        int n2 = Math.min(n, 5);
        this.list.setVisibleRowCount(n2);
        return jPanel;
    }

    void addConfig(WebServerInfo webServerInfo, String string, String string2, boolean bl) throws ConnectorInstallerException {
        this.addConfig(webServerInfo, string, string2);
        if (bl) {
            this.list.setSelectedIndex(this.listModel.getSize() - 1);
            this.removeButton.setEnabled(true);
            this.upgradeButton.setEnabled(true);
        }
        int n = this.list.getModel().getSize();
        int n2 = Math.min(n, 5);
        this.list.setVisibleRowCount(n2);
    }

    void addConfig(WebServerInfo webServerInfo, String string, String string2) throws ConnectorInstallerException {
        String string3 = webServerInfo.formatWebServerDir();
        String string4 = "";
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string4 = "[ " + string + ":" + string2 + " ] " + webServerInfo.getWebServerDisplay() + " : " + string3;
        if (webServerInfo.getWebServer().equals("Apache")) {
            string4 = string4 + " (" + webServerInfo.getApacheVirtualHost() + ")";
        }
        if (this.listModel.contains(string4)) {
            return;
        }
        this.listModel.addElement(string4);
        this.configList.add(webServerInfo);
        this.pack();
    }

    private JList getConfigList() {
        this.removeButton.setEnabled(false);
        this.upgradeButton.setEnabled(false);
        try {
            Object[] objectArray;
            PropertyFileEditor propertyFileEditor = new PropertyFileEditor();
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            while ((objectArray = propertyFileEditor.nextFullEntry()) != null) {
                arrayList.add(objectArray);
            }
            if (arrayList.size() != 0) {
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        try {
                            Object[] objectArray = (Object[])object;
                            Object[] objectArray2 = (Object[])object2;
                            WebServerInfo webServerInfo = (WebServerInfo)objectArray[0];
                            WebServerInfo webServerInfo2 = (WebServerInfo)objectArray2[0];
                            String string = webServerInfo.getWebServer() + " " + webServerInfo.formatWebServerDir();
                            String string2 = webServerInfo2.getWebServer() + " " + webServerInfo2.formatWebServerDir();
                            if (webServerInfo.getWebServer().equals(webServerInfo2.getWebServer())) {
                                if (webServerInfo.formatWebServerDir().equals(RB.getString(CIUtil.class, "CI.IISAllSitesGuiTag"))) {
                                    return -1;
                                }
                                if (webServerInfo2.formatWebServerDir().equals(RB.getString(CIUtil.class, "CI.IISAllSitesGuiTag"))) {
                                    return 1;
                                }
                            }
                            return string.toLowerCase().compareTo(string2.toLowerCase());
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }
                });
                for (int i = 0; i < arrayList.size(); ++i) {
                    objectArray = (Object[])arrayList.get(i);
                    this.addConfig((WebServerInfo)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listSelectionModel.setSelectionMode(2);
        this.list.setSelectionModel(this.listSelectionModel);
        this.list.setBorder(new EtchedBorder());
        return this.list;
    }

    private void addUIListeners() {
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigFrame.this.listSelectionModel.clearSelection();
                ConfigFrame.this.setBusy(true);
                AddConfigDialog addConfigDialog = new AddConfigDialog(ConfigFrame.this);
                addConfigDialog.setLocationRelativeTo(ConfigFrame.this);
                addConfigDialog.setVisible(true);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CIGuiUtil.showConfirmationMessage(ConfigFrame.this, RB.getString(ConfigFrame.this, "Remove.ConfirmBackup"));
                RemoveSelectedConfigThread removeSelectedConfigThread = new RemoveSelectedConfigThread(bl);
                removeSelectedConfigThread.start();
            }
        });
        this.upgradeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpgradeSelectedConfigThread upgradeSelectedConfigThread = new UpgradeSelectedConfigThread();
                upgradeSelectedConfigThread.start();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ConfigFrame.this.removeButton.setEnabled(!ConfigFrame.this.list.isSelectionEmpty());
                ConfigFrame.this.upgradeButton.setEnabled(!ConfigFrame.this.list.isSelectionEmpty());
            }
        });
    }

    public static void run() throws Exception {
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        File file = null;
        if (File.separatorChar == '/') {
            printStream = System.err;
            file = File.createTempFile("syserr", "log");
            printStream2 = new PrintStream(new FileOutputStream(file));
            System.setErr(printStream2);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            CIGuiUtil.setUIProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigFrame configFrame = new ConfigFrame();
        if (File.separatorChar == '/') {
            System.setErr(printStream);
            printStream2.close();
            file.delete();
        }
        CIGuiUtil.centerWindow(configFrame);
        configFrame.setVisible(true);
    }

    private class UpgradeSelectedConfigThread
    extends Thread {
        private UpgradeSelectedConfigThread() {
        }

        @Override
        public void run() {
            int[] nArray = ConfigFrame.this.list.getSelectedIndices();
            if (nArray.length == 0) {
                CIGuiUtil.showWarningMessage((Component)ConfigFrame.this, RB.getString(ConfigFrame.this, "CIGui.SelectionEmpty"));
                return;
            }
            ConfigFrame.this.setBusy(true);
            WebServerInfo webServerInfo = null;
            WebServerState webServerState = null;
            for (int i = 0; i <= nArray.length - 1; ++i) {
                webServerInfo = (WebServerInfo)ConfigFrame.this.configList.get(nArray[i]);
                try {
                    WebServerInstaller webServerInstaller = WebServerInstaller.createObject(webServerInfo);
                    webServerState = webServerInstaller.getStateWS();
                    webServerInstaller.upgradeConnector(webServerState.isStarted());
                    continue;
                }
                catch (Exception exception) {
                    ConfigFrame.this.setBusy(false);
                    CIGuiUtil.showWarningMessage((Component)ConfigFrame.this, exception);
                }
            }
            ConfigFrame.this.setBusy(false);
            if (nArray.length == 1) {
                if (webServerState == null || webServerState.isUnknown() || webServerState.isStopped()) {
                    CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Upgrade.OneWebServer"));
                } else if (webServerState.isStarted()) {
                    CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Upgrade.OneRunningWebServer"));
                }
            } else if (nArray.length > 1) {
                CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Upgrade.MultiWebServers"));
            }
            ConfigFrame.this.list.clearSelection();
            ConfigFrame.this.pack();
        }
    }

    private class RemoveSelectedConfigThread
    extends Thread {
        final boolean backup;

        RemoveSelectedConfigThread(boolean bl) {
            this.backup = bl;
        }

        RemoveSelectedConfigThread() {
            this.backup = true;
        }

        @Override
        public void run() {
            int n;
            int[] nArray = ConfigFrame.this.list.getSelectedIndices();
            if (nArray.length == 0) {
                CIGuiUtil.showWarningMessage((Component)ConfigFrame.this, RB.getString(ConfigFrame.this, "CIGui.SelectionEmpty"));
                return;
            }
            ConfigFrame.this.setBusy(true);
            WebServerInfo webServerInfo = null;
            WebServerState webServerState = null;
            for (n = nArray.length - 1; n >= 0; --n) {
                webServerInfo = (WebServerInfo)ConfigFrame.this.configList.get(nArray[n]);
                String string = new File(CIUtil.getJarDir()).getParentFile().getParentFile().getParent() + File.separator + webServerInfo.getInstancename() + File.separator + "wwwroot" + File.separator + "cf_scripts";
                webServerInfo.setCfscriptsPath(string);
                try {
                    WebServerInstaller webServerInstaller = WebServerInstaller.createObject(webServerInfo);
                    webServerState = webServerInstaller.getStateWS();
                    webServerInstaller.removeConnector(webServerState.isStarted(), this.backup);
                    ConfigFrame.this.listModel.remove(nArray[n]);
                    ConfigFrame.this.configList.remove(nArray[n]);
                    continue;
                }
                catch (Exception exception) {
                    ConfigFrame.this.setBusy(false);
                    CIGuiUtil.showWarningMessage((Component)ConfigFrame.this, exception);
                }
            }
            n = ConfigFrame.this.list.getModel().getSize();
            int n2 = Math.min(n, 5);
            ConfigFrame.this.list.setVisibleRowCount(n2);
            ConfigFrame.this.setBusy(false);
            if (nArray.length == 1) {
                if (webServerState == null || webServerState.isUnknown() || webServerState.isStopped()) {
                    CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Remove.OneWebServer"));
                } else if (webServerState.isStarted()) {
                    CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Remove.OneRunningWebServer"));
                }
            } else if (nArray.length > 1) {
                CIGuiUtil.showMessage(ConfigFrame.this, RB.getString(this, "Remove.MultiWebServers"));
            }
            ConfigFrame.this.removeButton.setEnabled(false);
            ConfigFrame.this.upgradeButton.setEnabled(false);
            ConfigFrame.this.pack();
        }
    }
}

