/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.connectorinstaller;

import com.adobe.coldfusion.connector.connectorinstaller.CIUtil;
import com.adobe.coldfusion.connector.connectorinstaller.ConnectorInstallerException;
import com.adobe.coldfusion.connector.connectorinstaller.ObjLineProperties;
import com.adobe.coldfusion.connector.util.FileUtils;
import com.adobe.coldfusion.connector.util.OrderedProperties;
import com.adobe.coldfusion.connector.util.RB;
import com.adobe.coldfusion.connector.util.Trace;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

class iPlanetConfEditor {
    private File m_confFile;
    private Vector m_data;
    private boolean bIsCF;
    private boolean bRemoveCF;
    private String lastInitLine = "";
    private String defaultObjectLine = "";
    private String lastPathCheckLine = "";
    private String findIndexPathCheckLine;
    private String indexNames;
    private String lastObjectTypeLine = "";
    private String servletMappingLine = "";
    private File jrunDir;
    private final String JRUN_COMMENT = "#JRun ";

    public iPlanetConfEditor(File file, boolean bl) throws ConnectorInstallerException {
        if (file == null || !file.exists()) {
            throw new ConnectorInstallerException(RB.getString((Object)this, "ConnectorInstaller.FileNotFound", file));
        }
        this.m_confFile = file;
        this.m_data = new Vector(50, 25);
        this.bIsCF = bl;
    }

    public File remove() throws IOException, ConnectorInstallerException {
        this.writeFile();
        CIUtil.logDebug(RB.getString((Object)this, "CI.RemoveConfig", (Object)"sunJWS", (Object)this.m_confFile));
        return this.jrunDir;
    }

    public void insert(OrderedProperties orderedProperties, Vector vector) throws IOException, ConnectorInstallerException {
        boolean bl = false;
        if (this.defaultObjectLine.length() > 0) {
            int n = this.m_data.indexOf(this.defaultObjectLine);
            if (n >= 0) {
                ObjLineProperties objLineProperties = new ObjLineProperties();
                objLineProperties.put("from", "/cf_scripts");
                objLineProperties.put("dir", orderedProperties.getProperty("CfscriptsDir").replaceAll("\\\\", "/"));
                this.m_data.insertElementAt("NameTrans fn=\"pfx2dir\" " + objLineProperties.toString(), n + 1);
                for (int i = 0; i < vector.size(); ++i) {
                    ObjLineProperties objLineProperties2 = new ObjLineProperties();
                    objLineProperties2.put("from", vector.elementAt(i));
                    objLineProperties2.put("name", "jknsapi");
                    this.m_data.insertElementAt("NameTrans fn=\"assign-name\" " + objLineProperties2.toString(), n + 1);
                }
                ObjLineProperties objLineProperties3 = new ObjLineProperties();
                objLineProperties3.put("worker", orderedProperties.getProperty("worker"));
                this.m_data.addElement("<Object name=\"jknsapi\">");
                this.m_data.addElement("Service fn=\"jk_service\" method=\"*\" " + objLineProperties3.toString());
                this.m_data.addElement("</Object>");
                bl = true;
            }
        } else {
            int n = this.m_data.indexOf(this.lastInitLine);
            if (n >= 0) {
                String string = orderedProperties.getProperty("shlib");
                String string2 = orderedProperties.getProperty("worker_file");
                String string3 = orderedProperties.getProperty("log_level");
                String string4 = orderedProperties.getProperty("log_file");
                String string5 = orderedProperties.getProperty("shm_file");
                if (File.separatorChar == '\\') {
                    string = FileUtils.normalizeSeparator(string);
                    string2 = FileUtils.normalizeSeparator(string2);
                    string4 = FileUtils.normalizeSeparator(string4);
                    string5 = FileUtils.normalizeSeparator(string5);
                }
                ObjLineProperties objLineProperties = new ObjLineProperties();
                objLineProperties.put("shlib", string);
                objLineProperties.put("funcs", orderedProperties.getProperty("funcs", "jk_init,jk_service"));
                this.m_data.insertElementAt("Init fn=\"load-modules\" " + objLineProperties.toString(), n + 1);
                ObjLineProperties objLineProperties4 = new ObjLineProperties();
                objLineProperties4.put("fn", orderedProperties.getProperty("fn", "jk_init"));
                objLineProperties4.put("worker_file", string2);
                objLineProperties4.put("log_level", string3);
                objLineProperties4.put("log_file", string4);
                objLineProperties4.put("shm_file", string5);
                this.m_data.insertElementAt("Init " + objLineProperties4.toString(), n + 2);
                bl = true;
            }
        }
        if (bl) {
            this.writeFile();
            CIUtil.logDebug(RB.getString((Object)this, "CI.AddConfig", (Object)"sunJWS", (Object)this.m_confFile));
        }
    }

    public boolean readFile() throws IOException {
        boolean bl = false;
        CIUtil.logDebug(RB.getString((Object)this, "CI.ParseConfig", (Object)"sunJWS", (Object)this.m_confFile));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_confFile));
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                Object object2;
                if (string.startsWith("Init")) {
                    object2 = new ObjLineProperties();
                    ((ObjLineProperties)object2).fromString(string.substring(4, string.length()));
                    if (((OrderedProperties)object2).getProperty("fn", "").equals("load-modules")) {
                        object = ((OrderedProperties)object2).getProperty("funcs");
                        if (object != null && ((String)object).indexOf("jk_init") >= 0) {
                            bl = true;
                            this.jrunDir = new File(((OrderedProperties)object2).getProperty("shlib"));
                            this.jrunDir = this.jrunDir.getParentFile();
                            continue;
                        }
                    } else if (((OrderedProperties)object2).getProperty("fn", "").equals("jk_init")) {
                        bl = true;
                        continue;
                    }
                    this.lastInitLine = string;
                } else if (string.trim().startsWith("<")) {
                    object2 = string.trim();
                    if (((String)(object2 = ((String)object2).substring(1, ((String)object2).length()).trim())).toLowerCase().startsWith("object")) {
                        object = new StringTokenizer(((String)object2).substring(6, ((String)object2).length() - 1), "=");
                        ((StringTokenizer)object).nextToken();
                        String string2 = ((StringTokenizer)object).nextToken().trim();
                        if (string2.startsWith("\"") && string2.endsWith("\"")) {
                            string2 = string2.substring(1, string2.length() - 1);
                        }
                        if (!string2.equals("jknsapi")) {
                            this.m_data.addElement(string);
                        }
                        while ((string = bufferedReader.readLine()) != null && string.toLowerCase().indexOf("</object>") < 0) {
                            string = string.trim();
                            if (string2.equals("default")) {
                                if (this.defaultObjectLine.length() == 0) {
                                    this.defaultObjectLine = (String)this.m_data.lastElement();
                                }
                                if (string.toLowerCase().startsWith("nametrans") && string.indexOf(" ") >= 0) {
                                    ObjLineProperties objLineProperties = new ObjLineProperties();
                                    objLineProperties.fromString(string.substring(string.indexOf(" "), string.length()));
                                    if (objLineProperties.getProperty("name", "").equals("jknsapi")) {
                                        bl = true;
                                        continue;
                                    }
                                    if (objLineProperties.getProperty("fn", "").equals("assign-name")) {
                                        bl = true;
                                        continue;
                                    }
                                    if (objLineProperties.getProperty("fn", "").equals("pfx2dir") && objLineProperties.getProperty("from", "").equals("/cf_scripts")) {
                                        bl = true;
                                        continue;
                                    }
                                }
                            } else if (string2.equals("jknsapi")) {
                                bl = true;
                                continue;
                            }
                            this.m_data.addElement(string);
                        }
                        if (string.toLowerCase().startsWith("</object>") && string2.equals("jknsapi")) continue;
                    }
                }
                this.m_data.addElement(string);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (Trace.ci && string != null) {
                Trace.trace("parse error in line: " + string);
            }
            throw indexOutOfBoundsException;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            CIUtil.logDebug(iOException.getMessage());
        }
        return bl;
    }

    void writeFile() throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.m_confFile)));
        for (int i = 0; i < this.m_data.size(); ++i) {
            printWriter.println((String)this.m_data.elementAt(i));
        }
        printWriter.close();
        if (this.bRemoveCF) {
            CIUtil.logDebug(RB.getString((Object)this, "CI.RemoveConfigForCF5", (Object)"sunJWS", (Object)this.m_confFile));
        }
        CIUtil.logDebug(RB.getString((Object)this, "ConnectorInstaller.WriteFile", this.m_confFile));
    }
}

