/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.logger;

import com.adobe.coldfusion.connector.logger.FileLogEventHandler;
import com.adobe.coldfusion.connector.util.ExceptionUtil;
import com.adobe.coldfusion.connector.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;

public class LogEvent
implements Serializable {
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_INFO = 4;
    public static final int LOG_DEBUG = 8;
    public static final int LOG_METRICS = 16;
    public static final int LOG_USER = 32;
    public static final int LOG_ACCESS = 64;
    public static final String DEFAULT_FORMAT = "{server.date} {log.level} {log.message}{log.exception}";
    public static final String DEFAULT_ACCESS_FORMAT = "%a %c %m %U %H %s %l";
    protected static String lineSeparator;
    private int type;
    private String message;
    private Throwable throwable;
    private Properties props;
    private String format;
    private String accessformat;
    private Date logTime;
    private Throwable logStack;

    public LogEvent(int n, String string) {
        this(n, string, null);
    }

    public LogEvent(int n, String string, Throwable throwable) {
        this(n, string, throwable, null);
    }

    public LogEvent(int n, String string, Throwable throwable, Properties properties) {
        this.type = n;
        this.message = string;
        this.throwable = throwable;
        this.props = properties;
        this.logTime = new Date();
        this.logStack = new Exception();
    }

    public int getType() {
        return this.type;
    }

    public boolean isError() {
        return (this.type & 1) != 0;
    }

    public boolean isWarning() {
        return (this.type & 2) != 0;
    }

    public boolean isInfo() {
        return (this.type & 4) != 0;
    }

    public boolean isDebug() {
        return (this.type & 8) != 0;
    }

    public boolean isMetrics() {
        return (this.type & 0x10) != 0;
    }

    public boolean isUser() {
        return (this.type & 0x20) != 0;
    }

    public boolean isAccess() {
        return (this.type & 0x40) != 0;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage(String string) {
        if (string == null && (string = this.format) == null) {
            string = FileLogEventHandler.expandServerDate(DEFAULT_FORMAT);
        }
        Properties properties = this.getVariables(string);
        String string2 = PropertiesUtil.expandDynamicVariables(string, this.getLogTime(), properties);
        return string2;
    }

    protected String getExceptionString(Throwable throwable) {
        return ExceptionUtil.exceptionToString(throwable);
    }

    public Properties getVariables(String string) {
        if (string == null) {
            string = FileLogEventHandler.expandServerDate(this.getFormat());
        }
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        this.setType(stringBuffer, this.isDebug(), "debug");
        this.setType(stringBuffer, this.isInfo(), "info");
        this.setType(stringBuffer, this.isWarning(), "warning");
        this.setType(stringBuffer, this.isError(), "error");
        this.setType(stringBuffer, this.isMetrics(), "metrics");
        this.setType(stringBuffer, this.isUser(), "user");
        this.setType(stringBuffer, this.isAccess(), "access");
        properties.put("log.level", stringBuffer.toString());
        properties.put("log.logger.className", "");
        properties.put("log.logger.fullClassName", "");
        properties.put("log.logger.methodName", "");
        properties.put("log.logger.sourceFile", "");
        properties.put("log.logger.line", "");
        String string2 = this.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        properties.put("log.message", string2);
        string2 = "";
        if (this.getThrowable() != null) {
            string2 = lineSeparator + this.getExceptionString(this.getThrowable());
        }
        properties.put("log.exception", string2);
        if (string.indexOf("log.logger.") >= 0) {
            Object object;
            string2 = this.getExceptionString(this.logStack);
            String string3 = null;
            try {
                object = new BufferedReader(new StringReader(string2));
                boolean bl = false;
                while ((string3 = ((BufferedReader)object).readLine()) != null) {
                    if (string3.indexOf("com.adobe.coldfusion.connector.logger.LoggerService.log") >= 0) {
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    break;
                }
            }
            catch (Exception exception) {
                string3 = null;
            }
            if (string3 != null) {
                String string4;
                int n;
                object = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                int n2 = string3.lastIndexOf(" ");
                int n3 = string3.indexOf("(");
                int n4 = string3.indexOf(")");
                int n5 = string3.indexOf(":");
                if (n2 < n3 && (n = (string4 = string3.substring(n2 + 1, n3)).lastIndexOf(".")) > 0) {
                    string7 = string4.substring(n + 1);
                    string6 = string4.substring(0, n);
                    string5 = (n = string6.lastIndexOf(".")) > 0 ? string6.substring(n + 1) : string6;
                }
                if (n3 > 0 && n3 < n4) {
                    if (n5 > n3) {
                        object = string3.substring(n3 + 1, n5);
                        string8 = string3.substring(n5 + 1, n4);
                    } else {
                        object = string3.substring(n3 + 1, n4);
                    }
                }
                if (string5 != null) {
                    properties.put("log.logger.className", string5);
                }
                if (string6 != null) {
                    properties.put("log.logger.fullClassName", string6);
                }
                if (string7 != null) {
                    properties.put("log.logger.methodName", string7);
                }
                if (object != null) {
                    properties.put("log.logger.sourceFile", object);
                }
                if (string8 != null) {
                    properties.put("log.logger.line", string8);
                }
            }
        }
        return properties;
    }

    private void setType(StringBuffer stringBuffer, boolean bl, String string) {
        if (bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setAccessMsgFormat(String string) {
        this.accessformat = string;
    }

    public String getFormat() {
        if (this.format == null) {
            this.format = DEFAULT_FORMAT;
        }
        return this.format;
    }

    public String getAccessMsgFormat() {
        if (this.accessformat == null) {
            this.accessformat = DEFAULT_ACCESS_FORMAT;
        }
        return this.accessformat;
    }

    public Date getLogTime() {
        return this.logTime;
    }

    public String toString() {
        return this.getMessage();
    }

    static {
        if (lineSeparator == null && (lineSeparator = System.getProperty("line.separator")) == null) {
            lineSeparator = "\n";
        }
    }
}

