/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class ClassUtil {
    private static Hashtable primitiveClasses_ = new Hashtable();

    public static Field getField(Class clazz, String string) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static Method getMethod(Class clazz, String string, Class[] classArray) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static Field[] getFields(Class clazz, Class clazz2, boolean bl, boolean bl2) {
        AccessibleObject[] accessibleObjectArray;
        ArrayList<AccessibleObject> arrayList = new ArrayList<AccessibleObject>();
        while (clazz != null) {
            accessibleObjectArray = clazz.getDeclaredFields();
            for (int i = 0; i < accessibleObjectArray.length; ++i) {
                AccessibleObject accessibleObject = accessibleObjectArray[i];
                if (bl2) {
                    int n = ((Field)accessibleObject).getModifiers();
                    if (Modifier.isStatic(n) || Modifier.isFinal(n) || !bl && Modifier.isTransient(n)) continue;
                    if (clazz2 == null) {
                        arrayList.add(accessibleObject);
                        continue;
                    }
                    if (!clazz2.isAssignableFrom(((Field)accessibleObject).getType())) continue;
                    arrayList.add(accessibleObject);
                    continue;
                }
                arrayList.add(accessibleObject);
            }
            clazz = clazz.getSuperclass();
        }
        accessibleObjectArray = arrayList.toArray(new Field[arrayList.size()]);
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        return accessibleObjectArray;
    }

    public static Method findMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method findMethod(Class clazz, String string, Object[] objectArray, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class[] classArray = null;
        if (objectArray != null) {
            classArray = new Class[objectArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                Object object = objectArray[i];
                classArray[i] = primitiveClasses_.containsKey(object) ? (Class)primitiveClasses_.get(object) : classLoader.loadClass((String)object);
            }
        }
        return clazz.getMethod(string, classArray);
    }

    public static String getClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static Class[] getAllClassInterfacesUpTo(Class clazz, Class clazz2) {
        Class[] classArray = null;
        ArrayList arrayList = new ArrayList();
        Class clazz3 = null;
        if (clazz != null) {
            int n;
            Class<?>[] classArray2 = clazz.getInterfaces();
            for (n = 0; n < classArray2.length; ++n) {
                if (arrayList.contains(classArray2[n])) continue;
                arrayList.add(classArray2[n]);
            }
            for (clazz3 = clazz.getSuperclass(); clazz3 != null && !clazz3.getName().equals(clazz2.getName()); clazz3 = clazz3.getSuperclass()) {
                classArray2 = clazz3.getInterfaces();
                for (n = 0; n < classArray2.length; ++n) {
                    if (arrayList.contains(classArray2[n])) continue;
                    arrayList.add(classArray2[n]);
                }
            }
        }
        classArray = new Class[arrayList.size()];
        arrayList.toArray(classArray);
        return classArray;
    }

    public static boolean isJavaPrimitive(String string) {
        return primitiveClasses_.get(string) != null;
    }

    public static boolean implementsType(String string, Class clazz) {
        if (string.equals(clazz.getName())) {
            return true;
        }
        Class[] classArray = ClassUtil.getAllClassInterfaces(clazz);
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Class[] getAllClassInterfaces(Class clazz) {
        return ClassUtil.getAllClassInterfacesUpTo(clazz, Object.class);
    }

    public static String getArrayClassType(Class clazz) {
        String string = new String();
        String string2 = clazz.getName();
        while (string2.startsWith("[")) {
            string = string + "[]";
            string2 = string2.substring(1);
        }
        char c = string2.charAt(0);
        switch (c) {
            case 'B': {
                string2 = "byte";
                break;
            }
            case 'I': {
                string2 = "int";
                break;
            }
            case 'J': {
                string2 = "long";
                break;
            }
            case 'F': {
                string2 = "float";
                break;
            }
            case 'D': {
                string2 = "double";
                break;
            }
            case 'C': {
                string2 = "char";
                break;
            }
            case 'S': {
                string2 = "short";
                break;
            }
            case 'Z': {
                string2 = "boolean";
                break;
            }
            case 'L': {
                string2 = string2.substring(1, string2.length() - 1);
            }
        }
        return string2 + string.toString();
    }

    static {
        primitiveClasses_.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClasses_.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveClasses_.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClasses_.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClasses_.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClasses_.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClasses_.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClasses_.put(Double.TYPE.getName(), Double.TYPE);
        primitiveClasses_.put(Character.class.getName(), Character.class);
        primitiveClasses_.put(Boolean.class.getName(), Boolean.class);
        primitiveClasses_.put(Byte.class.getName(), Byte.class);
        primitiveClasses_.put(Integer.class.getName(), Integer.class);
        primitiveClasses_.put(Long.class.getName(), Long.class);
        primitiveClasses_.put(Short.class.getName(), Short.class);
        primitiveClasses_.put(Float.class.getName(), Float.class);
        primitiveClasses_.put(Double.class.getName(), Double.class);
        primitiveClasses_.put(Date.class.getName(), Date.class);
        primitiveClasses_.put(String.class.getName(), String.class);
    }
}

