/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExceptionUtil {
    public static String[] unwrapMethods = new String[]{"getRootCause", "getTargetException", "getTargetError", "getException", "getCausedByException", "getLinkedException"};

    public static Throwable wrappedException(Throwable throwable) {
        if (throwable instanceof RemoteException) {
            return ((RemoteException)throwable).detail;
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return ExceptionUtil.getRootCauseWithReflection(throwable);
    }

    public static Throwable baseException(Throwable throwable) {
        Throwable throwable2 = ExceptionUtil.wrappedException(throwable);
        if (throwable2 != null) {
            return ExceptionUtil.baseException(throwable2);
        }
        return throwable;
    }

    public static String toString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String getStackTraceUpTo(Throwable throwable, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(ExceptionUtil.toString(throwable), "\n\r");
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string2 = "at " + string;
        while (!bl && stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string2) == -1) {
                stringBuffer.append(string3);
            } else {
                bl = true;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getStackTraceLines(Throwable throwable, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(ExceptionUtil.toString(throwable), "\n\r");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String getCallAt(Throwable throwable, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(ExceptionUtil.toString(throwable), "\n\r");
        try {
            for (int i = 0; i <= n; ++i) {
                stringTokenizer.nextToken();
            }
            String string = stringTokenizer.nextToken();
            int n2 = string.indexOf(32);
            int n3 = string.indexOf(40);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(n2 < 0 ? 0 : n2 + 1, n3 < 0 ? stringBuffer.length() : n3));
            int n4 = string.indexOf(58, n3 < 0 ? 0 : n3);
            if (n4 >= 0) {
                int n5 = string.indexOf(41, n4);
                stringBuffer.append(string.substring(n4, n5 < 0 ? string.length() : n5));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "unknown";
        }
    }

    public static String exceptionToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ExceptionUtil.printExceptionStack(throwable, printWriter, 0);
        return stringWriter.toString();
    }

    protected static void printExceptionStack(Throwable throwable, PrintWriter printWriter, int n) {
        boolean bl = n > 0;
        Throwable throwable2 = ExceptionUtil.wrappedException(throwable);
        if (throwable2 != null) {
            bl = true;
            ExceptionUtil.printExceptionStack(throwable2, printWriter, n + 1);
        }
        if (bl) {
            printWriter.write("[" + n + "]");
        }
        throwable.printStackTrace(printWriter);
    }

    private static Throwable getRootCauseWithReflection(Throwable throwable) {
        for (int i = 0; i < unwrapMethods.length; ++i) {
            Method method = null;
            try {
                method = throwable.getClass().getMethod(unwrapMethods[i], null);
                return (Throwable)method.invoke((Object)throwable, null);
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

