/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPv6Holder {
    private final byte[] ipv6Bytes;

    public IPv6Holder(String string) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        this.ipv6Bytes = inetAddress.getAddress();
    }

    public IPv6Holder(byte[] byArray) {
        this.ipv6Bytes = byArray;
    }

    public static IPv6Holder defaultIPv6Mask() {
        try {
            return new IPv6Holder("[ffff:ffff:ffff:ffff:0:0:0:0]");
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public IPv6Holder applyMask(IPv6Holder iPv6Holder) {
        byte[] byArray = iPv6Holder.getBytes();
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = (byte)(this.ipv6Bytes[i] & byArray[i]);
        }
        return new IPv6Holder(byArray2);
    }

    public boolean equals(Object object) {
        if (object instanceof IPv6Holder) {
            boolean bl = true;
            byte[] byArray = ((IPv6Holder)object).getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                if (this.ipv6Bytes[i] == byArray[i]) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    public byte[] getBytes() {
        return this.ipv6Bytes;
    }
}

