/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import com.adobe.coldfusion.connector.util.IPv6Holder;
import com.adobe.coldfusion.connector.util.RB;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class NetUtil {
    public static final String LOCAL_HOST = "localhost";
    public static final String LOCAL_IP = "127.0.0.1";
    public static final String LOCAL_IPv6 = "[0:0:0:0:0:0:0:1]";
    public static final String LOCAL_IPv6_SHORT = "[::1]";
    public static final String DEFAULT_MASK = "255.255.255.0";
    public static final String DEFAULT_MASKv6 = "[ffff:ffff:ffff:ffff:0:0:0:0]";
    public static final int INT_VALUE_127_0_0_1 = 2130706433;

    public static String resolveIP(String string) throws UnknownHostException {
        InetAddress inetAddress = null;
        inetAddress = string == null || string.equalsIgnoreCase(LOCAL_HOST) || string.equalsIgnoreCase(LOCAL_IP) || string.equalsIgnoreCase(LOCAL_IPv6) || string.equalsIgnoreCase(LOCAL_IPv6_SHORT) ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        return inetAddress.getHostAddress();
    }

    public static String getActualIP(String string) throws UnknownHostException {
        return string.equals(LOCAL_IP) || string.equals(LOCAL_IPv6) || string.equals(LOCAL_IPv6_SHORT) ? InetAddress.getLocalHost().getHostAddress() : string;
    }

    public static int getIpAsInt(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = 0;
            if (n > 0) {
                n <<= 8;
            }
            n2 = Integer.parseInt(string2);
            n += n2;
        }
        return n;
    }

    public static boolean isSocketAccessAllowed(int n, int n2, int n3) {
        boolean bl = false;
        if (n2 == 2130706433 || (n & n3) == (n2 & n3)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isSocketAccessAllowed(IPv6Holder iPv6Holder, IPv6Holder iPv6Holder2, IPv6Holder iPv6Holder3) {
        boolean bl = false;
        if (iPv6Holder.applyMask(iPv6Holder3).equals(iPv6Holder2.applyMask(iPv6Holder3))) {
            bl = true;
        }
        return bl;
    }

    public static int getMaskAsInt(String string) {
        int n = 0;
        if (!NetUtil.validateHostIp(string)) {
            System.out.println(RB.getString(NetUtil.class, "NetUtil.InavlidMask", (Object)string));
            string = DEFAULT_MASK;
        }
        n = NetUtil.getIpAsInt(string);
        return n;
    }

    public static boolean validateHostIp(String string) {
        boolean bl = false;
        if (string != null) {
            int n = 0;
            char[] cArray = string.toCharArray();
            try {
                for (int i = 0; i < cArray.length; ++i) {
                    char c = cArray[i];
                    int n2 = 0;
                    do {
                        if (c < '0' || c > '9') {
                            throw new Exception("internal invalid host");
                        }
                        n2 = n2 * 10 + c - 48;
                    } while (++i < cArray.length && (c = cArray[i]) != '.');
                    if (n2 > 255) {
                        throw new Exception("internal invalid host");
                    }
                    ++n;
                }
                if (n != 4) {
                    throw new Exception("internal invalid host");
                }
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }
}

