/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.coldfusion.connector.util;

import com.adobe.coldfusion.connector.util.ClassUtil;
import com.adobe.coldfusion.connector.util.LoaderObjectInputStream;
import com.adobe.coldfusion.connector.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ObjectUtil {
    private static Field findField(Object object, String string) {
        return ClassUtil.getField(object.getClass(), string);
    }

    public static Method findMethod(Object object, String string, Class[] classArray) {
        try {
            return object.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Object getValue(Object object, String string) throws IllegalAccessException, InvocationTargetException {
        Field field = ObjectUtil.findField(object, string);
        if (field != null) {
            field.setAccessible(true);
            return field.get(object);
        }
        Method method = ObjectUtil.findMethod(object, "get".concat(string = StringUtils.upperCaseFirstInitial(string)), new Class[0]);
        if (method == null && (method = ObjectUtil.findMethod(object, "is".concat(string), new Class[0])) == null) {
            return null;
        }
        return method.invoke(object, (Object[])new Class[0]);
    }

    public static Class getType(Object object, String string) throws IllegalAccessException, InvocationTargetException {
        Field field = ObjectUtil.findField(object, string);
        if (field != null) {
            return field.getType();
        }
        Method method = ObjectUtil.findMethod(object, "get".concat(string = StringUtils.upperCaseFirstInitial(string)), new Class[0]);
        if (method == null && (method = ObjectUtil.findMethod(object, "is".concat(string), new Class[0])) == null) {
            return null;
        }
        return method.getReturnType();
    }

    public static void setValue(Object object, Object object2, Field field) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectUtil.setValue(object, field.getName(), field.getType(), object2);
    }

    public static void setValue(Object object, String string, Class clazz, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Field field = ObjectUtil.findField(object, string);
        if (field != null) {
            field.setAccessible(true);
            field.set(object, object2);
        } else {
            Class[] classArray = new Class[]{clazz};
            Method method = ObjectUtil.findMethod(object, "set".concat(string = StringUtils.upperCaseFirstInitial(string)), classArray);
            if (method == null && (method = ObjectUtil.findMethod(object, "set".concat(string), classArray)) == null) {
                throw new NoSuchMethodException("set".concat(string) + " with args " + classArray[0].getName());
            }
            Object[] objectArray = new Object[]{object2};
            method.invoke(object, objectArray);
        }
    }

    public static String replaceVars(Object object, String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * string.length());
        int n = 0;
        int n2 = string.length();
        do {
            int n3;
            if ((n3 = string.indexOf(123, n)) == -1) {
                n3 = n2;
                stringBuffer.append(string.substring(n, n3));
                break;
            }
            if (n3 > n) {
                stringBuffer.append(string.substring(n, n3));
            }
            if ((n = string.indexOf(125, n3)) == -1) {
                n = n2;
                stringBuffer.append(string.substring(n3, n));
                break;
            }
            String string2 = string.substring(n3 + 1, n);
            Object object2 = null;
            try {
                object2 = ObjectUtil.getValue(object, string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            if (object2 != null) {
                stringBuffer.append(object2);
                continue;
            }
            stringBuffer.append('{').append(string2).append('}');
        } while (++n < n2);
        return stringBuffer.toString();
    }

    public static String getClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static byte[] serialize(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static Object deserialize(byte[] byArray) throws Exception {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LoaderObjectInputStream loaderObjectInputStream = new LoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), byteArrayInputStream);
        return loaderObjectInputStream.readObject();
    }

    public static boolean isObjectPrimitive(Object object) {
        return object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof Long || object instanceof Short || object instanceof Byte || object instanceof Character || object instanceof String;
    }

    public static boolean isObjectPrimitive(String string) {
        return string.equals("java.lang.Integer") || string.equals("java.lang.Boolean") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.lang.Long") || string.equals("java.lang.Short") || string.equals("java.lang.Byte") || string.equals("java.lang.Character") || string.equals("java.lang.String");
    }
}

