/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.consumer.metadata;

import coldfusion.cloud.consumer.metadata.AWSEqualJitterStrategyMetadata;
import coldfusion.cloud.consumer.metadata.AWSFullJitterStrategyMetadata;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.runtime.Cast;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AWSRetryPolicyMetadata {
    static AWSRetryPolicyMetadata instance = null;
    ConsumerMap consumerMap = new ConsumerMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AWSRetryPolicyMetadata getInstance() {
        if (instance != null) return instance;
        Class<AWSRetryPolicyMetadata> clazz = AWSRetryPolicyMetadata.class;
        synchronized (AWSRetryPolicyMetadata.class) {
            instance = new AWSRetryPolicyMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AWSRetryPolicyMetadata() {
        this.consumerMap.put("numRetries", new ConsumerValidator<Object, Object>((filler, val) -> FieldTypecastUtil.INSTANCE.getIntegerProperty(val), null));
        this.consumerMap.put("retryCondition", new ConsumerValidator<Object, Object>((filler, val) -> {
            Map<String, Object> conditionMap = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            this.formRetryCondition(conditionMap);
        }, null));
        this.consumerMap.put("backoffStrategy", new ConsumerValidator<Object, Object>((filler, val) -> {
            Map<String, Object> map = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            this.formBackoffStrategy(map);
        }, null));
        this.consumerMap.put("throttlingBackoffStrategy", new ConsumerValidator<Object, Object>((filler, val) -> {
            Map<String, Object> map = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            this.formBackoffStrategy(map);
        }, null));
    }

    private void formBackoffStrategy(Map<String, Object> map) {
        String strategyType = FieldTypecastUtil.INSTANCE.getStringProperty(map.get("type"));
        if ((map = (Map)map.get("strategy")) != null) {
            switch (strategyType) {
                case "fixedDelay": {
                    Duration duration = FieldTypecastUtil.INSTANCE.getDurationProperty(map.get("fixedDelay"));
                    break;
                }
                case "fullJitter": {
                    ValidatorFiller.INSTANCE.fillObject(null, map, AWSFullJitterStrategyMetadata.getInstance().getConsumerMap());
                }
                case "equalJitter": {
                    ValidatorFiller.INSTANCE.fillObject(null, map, AWSEqualJitterStrategyMetadata.getInstance().getConsumerMap());
                }
            }
        }
    }

    private final void formRetryCondition(Map<String, Object> conditionMap) {
        String conditionType;
        Object condition = null;
        List conditionObjects = null;
        switch (conditionType = FieldTypecastUtil.INSTANCE.getStringProperty(conditionMap.get("type"))) {
            case "and": {
                conditionObjects = FieldTypecastUtil.INSTANCE.getListProperty(conditionMap.get("conditions"));
                if (conditionObjects == null) break;
                conditionObjects.forEach(object -> this.formRetryCondition(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(object)));
                break;
            }
            case "or": {
                conditionObjects = FieldTypecastUtil.INSTANCE.getListProperty(conditionMap.get("conditions"));
                if (conditionObjects == null) break;
                conditionObjects.forEach(object -> this.formRetryCondition(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(object)));
                break;
            }
            case "onStatusCode": {
                FieldTypecastUtil.INSTANCE.getIntegerArrayProperty(conditionMap.get("statusCodes"));
            }
            case "onException": {
                this.getExceptionsSetProperty(conditionMap.get("exceptions"));
            }
            case "onErrorCode": {
                FieldTypecastUtil.INSTANCE.getStringSetProperty(conditionMap.get("errorCodes"));
            }
            case "maxNumberOfRetries": {
                FieldTypecastUtil.INSTANCE.getIntegerProperty(conditionMap.get("retryCount"));
            }
        }
    }

    public Set<Class<? extends Exception>> getExceptionsSetProperty(Object val) {
        HashSet<Class<? extends Exception>> exceptions = new HashSet<Class<? extends Exception>>();
        List exceptionStrings = Cast._List(val);
        if (exceptionStrings != null) {
            exceptionStrings.forEach(string -> {
                try {
                    Class<?> ex = Class.forName(string);
                    exceptions.add(ex);
                }
                catch (Throwable th) {
                    throw new FieldValidationFailedException("Incorrect syntax : Exception class name provided is invalid", th);
                }
            });
        }
        return exceptions;
    }

    public ConsumerMap getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap consumerMap) {
        this.consumerMap = consumerMap;
    }
}

