/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.util;

import coldfusion.cloud.exception.ValidationException;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.validator.FieldValidationFailedException;
import coldfusion.cloud.validator.Validator;
import com.adobe.cfsetup.constants.Messages;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public enum ValidatorFiller {
    INSTANCE;


    public <T> void fillObject(T filler, Map map, ConsumerMap consumerMap) {
        this.fillObject(filler, map, consumerMap, false);
    }

    public <T> void fillObject(T filler, Map map, ConsumerMap consumerMap, boolean skipUnknown) {
        if (Objects.isNull(map)) {
            return;
        }
        HashSet inputKeys = new HashSet(map.keySet());
        Set consumerKeys = consumerMap.keySet();
        if (!skipUnknown) {
            inputKeys.removeAll(consumerKeys);
            if (!inputKeys.isEmpty()) {
                StringBuilder unknownKeys = new StringBuilder();
                inputKeys.forEach(key -> unknownKeys.append((String)key).append(", "));
                String messagePhrase = "Unknown Fields : ";
                if (inputKeys.size() == 1) {
                    messagePhrase = "Unknown Field : ";
                }
                throw new FieldValidationFailedException(messagePhrase + unknownKeys.toString().substring(0, unknownKeys.length() - 2));
            }
        }
        consumerMap.entrySet().forEach(entry -> {
            ConsumerValidator consumerValidator = (ConsumerValidator)entry.getValue();
            Object value = map.get(entry.getKey());
            if (consumerValidator != null) {
                BiConsumer biConsumer;
                List<Validator> validators = consumerValidator.getValidators();
                if (validators != null) {
                    validators.forEach(validator -> {
                        if (!validator.validate(value)) {
                            throw new FieldValidationFailedException("Validation failed for key " + (String)entry.getKey() + " which has value passed as " + value);
                        }
                    });
                }
                if ((biConsumer = consumerValidator.getBiConsumer()) != null && map.containsKey(entry.getKey())) {
                    try {
                        biConsumer.accept(filler, value);
                    }
                    catch (ValidationException ve) {
                        throw ve;
                    }
                    catch (Exception e) {
                        throw new ValidationException(Messages.getString("CLOUD_CREDENTIALS.fieldException", (String)entry.getKey(), e.getMessage()));
                    }
                }
            }
        });
    }
}

