/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.mobile;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MobileServlet {
    private static final Logger logger = LoggerFactory.getLogger(MobileServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMobileRestMapping() {
        String webxml = ".." + File.separator + "wwwroot" + File.separator + "WEB-INF" + File.separator + "web.xml";
        if (!new File(webxml).exists()) {
            return "cfmobile";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(webxml));
            String line = null;
            boolean mappingFound = false;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (line.toLowerCase().contains("<servlet-mapping id=\"coldfusion_mapping_mobile\">")) {
                    mappingFound = true;
                    ++count;
                    continue;
                }
                if (!mappingFound) continue;
                if (count == 2) {
                    String string = line.split("/")[1];
                    return string;
                }
                ++count;
            }
        }
        catch (Exception io) {
            logger.error(io.getMessage(), (Throwable)io);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        return "cfmobile";
    }

    public static void enableCORS(String webroot, boolean enable) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String webxml = webroot + File.separator + "WEB-INF" + File.separator + "web.xml";
        if (!new File(webxml).exists()) {
            webxml = webroot + File.separator + ".." + File.separator + "runtime" + File.separator + "conf" + File.separator + "web.xml";
        }
        if (!new File(webxml).exists()) {
            webxml = webroot + File.separator + ".." + File.separator + ".." + File.separator + "web.xml";
        }
        if (!new File(webxml).exists()) {
            return;
        }
        boolean isFilterPresent = false;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            File file = new File(webxml);
            file.setWritable(true);
            Document mainDoc = builder.parse(file);
            Node parsedDoc = mainDoc.getElementsByTagName("web-app").item(0);
            NodeList nodes = parsedDoc.getChildNodes();
            int c = nodes.getLength();
            for (int i = 0; i < c; ++i) {
                Node node = nodes.item(i);
                if (node == null || !node.getNodeName().equals("filter") && !node.getNodeName().equals("filter-mapping")) continue;
                NodeList inodes = node.getChildNodes();
                block3: for (int ii = 0; ii < inodes.getLength(); ++ii) {
                    Node inode = inodes.item(ii);
                    if (!inode.getNodeName().equals("filter-name")) continue;
                    NodeList iinodes = inode.getChildNodes();
                    for (int iii = 0; iii < iinodes.getLength(); ++iii) {
                        Node iinode = iinodes.item(iii);
                        if (iinode.getNodeValue() == null || !iinode.getNodeValue().equalsIgnoreCase("MobileCORSFilter")) continue;
                        isFilterPresent = true;
                        if (enable) continue;
                        parsedDoc.removeChild(node);
                        --i;
                        continue block3;
                    }
                }
            }
            if (!isFilterPresent && enable) {
                String xml = "<filter> <filter-name>MobileCORSFilter</filter-name> <filter-class>coldfusion.bootstrap.BootstrapFilter</filter-class><init-param>   <param-name>filter.class</param-name>    <param-value>coldfusion.mobile.CORSFilter</param-value>  </init-param></filter>";
                Document doc2 = builder.parse(new ByteArrayInputStream(xml.getBytes()));
                Node node = mainDoc.importNode(doc2.getDocumentElement(), true);
                parsedDoc.appendChild(node);
                xml = "<filter-mapping>  <filter-name>MobileCORSFilter</filter-name>  <url-pattern>/*</url-pattern></filter-mapping>";
                doc2 = builder.parse(new ByteArrayInputStream(xml.getBytes()));
                node = mainDoc.importNode(doc2.getDocumentElement(), true);
                parsedDoc.appendChild(node);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(new File(webxml));
            DOMSource input = new DOMSource(mainDoc);
            transformer.transform(input, output);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isCORSEnabled(String webroot) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String webxml = webroot + File.separator + "WEB-INF" + File.separator + "web.xml";
        if (!new File(webxml).exists()) {
            webxml = webxml + File.separator + ".." + File.separator + "runtime" + File.separator + "conf" + File.separator + "web.xml";
        }
        if (!new File(webxml).exists()) {
            webxml = webroot + File.separator + ".." + File.separator + ".." + File.separator + "web.xml";
        }
        if (!new File(webxml).exists()) {
            return false;
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document mainDoc = builder.parse(new File(webxml));
            Node parsedDoc = mainDoc.getElementsByTagName("web-app").item(0);
            NodeList nodes = parsedDoc.getChildNodes();
            int c = nodes.getLength();
            for (int i = 0; i < c; ++i) {
                Node node = nodes.item(i);
                if (node == null || !node.getNodeName().equals("filter") && !node.getNodeName().equals("filter-mapping")) continue;
                NodeList inodes = node.getChildNodes();
                for (int ii = 0; ii < inodes.getLength(); ++ii) {
                    Node inode = inodes.item(ii);
                    if (!inode.getNodeName().equals("filter-name")) continue;
                    NodeList iinodes = inode.getChildNodes();
                    for (int iii = 0; iii < iinodes.getLength(); ++iii) {
                        Node iinode = iinodes.item(iii);
                        if (iinode.getNodeValue() == null || !iinode.getNodeValue().equalsIgnoreCase("MobileCORSFilter")) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

