/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Cast;
import coldfusion.server.ServiceRuntimeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NoSQLDataSourceConsumer
extends ConsumerMap {
    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ValidatorFiller filler = ValidatorFiller.INSTANCE;
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String REPLICA_SET = "replicaSet";
    public static final String ENABLE_SSL = "ssl";
    public static final String READ_CONCERN = "readConcern";
    public static final String LOCAL = "local";
    public static final String MAJORITY = "majority";
    public static final String LINEARIZABLE = "linearizable";
    public static final String SNAPSHOT = "snapshot";
    public static final String AVAILABLE = "available";
    public static final String READ_PREFERENCE = "readPreference";
    public static final String READ_PREFERENCE_TAGS = "readPreferenceTags";
    public static final String PRIMARY = "primary";
    public static final String SECONDARY = "secondary";
    public static final String PRIMARY_PREFERRED = "primaryPreferred";
    public static final String SECONDARY_PREFERRED = "secondaryPreferred";
    public static final String NEAREST = "nearest";
    public static final String WRITE_CONCERN = "writeConcern";
    public static final String J = "j";
    public static final String WTIMEOUT = "wtimeout";
    public static final String WTIMEOUT_MS = "wtimeoutMS";
    public static final String W = "w";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String MAX_CONNECTION_IDLE_TIME = "maxConnectionIdleTime";
    public static final String MAX_CONNECTION_LIFE_TIME = "maxConnectionLifeTime";
    public static final String MAX_WAIT_TIME = "waitQueueTimeout";
    public static final String MAX_WAIT_QUEUE_SIZE = "maxWaitQueueSize";
    public static final String MIN_SIZE = "minPoolSize";
    public static final String MAX_SIZE = "maxPoolSize";
    public static final String MIN_HEARTBEAT_FREQUENCY = "minHeartbeatFrequency";
    public static final String HEARTBEAT_FREQUENCY = "heartbeatFrequency";
    String[] allowedReadPreferenceValues = new String[]{"primary", "secondary", "primaryPreferred", "secondaryPreferred", "nearest"};
    Set<String> allowedReadPreferenceSet = new HashSet<String>(Arrays.asList(this.allowedReadPreferenceValues));
    String[] allowedReadConcernValues = new String[]{"local", "majority", "linearizable", "snapshot", "available"};
    Set<String> allowedReadConcernSet = new HashSet<String>(Arrays.asList(this.allowedReadConcernValues));

    public NoSQLDataSourceConsumer() {
        this.put(HOST, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {}, Collections.singletonList(NotNullValidator.INSTANCE)));
        this.put(PORT, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(READ_CONCERN, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {}, Arrays.asList(new EnumValidator(this.allowedReadConcernSet, READ_CONCERN))));
        this.put(READ_PREFERENCE, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {}, Arrays.asList(new EnumValidator(this.allowedReadPreferenceSet, READ_PREFERENCE))));
        this.put(WTIMEOUT, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(CONNECT_TIMEOUT, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(MAX_SIZE, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(MIN_SIZE, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(MAX_WAIT_QUEUE_SIZE, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(HEARTBEAT_FREQUENCY, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
        this.put(MIN_HEARTBEAT_FREQUENCY, new ConsumerValidator<Object, Object>((noSQLDataSource, value) -> {
            try {
                this.cast.getIntegerProperty(value);
            }
            catch (Cast.NumberConversionException e) {
                throw new ServiceRuntimeException("Casting failed while converting " + value + " to integer.");
            }
        }, null));
    }
}

